#pragma once

#include "ydb_client.h"

#include <captcha/server/lib/items_storage.h>
#include <captcha/server/lib/config.h>
#include <captcha/server/lib/stats.h>

namespace NCaptchaServer {
    class TCaptchaYdbItemsStorage: public ICaptchaItemsStorage {
    public:
        TCaptchaYdbItemsStorage(const TCaptchaConfig& config, TCaptchaStats& stats);

        NThreading::TFuture<bool> LoadItemData(const TCaptchaItemKey& key, TString& data) override;
        void LoadIndex(TCaptchaItemsIndex& index) override;
        void LoadIndex(TStringBuf type, TCaptchaItemsIndex& index) override;

    private:
        TString CurrentVersion(TStringBuf type);
        void ExtendIndex(TStringBuf type, TStringBuf version, TCaptchaItemsIndex& index);

    private:
        TCaptchaYdbClient Client;

        TString ItemsTableFullPath;

        TString LoadItemDataQuery;
        TString CurrentVersionsQuery;
        TString CurrentVersionSingleQuery;

        TDuration LoadDataTimeout;
        TDuration LoadVersionsTimeout;
        TDuration ReadItemIndexTimeout;
    };
}
