#pragma once

#include "ydb_client.h"

#include <captcha/server/lib/session_factory.h>
#include <captcha/server/lib/session_storage.h>
#include <captcha/server/lib/config.h>
#include <captcha/server/lib/stats.h>

namespace NCaptchaServer {
    class TCaptchaYdbSessionStorage: public ICaptchaSessionStorage {
    public:
        TCaptchaYdbSessionStorage(const TCaptchaConfig& config, TCaptchaStats& stats, TCaptchaSessionFactory& sessionFactory);

        char TokenTag() override {
            return YdbTokenTag;
        }

        NThreading::TFuture<TString> CreateSession(const TCaptchaSessionRequest& request, TCaptchaSessionInfo& info) override;
        NThreading::TFuture<bool> LoadSessionInfo(TStringBuf token, TCaptchaSessionInfo& result) override;
        NThreading::TFuture<bool> StoreSessionInfo(TStringBuf token, const TCaptchaSessionInfo& info) override;
        NThreading::TFuture<void> DropSession(TStringBuf token) override;

        ~TCaptchaYdbSessionStorage();

    private:
        static char YdbTokenTag;

    private:
        void PrepareQueries();

        TMaybe<char> LocationFromToken(TStringBuf token) const;

        TVector<NYdb::NTable::TKeyRange> GetKeyRanges();
        void ReadExpiredTokensChunk(ui64 minTimestamp, TDeque<TString>& tokens, const NYdb::NTable::TKeyRange& keyRange);
        bool CleanupIteration(ui64 minTimestamp);
        void Cleanup();
        static void* CleanerLoop(void* ptr);

    private:
        TCaptchaConfig Config;
        TCaptchaStats& Stats;
        TCaptchaSessionFactory& SessionFactory;
        char CurrentLocationId;

        THashMap<char, THolder<TCaptchaYdbClient>> Connections;
        THashMap<TString, char> LocationToId;
        THashMap<char, TString> IdToLocation;

        THashMap<char, TString> SessionTables;
        THashMap<char, TString> SessionTablesFullPath;
        TString CreateSessionQuery;
        THashMap<char, TString> LoadSessionInfoQueries;
        THashMap<char, TString> StoreSessionInfoQueries;
        THashMap<char, TString> DropSessionQueries;
        TString CleanSessionsQuery;

        TDuration QueryTimeout;
        TDuration CleanSessionsQueryTimeout;

        bool Stopped = false;
        TManualEvent StopEvent;
        TThread CleanerThread;
    };
}
