#!/usr/bin/env python

import argparse
import json
import jinja2
import sys


def parse_args():
    parser = argparse.ArgumentParser(description='Generate config from template')
    parser.add_argument('-i', '--input', default=sys.stdin, type=argparse.FileType('r'), help='Path to template (defaults to stdin)')
    parser.add_argument('-o', '--output', default=sys.stdout, type=argparse.FileType('w'), help='Path to result (defaults to stdout)')
    return parser.parse_args()


def combine_dicts(d1, d2):
    for k, v in d2.iteritems():
        if k in d1 and isinstance(v, dict) and isinstance(d1[k], dict):
            d1[k] = combine_dicts(d1[k], v)
        else:
            d1[k] = v


def combine_json_dicts(d1, d2):
    d1 = json.loads(d1)
    d2 = json.loads(d2)

    for k, v in d2.iteritems():
        if k in d1 and isinstance(v, dict) and isinstance(d1[k], dict):
            combine_dicts(d1[k], v)
        else:
            d1[k] = v

    return json.dumps(d1)


def parse_config(configfile):
    env = jinja2.Environment(
        block_start_string='<%',
        block_end_string='%>',
        variable_start_string='<<',
        variable_end_string='>>',
        comment_start_string='<#',
        comment_end_string='#>')

    env.filters['combine_json_dicts'] = combine_json_dicts

    template = env.from_string(configfile.read().decode('utf8'))
    return json.loads(template.render())


def main():
    args = parse_args()
    config = json.dumps(parse_config(args.input), indent=4, ensure_ascii=False).encode('utf-8')
    print >>args.output, config


if __name__ == '__main__':
    main()
