#!/usr/bin/env python

import libarchive


def read_archive(path):
    with libarchive.Archive(path) as archive:
        for entry in archive:
            if not entry.isfile():
                continue
            yield {
                'name': entry.pathname.encode('latin1'),
                'content': archive.read(entry.size)
            }
