package ru.yandex.ci.flow.engine.runtime.events;

import java.util.Set;

import lombok.ToString;

import ru.yandex.ci.flow.engine.runtime.TmsTaskId;
import ru.yandex.ci.flow.engine.runtime.state.model.JobLaunch;
import ru.yandex.ci.flow.engine.runtime.state.model.JobState;
import ru.yandex.ci.flow.engine.runtime.state.model.StatusChange;
import ru.yandex.ci.flow.engine.runtime.state.model.StatusChangeType;

@ToString
public class JobForceSuccessEvent extends JobLaunchEvent {
    private static final Set<StatusChangeType> SUPPORTED_STATUSES = Set.of(
            StatusChangeType.QUEUED
    );

    private final TmsTaskId tmsTaskId;
    private final boolean conditionalSkip;

    public JobForceSuccessEvent(String jobId, int jobLaunchNumber, TmsTaskId tmsTaskId) {
        this(jobId, jobLaunchNumber, tmsTaskId, false);
    }

    public JobForceSuccessEvent(String jobId, int jobLaunchNumber, TmsTaskId tmsTaskId, boolean conditionalSkip) {
        super(jobId, jobLaunchNumber, SUPPORTED_STATUSES);
        this.tmsTaskId = tmsTaskId;
        this.conditionalSkip = conditionalSkip;
    }

    @Override
    public StatusChange createNextStatusChange() {
        return StatusChange.forcedExecutorSucceeded();
    }

    @Override
    public void afterStatusChange(JobLaunch jobLaunch, JobState jobState) {
        jobLaunch.setTmsTaskId(tmsTaskId);
        jobState.setConditionalSkip(conditionalSkip);
    }
}
