# Быстрый контур

Быстрый контур - это часть процесса сборки в Аркадии. Она работает аналогично полному
контуру, но, в отличие от него, затрагивает не все модули, а только тот минимум,
который позволяет проверить ваши изменения. Это позволяет быстро получить результат сборки
и тестирования вашего кода. Успешное завершение быстрого контура позволяет быстрее получить
полезный сигнал, но не позволяет смежить Pull Request. Для этого нужно, чтобы прошёл полный
контур. То есть, если изменения в ваших модулях - быстрый контур это оперативно покажет,
но могут быть поломки в коде который от вас зависит, поэтому нужно дождаться полного.


Быстрый контур выполняется параллельно с полным и не замедляет его. Наоборот, из-за
того, что полный контур переиспользует результаты быстрого, время его выполнения сокращается.


## Настройка
Настроить быстрый контур у себя в проекте можно положив в директорию с вашим проектом `a.yaml` конфиг со следующим содержанием:
```yaml
ci:
  autocheck:
    fast-targets:
      - arcadia_root_relative/dir/with/ya_make
      - arcadia_root_relative/dir/with/another/ya_make
```
Пример конфига в [репозитории](https://a.yandex-team.ru/arc/trunk/arcadia/ci/core/src/test/resources/ayaml/only-ci-autocheck-fast-targets-test.yaml?rev=7334346).

Обратите внимание, что конфиг даёт возможность ограничить скоуп выполнения
быстрой проверки, но не заставляет размечать зависимости, дублируя `ya.make`-файлы.
В секции `fast-targets` достаточно указать путь для корневого `ya.make` нужного
проекта, в котором может не быть buildable таргетов, а только список `RECURSE`-ов
(пример [тут](https://a.yandex-team.ru/arc/trunk/arcadia/devtools/distbuild/a.yaml?rev=7334346)
или [тут](https://a.yandex-team.ru/arc/trunk/arcadia/ci/a.yaml?rev=7324401#L41)).

Мы, как обычно, построим сборочный граф (уже не на всю Аркадию, а маленький и очень быстро)
и запустим то, что реально изменилось, только среди сконфигурированных целей.
Для каждого изменённого файла в ревью мы ищем первый ближайший (вверх по иерархии
директорий) `a.yaml`, в котором присутствует секция `fast-targets` и включаем
в быстрый контур все перечисленные в ней таргеты. То есть, более глубокие
`fast-targets` переопределяют список таргетов, а указав пустую секцию,
можно и вовсе быстрый контур отключить.

## Автоматический быстрый контур
Если быстрый контур не настроен в `a.yaml`-файлах, система сборки попытается определить быстрый контур
автоматически на основе списка изменённых файлов.

Автоматический быстрый контур не появится, если мы посчитаем, что изменения затрагивают слишком много различных директорий одновременно.

