# Попроектный Strong Mode

Режим позволяет сказать: "Для разработчиков abc-сервиса (владельцев компонета) любые поломки в нём ([`timeout`/`muted`-тесты или уже имеющиеся `regular`
поломки](badge.md)) должны красить плашку (считать проверку сломанной) и блокировать Merge".


Strong Mode включается добавлением в **a.yaml** опции `ci.autocheck.strong`.

* В этом примере любые поломки в директории с конфигом будут красить плашку входящим в скоуп `development` (например, имеющим роль "Разработчик" или "Разработчик интерфейсов") в сервисе `my_abc_service_slug`.

```
service: my_abc_service_slug
ci:
  autocheck:
    strong: true
```

Примеры ниже могут пригодиться, если в ваш сервис коммитят не только core-разработчики.

* В этом примере любые поломки в директории с конфигом будут красить плашку входящим в скоуп `devops`

```
service: my_abc_service_slug
ci:
  autocheck:
    strong:
      abc-scopes: devops
```

* В этом примере любые поломки в директории с конфигом будут красить плашку входящим в скоупы `development` и `devops`

```
service: my_abc_service_slug
ci:
  autocheck:
    strong:
      abc-scopes: [development, devops]
```

# Частые вопросы
### Как включить Strong mode в моем проекте для всех разработчиков аркадии?
Это невозможно, так как будет блокировать разработку общих компонентов падением мигающих тестов.

### Что произойдёт, если кто-то сделает ломающий коммит в соседний проект, от которого зависит наш код и этот кто-то не входит в команду сервиса?

- Существущие поломки не влияют на тех, кто делает глобальные рефакторинги. То есть они не покрасят плашку
- Новые поломки по-прежнему будут красить плашку (несмотря на то, что автор коммита не входит в скоупы со Strong Mode'ом)
- Новая поломка, упавшая с timeout'ом, не красит плашку для автора коммита (почему - описано в разделе про [timeout'ы](badge.md#timeout)).
  Однако разработчик проекта, сделав следующий коммит, получит красную плашку, если тест снова упадёт с timeout'ом.

### Допустим, мы починили все свои тесты. В чём теперь для нас смысл Strong Mode? Новые поломки плашку и так красят, а старых нет.
- Есть целый ряд новых поломок, при которых плашка не красится - Timeout, Flaky, Internal ошибки.
- CI может замьютить тесты в проекте, если решит, что они мигают.
- В trunk'е могут появится поломки из-за параллельных изменений. CI не гарантирует, что проверка пройдет на той же ревизии, на которой он мерджится в trunk.
- Во всех этих случаях плашка будет зеленая. Попроектный Strong Mode спасает от таких поломок
