# Основы a.yaml

{% note info %}

Видео по теме можно посмотреть по [ссылке](https://jing.yandex-team.ru/files/andreevdm/PublicCI_1-2.mp4).

{% endnote %}


CI для описания flow использует единый конфигурационный файл **a.yaml**, который хранится вместе с кодом проекта. Это дает возможность:

* Версионировать описание flow;
* Вносить атомарные изменения в flow вместе с кодом;
* Проверять изменения в настройках flow в пулл-реквестах (вручную и автоматически);
* Использовать изменения конфигурации "на лету" при запуске CI в пулл-реквесте.

В одном файле **a.yaml** могут описываться настройки проекта для разных систем. Например, **a.yaml** может выглядеть так:

```yaml
service: my-abc-service-slug
title: My Project
arcanum:
  # Все, что связано с Arcanum
ci:
  # Все, что связано с CI
```

При этом в поле `ci` находятся настройки CI, а в поле `arcanum` - настройки [Arcanum](https://docs.yandex-team.ru/arcanum/), в частности настройки [Merge требований](https://docs.yandex-team.ru/arcanum/pr/merge-reqs).

## Расположение файлов { #placement }

* В каталоге вашего проекта и во вложенных каталогах может храниться произвольное количество файлов **a.yaml** (по одному файлу в каталоге).
* Настройки в конфигурационном файле **a.yaml** применяются ко всем файлам, которые лежат в том же каталоге и во всех вложенных каталогах.

## Основные разделы { #sections }

{% note info %}

Файл **a.yaml** валидируется [по JSON схеме](https://a.yandex-team.ru/arc/trunk/arcadia/ci/config-schema/src/main/resources/ci-config-schema/a-yaml.yaml).

{% endnote %}

Типичный файл **a.yaml** выглядит следующим образом:

```yaml
service: my-abc-service-slug # Сервис в ABC, к которому относится конфигурация (https://abc.yandex-team.ru/services/ci/)
title: My Project in CI # Описание назначения файла (отображается в веб-интерфейсе на странице проекта)

ci:
  secret: sec-XXXXXX # Секрет в Секретнице, откуда берутся все токены и ключи (https://yav.yandex-team.ru)

  runtime: # Конфигурация сред исполнения задач
    sandbox-owner: CI # Название группы в Sandbox, в рамках которой настроены квоты (https://docs.yandex-team.ru/sandbox/quota)

  releases: # Описания релизов
    my-main-release: # Один из релизов
      title: My Main Release
      flow: my-release-flow

  actions:
     my-pr-flow:
        flow: my-pr-flow
        triggers: # Условия, при которых автоматически запускаются покоммитные flow
          - on: pr
     my-commit-flow:
        flow: my-commit-flow
        triggers:
          - on: commit

  flows: # Описания всех доступных flow и их задач
    my-release-flow: # Один из flow
      title: Release Flow
      jobs:
        # Описание задач

    my-pr-flow:
      title: Flow for Pull Requests
      jobs:
        # Описание задач

    my-commit-flow:
      title: Flow on Merge to Trunk
      jobs:
        # Описание задач
```

Основные настройки располагаются в поле `ci` и включают в себя:

1. Поле `secret` - идентификатор секрета в [Секретнице](https://yav.yandex-team.ru/), откуда CI загружает все секретные данные, используемые в flow. Минимально в этом секрете в ключе `ci.token` хранится токен, используемый для получения ревизий из системы контроля версия и для запуска задач в среде исполнения (например, в [Sandbox](https://sandbox.yandex-team.ru/)).
2. Поле `runtime` хранит настройки сред исполнения, используемых CI для выполнения конкретных задач. Например, в поле `sandbox-owner` хранится название группы в Sandbox, от которой будет отниматься квота при запуске задач. Допускается расширенная версия конфигурации:

    ```yaml
       runtime:
         sandbox:
           owner: CI
           # Дополнительные теги, которые будут присвоены sandbox-задачам
           # Выбирайте такие тэги, под которые попадут сразу много задач (это низкоселективный индекс)
           tags:
             - MY_PROCESS
           # Дополнительные Sandbox hint-ы, которые будут присвоены sandbox-задачам
           # Это высокоселективный индекс, поэтому каждая задача может иметь уникальный hint
           hints:
             - MY_HINT
    ```
   Более подробную информацию вы найдете в разделе [Среды выполнения](runtime.md).

3. Поле `releases` содержит описания релизов. Каждый релиз обязательно имеет набор полей с метаданными (например, `title`) и поле `flow` с названием flow, который следует запускать во время релиза.
4. Поле `triggers` содержит описания условий, при которых запускаются покоммитные flow (**actions**). Например, можно запускать один сценарий на пулл-реквесты и другой после того, как изменения попали в `trunk`.
5. Поле `flows` содержит описания самих flow, т.е. конкретные задачи, которые нужно выполнять. Подробности о том, как описывать flow, приведены в следующем разделе.

## Версионирование файлов { #revisions }

Поскольку файл **a.yaml** лежит в едином репозитории и меняется вместе с кодом продукта, каждый запускаемый flow использует конкретную версию этого файла. Если вы запускаете flow вручную, то всегда можете выбрать конкретный коммит, из которого нужно брать **a.yaml**. Если этого не делать, то в зависимости от типа flow версия файла выбирается по-разному:

* При запуске **релиза** по умолчанию используется версия **a.yaml** из последнего коммита, который попал в релиз.

* При проверке **пулл-реквеста** берется последняя версия **a.yaml** из ветки trunk, если сам пулл-реквест не вносит изменений в **a.yaml**. В противном случае используется измененная версия **a.yaml** из пулл-реквеста.

* При выполнении flow после добавления коммитов в ветку `trunk` или релизную ветку, используется последняя версия **a.yaml** из этой ветки.

