# Система CI Storage

## Введение
Целью системы является сбор, обработка и хранение результатов и метрик тестов. Количество результатов непрерывно
возрастает, поэтому система должна быть горизонтально масштабируемой и не должна замедлять другие системы автосборки.
Для этого используется асинхронная обработка, построенная на очереди
сообщений [Logbroker](https://logbroker.yandex-team.ru/docs/). Результаты обработки отображаются
в [плашке](../../autocheck/badge.md). Он позволяет как выполнить отложенную обработку, так и распределить нагрузку.
Документация по мониторингам находится [тут](storage-monitorings.md).

## Термины

* Storage / сторадж – система CI Storage.
* Плашка – визуальное отображение результатов проверки.
* Check / проверка – соответствующая одной проверке. Однозначно определяется левой, правой ревизиями и набором тегов.
* Iteration / итерация – запуск в рамках одной проверки набора автосборочных задач.
* MetaIteration / мета-итерация – объединение всех итераций одного типа по проверке.
* CheckTask / таска – автосборочная задача, запущенная в рамках одной итерации, может быть левой или правой.
* Main stream / основной поток – основной поток результатов от автосборочных задач на вход стораджу, состоит из
  нескольких топиков Logbroker.
* storage-reader / ридер – сервис, который читает основной поток, распределяет данные по шардам и собирает агрегаты.
* storage-shard / шард – сервис обрабатывающий результаты тестов.
* storage-api / апи – сервис предоставляющий grpc ручки внешним клиентам.
* storage-tms / тмс – сервис, выполняющий крон задачи.
* suite / сьюта – сущность автосборки, объединяющая набор тестов и имеющая свой статус.
* toolchain / тулчейн – платформа, на которой запускается тест.
* chunk / чанк – единица [шардирования](#sharding) сьют.
* diff / диф – сущность сравнивающая результат теста слева и справа.
* ChunkAggregateEntity / агрегат чанка итерации
  – [сущность](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/db/model/chunk_aggregate/ChunkAggregateEntity.java?rev=r8405319#L23)
  , которая хранит в себе статистику по сьютам и тестам одного чанка конкретной итерации.

## Топики Logbroker

Корневая [директория](https://logbroker.yandex-team.ru/lbkx/accounts/ci/autocheck?page=browser&type=directory) топиков
разделена на среды: stable, prestable, testing.

* events – служебные сообщения стораджа.
* main/trunk/postcommit – основной поток по посткоммитам из транка.
* main/trunk/precommit – основной поток по прекоммитам из транка.
* main/branch/postcommit – основной поток по посткоммитам из бранчей.
* main/branch/precommit – основной поток по прекоммитам из бранчей.
* shard/in – входной поток шарда.
* shard/out – выходной поток шарда.

## Базы

* [YDB stable](https://yc.yandex-team.ru/folders/foonmi1hkk792qrrgsi6/ydb/database/etn03uj46f26s4tgai6e)
* [YDB prestable](https://yc.yandex-team.ru/folders/foonmi1hkk792qrrgsi6/ydb/database/etn01lu9nj7uu7t4363i)
* [YDB testing](https://yc.yandex-team.ru/folders/foonmi1hkk792qrrgsi6/ydb/database/etn000dg9k8viqj25mdc)

## Общая архитектура

Происходит регистрация проверки в апи, регистрация итерации для созданной проверки, затем регистрация тасок по созданной
итерации. Далее запускается автосборочная задача, которая записывает результаты в основной поток. При записи указывается
идентификатор таски, которой был выдан при регистрации.

Из основного потока результаты вычитывают инстансы storage-reader, разбивают их на чанки и отправляют данные по каждому
чанку в определенную таблицей [шардирования](#Шардирование) партицию топика shard/in. Logbroker гарантирует, что каждую
партицию одного топика читает строго один инстанс storage-shard. Шард вычитывает результаты из топика storage-shard,
сохраняет результаты и метрики. Далее разбивает результаты по итерациям и высчитывает для каждой итерации статистику
чанка и отправляет ее в партицию топика shard/out. Партиция shard/out определяется на этапе регистрации проверки. Так
все результаты по одной итерации попадают в одну партицию shard/out, а затем в один инстанс storage-reader, который
суммирует агрегаты по всем чанкам и сохраняет результирующую статистику по итерации.

## storage-reader

Помимо результатов из основного потока на reader приходят сообщения о завершении партиций тасок, статистика выполнения и
служебные сообщения автосборки. Эти сообщения ридер записывает в произвольную партицию shard/out, для того, чтобы шард
разбил их по итерациям и направил через shard/out на того ридера, который обрабатывает соответствующую итерацию. Это
позволяет избежать конкурентной работы с итерацией между несколькими ридерами.

Так как нагрузка на ридер небольшая, он синхронно обрабатывает чтения из логброкера в
потоках [LogbrokerReadWorker](#Чтение-Logbroker).

### Завершение проверок

Каждая таска автосборки состоит из нескольких партиций автосборки, для того чтобы считать таску автосборки завершенной,
ридеру нужно получить сообщение о завершении каждой партиции автосборки. Количество партиций в таске указывается при
регистрации таски. При завершении каждой таски, если все остальные таски завершены, ридер завершает итерацию. Если
завершены все итерации проверки, то она переводится в статус завершенной. Так как завершение является критичной для
понимания происходящего операцией, в ней мы не можем полагаться на кеш.

## storage-shard

Шард является самым нагруженным сервисом в сторадже, поэтому в нем используется агрессивное кеширование (целиком
полагаемся на данные в кеше) и распределение по различным очередям, чтобы получить максимальный параллелизм и
независимость обработки. При замедлении обработки, шарда, область замедления можно определить по очереди, размер которой
вырос. Коммит результата осуществляется только после того, как он прошел все очереди.

Рассмотрим процесс обработки данных на шарде более подробно. Чтение из логброкера
от [LogbrokerReadWorker](#Чтение-Logbroker), поступает
в [ShardInReadProcessor](https://a.yandex-team.ru/arc_vcs/ci/storage-shard/src/main/java/ru/yandex/ci/storage/shard/message/ShardInReadProcessor.java?rev=r8438487)
, он десериализует сообщения и разделяет их на сообщения по чанкам(ChunkMessage) и проксируемые(Forwarding). Forwarding
он сразу записывает в соответствующую очередь shard/out, а сообщения по чанкам
передает [ChunkPoolProcessor](https://a.yandex-team.ru/arc_vcs/ci/storage-shard/src/main/java/ru/yandex/ci/storage/shard/message/ChunkPoolProcessor.java?rev=r8443598#L117)
, который разбивает их на несколько очередей по чанкам. Далее поток обработки ChunkPoolProcessor берет несколько
сообщений из очереди и обрабатывает их пачкой. Он прогревает кеши, записывает результаты и метрики балк инсертом в YDB,
а затем формирует из каждого сообщения сообщение по чанку итерации и передает их в сервис вычисления
агрегатов [AggregatePoolProcessor](https://a.yandex-team.ru/arc_vcs/ci/storage-shard/src/main/java/ru/yandex/ci/storage/shard/message/AggregatePoolProcessor.java?rev=r8447495)
. AggregatePoolProcessor распределяет сообщения на несколько очередей в соответствии с идентификатором итерации(чтобы не
было гонок между данными одной итерации), для многопоточной обработки. Поток обработки AggregatePoolProcessor выбирает
пачку сообщений из внутренней очереди, группирует их по агрегату итерации и
затем [вычисляет](https://a.yandex-team.ru/arc_vcs/ci/storage-shard/src/main/java/ru/yandex/ci/storage/shard/message/AggregatePoolProcessor.java?rev=r8447495#L242)
новый агрегат.

Сообщения финиширования проходят все те же очереди, что и результаты. Это необходимо чтобы не завершить чанк раньше
обработки всех результатов.

## Шардирование {#sharding}

Шардирование осуществляется по сьютам, так как статус теста зависит от статуса сьюты, в которую он входит и их нужно
обрабатывать на одном хосте. Сьюты разбиваются на чанки, для каждого типа результата –
свой [набор](https://a.yandex-team.ru/arc_vcs/ci/proto/storage/common.proto?rev=r8432483#L127) чанков. Для разбиения
используется
функция [шардирования](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/sharding/ChunkDistributor.java?rev=r8384336#L46)
, которая присваивает сьюте определенный номер чанка.

Каждый чанк помещается
в [таблицу](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/db/model/chunk/ChunkEntity.java?rev=r8405319#L17)
шардирования, в которой ему присваивается номер партиции Logbroker.

## Чтение Logbroker

[LogbrokerStreamConsumer](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/message/LogbrokerStreamConsumer.java?rev=r8258924)
конфигурирует чтение из логброкера.

[LogbrokerStreamListener](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/logbroker/LogbrokerStreamListener.java?rev=r8435816)
распределяет чтения от Logbroker по очередям. Номер очереди определяется по партиции Logbroker, из которой поступило
чтение. Каждую очередь обрабатывает отдельный
поток [LogbrokerReadWorker](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/logbroker/LogbrokerReadWorker.java?rev=r8186681)

Каждому
чтению [LogbrokerPartitionRead](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/logbroker/LogbrokerPartitionRead.java?rev=r8172931)
присваивается [LbCommitCountdown](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/logbroker/LbCommitCountdown.java?rev=r8388967)
который следит за количеством обработанных сообщений. Когда все сообщения из чтения обработаны, происходит коммит
чтения. Это позволяет обрабатывать сообщения из одного чтения в разных потоках.

## Подсчет статистики

Статистика дифа хранится
в [TestDiffStatistics](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/db/model/test_diff/TestDiffStatistics.java?rev=r8113128)

Иерархия статистики теста платформы T. Статистика влияет на все родительские агрегаты (расположены ниже).

               Test (T)
           /              \
    Test (@all)         Suite(T)
        |                  |
    Suite (@all)         Chunk(T)
        |
     Chunk (@all)

* Test (T) – агрегат теста.
* Test (@all) – агрегат теста по всем платформам.
* Suite(T) – агрегат сьюты по тулчейну.
* Suite (@all) – агрегат сьюты по всем платформам.
* Chunk(T) – агрегат чанка по платформе.
* Chunk (@all) – агрегат чанка по всем платформам.

При обработке результата теста, берется вся текущая иерархия дифа, откатывается, изменяется, затем заново накатывается.
При накате дифа статистика изменяется сверху вниз, диф влияет на агрегат по платформе и агрегат по сьюте. Они в свою
очередь влияют на агрегат по сьюте по всем платформам и на агрегат чанка по платформе соответственно. Далее агрегат по
сьюте по всем платформам влияет на агрегат по чанку по всем платформам. При откате все действия происходят в обратном
порядке.

## Мета-итерация

Для объединения результатов нескольких итераций одного типа используется мета-итерация, она имеет номер 0. При получении
нового результата в итерации с номером больше 1, диф и все его родительские дифы копируются в мета-итерацию (если они не
были скопированы туда ранее). Далее результат обрабатывается для текущей итерации, затем для мета-итерации. При
обработке в мета-итерации диф откатывается, изменяется и заново накатывается. В обычной итерации статус теста берется из
предыдущих итераций.

## YDB

Производительность стоража критически зависит от производительности базы YDB. Производительность YDB при этом при
большом потоке записи зависит напрямую от распределения данных по шардам. Один из способов равномерного распределения
это использовать первой колонкой хеш от части первичного ключа и заранее определить количество партиций. Но это не
позволяет использовать range запросы по первичному ключу.

Повысить скорость записи можно перейдя на блочную вставку bulk insert, но оно не работает с транзакциями. Для обхода
этого ограничения
в [TestDiffByHashEntity](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/db/model/test_diff/TestDiffByHashEntity.java?rev=r8439412)
, [TestDiffByIterationEntity](https://a.yandex-team.ru/arc_vcs/ci/storage-core/src/main/java/ru/yandex/ci/storage/core/db/model/test_diff/TestDiffByIterationEntity.java?rev=r8439412)
используется комбинация транзакционной вставки TestDiffByHashEntity с хешом в первой колонке и балк инсертом
TestDiffByIterationEntity для дальнейшего поиска по первичному ключу.

