Стиль разработки
----------------

### Комментарии в PR
Должны быть на английском языке.

### Комментарии в коде
Допускаются на русском языке.
Если уровень английского выше, чем "mgimo finished", то можно писать по-английски.

### YDB Naming conventions
- Имена таблиц - PascalCase
- Имена колонок - camelCase

### Protobuf naming convention
Придерживаемся [Protobuf Style Guide](https://developers.google.com/protocol-buffers/docs/style),
 за исключением отступа, принимаем 4 пробела.

TL;TD:
- Имена сообщений, сервисов и enum - CamelCase \
  `message SongServerRequest`
- Имена полей - snake_case \
  `string song_name = 1;`
- Множественное число для repeated полей \
  `repeated MyMessage accounts = 17;`
- Значение enum - SCREAMING_SNAKE_CASE
  ```
  enum Foo {
     FOO_UNSPECIFIED = 0;
  }
  ```
- Методы сервисов - CamelCase \
  `rpc GetSomething(GetSomethingRequest) returns (GetSomethingResponse);`


### Нейминг
- Status - enum
- State объект с описанием состояния, обычно включающий в себя Status-enum и ряд дополнительных полей.


### Форматирование кода
Форматирование кода стандартное, соответствующее `LINT(extended)`.

Заголовки файлов вида
```
/**
 * @author Name Surname (email@yandex-team.ru)
 * @since 22.01.2020
 */
```

не нужны (их можно удалить, если встретятся).

### Работа с Nullable

В целом следуем [Практики java-разработки. Optional&null-safety](https://clubs.at.yandex-team.ru/java/888), т.е.

- Обязательные поля классов рекомендуется помечать `@lombok.NonNull`
- Необязательные поля - `@Nullable`
- Для возвращаемых публичных методов `Optional`
- Для внутренних `private` методов допустимо возвращать `null` с аннотацией `@Nullalble`
- Для аргументов помечать `@Nullable`
- Вешать [package-info для всех пакетов]( https://a.yandex-team.ru/arc_vcs/ci/core/src/main/java/ru/yandex/ci/core/flow/package-info.java?rev=11c094011da766ed8dcaf9411b7ee97995028a22)
- Все новые поля в объектах должны быть либо `@Nullable`, либо инициализироваться через `@Builder`.
  **Внимание:** использовать `@lombok.Builder.Default` для `List` и `Map` нельзя!

### Общая схема работы с YDB
1) Вся работа с YDB должна выполняться через интерфейсы ORM. Таблицы YDB должны наследоваться от `ru.yandex.ci.common.ydb.KikimrTableCi`.
2) Все поля `Entity`, которые не могут быть `null`-ами, должны быть помечены аннотациями Lombok `@lombok.NonNull` (существующие поля не помечены, но будут с течением времени). Для новых примитивных полей необходимо будет создать конструктор с объектным типом (текущее ограничение ORM). Сами поля остаются опциональными (текущее ограничение ORM).
3) Все `Entity` объекты должны быть `@Value`. Использовать ли `@Builder` - зависит от сложности объекта (если поле больше 3-4, то лучше использовать).
4) Все `Entity.Id` объекты должны быть `@Value(staticConstructor = "of")`
5) Транзакции должны открываться снаружи таблиц.
6) Не нужно делать вложенные транзакции - всегда нужно использовать `currentOrTx` или `currentOrReadOnly` вместо обычных `tx` и `readOnly`.
7) Все объекты, которые могут быть сериализованы в БД, должны быть помечены аннотацией `@Persisted`
8) Называть классы "<что-то>Entity", например BookEntity

### Работа с объектами/Lombok

- Используем `Builder`-ы там, где можно.
- `Lombok` разрешен.
- `Builder`-ы `Lombok` используются без префикса `with` (по умолчанию)
- Опции `@With` разрешены

### Работа с тестами

- Тестовый фреймворк - `JUnit 5`.
- Проверочный фреймворк - `AssertJ` (использование встроенных ассертов `JUnit` можно менять на ассерты `AssertJ`).
- Если нужно сравнить результат вызова GRPC методов с эталонными файлами - нужно хранить эталонные файлы в формате `pb` (текстовый protobuf).

## Работа со Spring-ом

### Правила работы с конфигурациями Spring
https://wiki.yandex-team.ru/market/mbo/development/spring/ - взят за основу
1. Не использовать в классах бинов Spring аннотации - вся логика создания и установки зависимостей должна быть в Java конфиге.
1. Конфиги зависят только от других конфигов, бины только от других бинов. Конфиги не наследуем друг от друга - чтобы при автовайринге конфигов была однозначность.
1. Зависимость одного конфига от другого определять с помощью аннотации `@Import` (нужно чтобы каждый конфиг был самодостаточен и мог быть заимпортирован куда угодно без доп условий).
1. Все бины в конфиге должны быть разрезолвлены Идеей - т.е. сообщений вида "Could not autowire" быть не должно (за единственным исключением - `CiMainDb` в `core`). Если какого-то бина не хватает для текущего конфига - нужно импортировать конфиг с этим бином. Автовайрить бин сужающего типа (объявлен `ArcanumClient`, а автовайрится `TestArcanumClient`) нельзя - нужно кастовать его в коде.
1. Бины определяются в `@Bean` методах. Если бин должен быть доступен в других конфигах - делаем его public. В противном случае можно делать protected. Для установки зависимостей используется автовайринг по имени бина.
1. Имя бина = имя метода. Устанавливать имя в аннотации `@Bean` рекомендуется только если нужно определить один и тот же бин в разных профилях в одном конфиге.
1. В класс бина все зависимости передаются в конструктор. Зависимости устанавливаются в final поля класса. **Внимание**: задачи Bazinga должны конфигурироваться точно так же.
1. Аннотации `@Value` и `@ClasspathResourceValue` используем только в конфигах, как и остальные Spring аннотации. Оставляем в бинах только бизнес логику.
1. Не использовать component scan. Единственное исключение - включённый scan по умолчанию для main-классов `SpringBootApplication`.


### Размещение конфигураций
Все конфигурации Spring должны быть в пакете `spring` соответствующего проекта.
* `spring.bazinga` - конфигурация для Bazinga
* `spring.clients` - клиенты для внешних систем
* `spring.ydb` - конфигурация YDB
* `spring.tasks` - задачи Bazinga


### Профили
Необходимо минимизировать использование профилей из `CiProfile`.
Дополнительные профили типа "disable-autocheck" не нужны.

### Конфигурации для тестов
Если необходимо кастомизировать продуктовую конфигурацию - в модуле `test` создается конфигурация с аналогичным именем и включением слова `Test`:
* `CommonConfig` -> `CommonTestConfig`
* `ArcClientConfig` -> `ArcClientTestConfig`


### Группировка конфигураций
Необходимо минизировать количество вариантов Spring конфигураций в тестах, т.к. каждый новый вариант приводит к поднятию нового контексте.


### Базовые классы для тестов
* `extends CommonTestBase` - для классов, которым не нужна YDB (есть только моки или бины без YDB)
* `extends CommonYdbTestBase` - для классов, которым нужна `CiMainDb`
* `extends CoreYdbTestBase` - для тестов в модуле `core`
* `extends `FlowEngineTestBase` - для тестов в модуле `flow-engine` и так далее
  Все они наследуются от `CommonTestBase`, в котором выполнена вся необходимая конфигурация по настройке properties, listener-ов и т.д.


### Моки для тестов
Моки могут использоваться только для самых простых тестов, где идёт проверка конкретного сервиса.
Моки рекомендуется ставить через `MockBean`.

**Использование моков в сложных конфигурациях необходимо избегать** - у нас нет никаких метрик на тестовое покрытие; мы можем пропустить проверку настоящего бина, заменив его моком.


#### Замена классов на моки
Что можно заменить моком - на первом этапе это **клиенты в другие сервисы**. Таким образом в тестах всегда используется настоящий, а ответ внешнего сервиса (который мы не контролируем) можно и заменить.

В идеале, конечно, вместо замены всего клиента необходимо заменять ответ сервиса (по сетевому протоколу), это позволит находить ошибки в реализации самих клиентов.


### Конфигурация бинов для тестов
Отрицательные пример - конфигурация GRPC сервера для тестов фронта.
Его конфигурация в тестах не имеет никакого отношения к настоящей конфигурации в проде.

Отрицательный пример - `TestBeansMockConfig` для flow-engine, который заменяет базингу, сервис работы с тасклетами и LaunchStateSynchronizer на пустые моки, после чего заменяет календарь каким-то stub-ом.

**Необходимо использовать стандартные бины.**

**Все cron таски также должны инициализироваться** - но для них нужно указывать такой schedule, который не позволит им выполниться (например, запускать всё в 2077-м году).


### Проперти в тестах
Необходимо отказаться от концепции хранения всех настроек в файлах типа `common-test.properties`.
Все настройки необходимо брать из базовых property файлов, а всё что специфично для unit-тестов вынести в `ci-common-unit-test.properties`.

### Bazinga в тестах

`BazingaTaskManagerStub` - это негодная замена базинги, использовать её нельзя (т.к. она работает вне транзакций и с легкостью запланирует выполнение задачи, которая не должна выполняться).

`SingleThreadBazinga` - хорошая заготовка.
