# Поддержка

## Частые вопросы/Известные проблемы

* ### Флоу автосборки: [wiki](https://wiki.yandex-team.ru/users/korum/notes/autocheck/)

* ### Как запретить merge в pr'е, когда часть тестов не была запущена из-за таймаутов?
  Красить плашку в красный цвет при таймаутах поможет `Strong Mode` в быстром контуре.
    - [https://clubs.at.yandex-team.ru/arcadia/22882](https://clubs.at.yandex-team.ru/arcadia/22882) (в конце статьи искать по словам `Strong Mode`)
    - [https://clubs.at.yandex-team.ru/arcadia/23610](https://clubs.at.yandex-team.ru/arcadia/23610)

  Для полного контура решение будет сделано в рамках тикета: [CI-657](https://st.yandex-team.ru/CI-657).

  У быстрого контура есть особенность - он никак не влияет на сходимость pr'а, то есть pr обращает внимание только на полный контур. Так как `StrongMode` есть только в быстром контуре, то возможна ситуация, когда полный контур зелёный, а быстрый красный.
  Тут поможет то, что в `a.yaml` можно задать последовательный режим запуска контуров. То есть если быстрый контур со `StrongMode` упадёт, то полный контур не будет запущен и ревью не смерджится.

# Рецепты

## Как дернуть ручку GRPC (для Storage или CI)

Ставим `grpc_cli` (пример для Мака): `brew install grpc`.

Локальный запрос: `grpc_cli ls localhost:4221 -l`

Для запросы в тестинг или прод его нужно выполнить под TVM2.
Универсальный способ - использовать сервисные тикеты.

Хост можно посмотреть в Деплое (или взять деплойный балансер - для тестовых целей это нормально).

* TVM для тестинга: 2018960
* TVM для прода: 2018912
```
#!/bin/bash

export TARGET_HOST="ci-api.in.yandex-team.ru:4221"
export TVM_SERVICE_TICKET=$(ya tool tvmknife get_service_ticket sshkey --src 2018912 --dst 2018912 | sed  's/:/\\:/g')

PAYLOAD="flow_launch_id { id : \"$1\" }"
echo $PAYLOAD
grpc_cli call --metadata=x-ya-service-ticket:${TVM_SERVICE_TICKET} ${TARGET_HOST} frontend.FlowService.LoadLaunchDetails "${PAYLOAD}
```

P.S.
Выражение `sed  's/:/\\:/g'` нужно для того, чтобы сделать обезопасить символы `:` (заменить их на `\:`), которые GRPC не принимает в параметрах метадаты.

# Работа с инцидентами

## Warden
* [Warden](https://warden.z.yandex-team.ru/components/devtech/s/ci) - инструмент для управления настройками протоколов, автоматического создания инцидентов и т.д.
* [Настройки alert-ов](https://warden.z.yandex-team.ru/functionality/7f42010b-22d7-4b68-9056-7cd91d4595f0) - настройки для автоматического создания SPI по Juggler алёртам.

## SPI
* [https://st.yandex-team.ru/SPI](https://st.yandex-team.ru/SPI) - очередь для заведения инцидентов (вместо CII).
* Ручные инциденты заводить можно через [тикенатор](https://tickenator.z.yandex-team.ru/new_incident). Компонента: **devtech**, сервис: **ci**
* В настоящий момент инциденты заводятся только на алёрт [dirDiscovery](https://juggler.yandex-team.ru/raw_events/?query=host%3Dtms-stable%20%26%20service%3Dtms-stable-autoRelease-dirDiscoveryDelay-seconds&project=devtools.ci)
* Список всех инцидентов можно увидеть в [отчете Warden](https://warden.z.yandex-team.ru/components/devtech/s/ci/report)

## Работа с инцидентом
* При создании инцидента автоматически создается инцидентный чат (новый на каждый новый инцидент). Ссылка на инцидентный чат прорастает в наш обычный [New CI Support](https://t.me/joinchat/A2HOPx2SxltDDzVpGffhgw).
* В инцидентом чате должна быть ссылка на SPI тикет. Если ссылка не проросла, можно посмотреть в [отчет Warden](https://warden.z.yandex-team.ru/components/devtech/s/ci/report), тикет будет в топе.
* Дежурный должен зайти в такой чат и **принять инцидент**. Если этого не сделать в течение 15 минут - придёт дежсмена и начнёт вызывать всех от текущих дежурных и выше, эскалируя инцидент.
* Во время инцидента нужно отвечать на вопросы робота.
* После решения проблемы нужно **завершить инцидент** (всё содержимое чата будет выгружено в соответствующий тикет.) 

### Заполнение SPI
После восстановления работоспособности сервиса необходимо перевести тикет в статусе "Сервис восстановлен" (по этим данным считается метрика).

В SPI огромное количество полей. Мы считаем, что нужно заполнять только часть из них, при этом некоторые (например, **Действия дежурного**) лучше заполнять сразу, не откладывая. Минимальный набор полей:
* **Что во время инцидента видели пользователи** - уточнить описание, даже если заполнено автоматически
* **Описание**
* **Действия дежурного**
* **Меры предотвращения**

При закрытии тикета вам потребуется заполнить ряд полей:
* **SRE area**: *service* или *bug* (если ошибка в коде), *operations* (если проблема вызвана ручными действиями), **release** (если причиной был новый релиз)
* **impact**: всегда *internal*
* **support_line**: как правило всегда *service*
* **Минус 1 ДЦ**: *Нет*
