# Алгоритмы определения затронутых процессов

CI должен понимать, какие процессы затрагивает новый коммит. Для этого необходимо:

- Найти затронутые `a.yaml` файлы. Назовём этот процесс **discovery**;
- В каждом найденном `a.yaml` определить затронутые процессы - этап применения [фильтров](actions.md#--filter-).

Этот раздел описывает только этап **discovery**.

Тип **discovery** задаётся в разделе с [фильтрами](actions.md#--filter-). Нужно понимать, что для каждого коммита CI всегда выполняет все типы **discovery** не зависимо от того, что выбрано в существующих `a.yaml` файлах.

## Какой discovery выбрать? { #choose }

Какой discovery выбрать, если мы хотим запускать процесс из файла `X/a.yaml`:

- На изменение чего-либо внутри директории `X`

  > Подходит `dir-discovery`

- На изменение чего-либо в другой рутовой директории `Y`

  > Подходит `dir-discovery` с `аbs-paths: ['Y/**']`

- На изменение проектов, от которых зависит проект `X` (зависит по `ya.make` файлам)

  > Подходит `graph-discovery`

- На изменение конфига/текстового файла, находящегося в другой рутовой директории `Y`

  > Варианты:
  > - `dir-discovery` + `аbs-paths: ['Y/example.cfg']`
  > - `dir-discovery` + `аbs-paths: ['Y/*.cfg']`
  > - `graph-discovery` и макрос `RESOURCE_FILES` в `ya.make` файле, как в примере [example1](https://a.yandex-team.ru/arc_vcs/ci/demo-project/graph-discovery/example1)

- На изменение кода проекта `Y` и любых проектов, от которых зависит `Y`

  > - Если проект `X` зависит от `Y`, то подойдёт `graph-discovery`
  > - Если проект `X` не зависит от `Y`, то можно использовать `PEERDIR` для добавления зависимости `X` от `Y`
  > - Если в проект `X` не получается добавить зависимость на `Y` через `PEERDIR`, то нужно `ya.make` файл в новом подкаталоге `X/some-subdir/ya.make` с макросом `CI_GROUP` и зависимостью по `PEERDIR` на `Y`.
      >
      >   Примеры: [example2](https://a.yandex-team.ru/arc_vcs/ci/demo-project/graph-discovery/example2), [example3](https://a.yandex-team.ru/arc_vcs/ci/demo-project/graph-discovery/example3).
      >   Для ускорения локальной сборки можно также использовать `IF (AUTOCHECK)`, как в этом же [example2](https://a.yandex-team.ru/arc_vcs/ci/demo-project/graph-discovery/example2/py_project1/watches_cpp_project1/ya.make?rev=175fe2aed9103d3185b2b194fec6410289f912c2#L4).

## Типы discovery { #discovery }

### 1. dir-discovery { #dir-discovery }

Используется по умолчанию.

- Для каждого пути в коммите перебираются все родительские директории от самой глубокой
- Затронутыми считаются все найденные `a.yaml` файлы

Пример:
- коммит меняет один файл `/ci/README.md`
- `dir-discovery` запустит процессы из `/ci/a.yaml` и `/a.yaml`

### 2. dir-discovery с фильтром abs-paths { #dir-discovery-abs-path }

{% note warning %}

- Работает только для коммитов в ```trunk```. Не работает для коммитов в иные бранчи и пулл-реквесты.
- Пути `abs-paths` должны начинаться с каталога верхнего уровня. Например, `abs-paths: [ci/**, testenv/core/*/*.py]` - это нормально, а вот `abs-paths: [**/*.java]` - уже ошибка.

{% endnote %}

Позволяет отслеживать изменения во всей Аркадии только в конкретных каталогах. Любые изменения, сделанные вне указанных каталогов, игнорируются.

- CI хранит список таких `abs-paths` путей
- Коммит анализируется на соответствие какому-либо пути из этого списка

Отличается от обычного `dir-discovery` точностью работы с ревизиями. CI хранит список `abs-paths` путей без привязки к ревизиям, то есть только последний стейт. Так как коммиты обрабатываются параллельно, то возможны ситуации:
- Обработка ревизии `r9` обновлённым списком `abs-paths` из ревизии `r10`
- Обработка ревизии `r11` старым списком `abs-paths` из ревизии `r9` (а не обновлённым списком из ревизии `r10`)

Такое поведение возможно только на близких по времени коммитах. В среднем обработка одного коммита укладывается в 1 секунду.


### 3. graph-discovery { #graph-discovery }

{% note warning %}

- Работает только для коммитов в ```trunk```. Не работает для коммитов в иные бранчи и пулл-реквесты.
- Требует зависимости по графу на текущий каталог с a.yaml (либо на любой подкаталог) для каждого из указанных путей.
- Выполняется от 10-20 минут утром до 40+ минут днём, иногда [дольше](https://nda.ya.ru/t/oM_lUg7H4V9KZE). Это становится заметным, когда у [релиза](release.md) включен [автозапуcк](https://docs.yandex-team.ru/ci/release#auto). Так как автозапуск релизов гарантирует отсутствие пропущенных коммитов, то он не случается до тех пор, пока `graph-discovery` не обработает коммит и все предыдущие коммиты.


{% endnote %}

CI для анализа затронутых путей задействует систему [сборки](https://docs.yandex-team.ru/devtools/build/), описываемую через `ya.make` файлы. `Graph-discovery` определяет, что меняет коммит с точки зрения системы сборки. То есть какие файлы `ya.make` файлы нужно пересобрать в результате коммита. Транзитивные зависимости тоже учитываются.

Возьмем для примера такую структуру файлов:
```
ci/a.yaml
ci/ya.make
kikimr/ya.make
library/java/client/common/ya.make
```
И следующую зависимость ya.make: `ci -> kikimr -> library/java/client/common`.

`Graph-discovery` может пригодиться в случае, когда
- Проект `ci` зависит от `kikimr`, который в свою очередь зависит от `library/java`
- Мы хотим запускать процессы, описанные в `ci/a.yaml`, на коммиты, меняющие какой-либо код самого проекта `ci` или же любого проекта, от которого зависит проект `ci` (то есть `kikimr` и `library/java`)

Graph-discovery для каждого коммита строит список затронутых [целей сборки](https://docs.yandex-team.ru/ya-make/general/base_concepts#what) (`ya.make`).
Например при изменении `library/java/client/common/` список выглядит так:
```
ci/ya.make
kikimr/ya.make
library/java/client/common/ya.make
```

Стоит обратить внимание, что в приведённом примере `a.yaml` с `graph-discovery` в сочетании с `abs-paths: ['kikimr/**']`
по-прежнему будет считаться затронутым при изменении кода в `library/java`, так как коммит затрагивает и проект `kikimr`.
Исходя из этого, кейс "запускать процесс на коммиты, затрагивающие ci, но только если изменения сделаны непосредственно
в kikimr" воспроизвести на данный момент невозможно. Если у вас именно такая задача, [приходите](https://st.yandex-team.ru/CI-2844).

Также не получится исключить какую-то цель с помощью `not-abs-paths`. Для примера выше и фильтров:
```yaml
    actions:
       my-action:
          flow: my-flow
          triggers:
             - on: commit
               filters:
                  - discovery: graph
                    abs-paths:
                      - ci/**
                    # не будет работать!
                    not-abs-paths:
                      - library/**
    flows:
       my-flow:
```
Коммит в `library/java` все равно приведет к запуску процесса. Причины такого поведения несколько более сложные,
и если вам это нужно, приходите к нам в [тикет](https://st.yandex-team.ru/CI-3646).

Данный способ будет работать, только если каталог a.yaml зависит по графу от всех каталогов в abs-path. Т.е. только если в `ci/a.yaml` указано
```yaml
...
    actions:
       my-action:
          flow: my-flow
          triggers:
             - on: commit
               filters:
                  - discovery: graph
                    abs-paths:
                      - 'x/y/**'
                      - 'w/z/**'
    flows:
       my-flow:
       # ...
```
и одновременно в `a/b/ya.make` (либо в любом из подкаталогов - `a/b/c/ya.make`, `a/b/c/d/ya.make`) также указана прямая зависимости по графу на эти каталоги
```
...
PEERDIR(
    x/y
    w/z
...
```

Если в `ya.make` отсутствует зависимость по графу на указанные пути, то такой способ discovery работать не будет.

{% note info %}

- Запускается только для [linux](https://a.yandex-team.ru/arc_vcs/autocheck/autocheck-config-linux.json) и [mandatory](https://a.yandex-team.ru/arc_vcs/autocheck/autocheck-config-mandatory-platforms.json) платформ.
- Результат работы `graph-discovery` - это список изменённых коммитом build-зависимостей, то есть список `ya.make` файлов. Фильтр `sub-paths: ['**.java']` в случае `graph-discovery` не сработает, потому что `graph-discovery` знает только про `ya.make` файлы.

{% endnote %}

{% cut "Этапы работы graph-discovery" %}

`Graph-discovery` работает в несколько этапов:
- Для коммита вычисляется build-граф всей Аркадии
- Граф сравнивается с build-графом для предыдущего коммита
- Так получается список `ya.make` файлов, которые нужно пересобрать из-за коммита
- Для каждого `ya.make` файла перебираются все родительские директории от самой глубокой в поисках `a.yaml` файлов
- Затронутыми считаются все найденные `a.yaml` файлы

{% endcut %}

Больше примеров с graph-discovery можно увидеть в [ci/demo-project/graph-discovery](https://a.yandex-team.ru/arc_vcs/ci/demo-project/graph-discovery).

### 4. any-discovery { #any-discovery }

{% note warning %}

- Работает только для коммитов в ```trunk```. Не работает для коммитов в иные бранчи и пулл-реквесты.
- В случае автозапуска релизов требует завершённого `dir-` и `graph-discovery` для коммита и его родителей.

{% endnote %}

Файл `a.yaml` считается затронутым, если он затронут либо по `dir-discovery`, либо по `graph-discovery`.

### 5. any-discovery с фильтром abs-paths { #any-discovery-abs-path }

{% note warning %}

Работает только для коммитов в ```trunk```. Не работает для коммитов в иные бранчи и пулл-реквесты.

{% endnote %}

Файл `a.yaml` считается затронутым, если он затронут либо по `dir-discovery` с фильтром `abs-paths`, либо по `graph-discovery` с фильтром `abs-paths`.

## Ограничения на discovery в Pull Request'ах { #pr-discovery-restrictions }

В Pull Request'ах недоступны graph-discovery и dir-discovery по абсолютным путям за пределами директории с конфигом. Таким образом запуск Action'ов на Pull Request возможен только при явном коммите в директорию с конфигом.
Данное ограничение идеологическое, а не техническое. Для запуска тестов по зависимостям существует автосборка.
В рамках автосборки гарантируется критический путь выполнения проверки, герметичность и воспроизводимость. А мигающие тесты мьютяться и не влияют на цвет плашки.
Кастомные Actions такими свойствами не обладают и обладать не могут. Нужны ли  такие проверки в конкретных директориях - область ответственности владельцев этой директории.

Если вы считаете, что конкретная проверка должна запускать на коммит в директорию, согласуйте это с владельцами этой директории и опишите в соответствующем a.yaml

{% cut "FAQ" %}

- **Q: Мне придется продублировать Action во всех a.yaml?**
- **A:** Пока к сожалению да. В будущем мы это [исправим](https://st.yandex-team.ru/CI-2426).


- **Q: А что с on-demand запусками? В том числе про графу зависимостей.**
- **A:** [Будет](https://st.yandex-team.ru/CI-2410).


- **Q: Но ведь в Testenv'е была такая возможность.**
- **A:** В Testenv'е была возможность запустить что угодно по любым условиям, но это никак не влияло на Merge-требования и соответственно на возможность влить Pull Request.
  Чтобы сделать Te-job'ы обязательными - надо было явно указывать это в a.yaml на уровне конкретной директории. Так что они всегда носили чисто информационный характер и в массе своей игнорировались.


- **Q: Мои тесты не мигают. / Вы думаете, что с такими проверками будут проблема, на самом деле всё хорошо.**
- **A:** Это не работает на масштабах Аркадии. Например, сейчас в Аркадии мигают и соответственно замьючено почти 2% тестов.


- **Q: Мой тест/проверка не ложится на автосборку, но я считаю, что она должна запускаться по зависимостям.**
- **A:** Приходите к нам в [поддержку](index.md#support).

{% endcut %}

### Больше примеров с graph-discovery { #more-examples }

Можно увидеть в [ci/demo-project/graph-discovery](https://a.yandex-team.ru/arc_vcs/ci/demo-project/graph-discovery).
