# События

Каждая существующая система непрерывной интеграции умеет по-своему предоставлять информацию о состоянии запущенных flow. CI автоматически выгружает информацию обо всех **событиях**, происходящих с flow, в [Logbroker](https://lb.yandex-team.ru/) - специальный отказоустойчивый сервис, решающий проблему асинхронного обмена потоками данных между разными сервисами Яндекса. Подробности о работе Logbroker можно почитать в [документации](https://logbroker.yandex-team.ru/docs/).

На каждое изменение состояния любого запущенного flow CI сохраняет в специальное хранилище в Logbroker (**топик**) информацию о произошедшем событии. Внешний сервис имеет возможность подписаться на топик и обрабатывать поступающие данные любым удобным способом. События складываются в кластер [LBKX](https://logbroker.yandex-team.ru/lbkx/) в следующие топики:

Топик | Описание
:--- | :---
**[/ci/events/testing](https://logbroker.yandex-team.ru/lbkx/accounts/ci/events/testing)** | События из тестового окружения CI
**[/ci/events/stable](https://logbroker.yandex-team.ru/lbkx/accounts/ci/events/stable)** | События из стабильного окружения CI

{% note info %}

CI складывает в топик события для всех работающих flow всех имеющихся проектов. Задача фильтрации нужных событий должна решаться на стороне потребителя событий.

{% endnote %}

Все доступные события определены в формате [Protobuf](https://developers.google.com/protocol-buffers) в файле [event.proto](https://a.yandex-team.ru/arc/trunk/arcadia/ci/proto/event/event.proto) и складываются в топик в двоичном сериализованном виде. Для того, чтобы десериализовать событие, используйте реализацию Protobuf для вашего языка программирования. Все события содержат информацию о времени создания и о flow, к которому они относятся. Полный список событий можно посмотреть в `enum EventType` (в указанном выше прото-файле).

События содержат минимальное количество информации, позволяющее однозначно понять, к какому flow они относятся. Для получения большего количества информации следует использовать вызовы API.

События выгружаются стандартной поставкой Logfeller в [YT Hahn](https://yt.yandex-team.ru/hahn/navigation?path=//home/logfeller/logs/ci-events-stable), где по ним можно сделать необходимый анализ.

## Подписка на события

Приходите в поддержку CI, если вам нужно подписаться на события из Logbroker топика:
* Мы выдадим право `ReadTopic` на ваш ABC сервис
* Вам нужно будет создать `ReadRule` на топики `/ci/events/stable` и `/ci/events/testing` для вашего консьюмера в LBKX инсталляции
* В настройках `Supported codecs` вашего консьюмера должен быть `raw` кодек. Могут быть и другие, но `raw` обязательно
