# Условное выполнение задач { #if }

{% note warning %}

Эта возможность нужна в редких случаях.

{% endnote %}

{% note info %}

Если нужно пропустить сразу несколько задач (или целую ветвь), то в каждой из задач нужно указать условие для выполнения.

{% endnote %}

Одним из частных случаев использования выражений является условное выполнение задач, т.е. возможность выполнять некоторые задачи в зависимости от значения произвольного выражения. Для того, чтобы настроить условное выполнение, нужно указать логическое выражение в поле `if`:

```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        start:
          ...
        build:
          title: Build My App
          task: common/arcadia/ya_package
          needs: start
          if: ${tasks.start.generated_by == 'robot-ci'} # Выполнять задачу только, если выходной параметр задачи start имеет значение robot-ci
          input:
              packages: my_project/pkg.json
              resource_type: MY_APP
```


Рекомендуется писать `JMESPath` выражение, возвращающее `bool` значение. В этом случае результат `true` означает, что задача будет выполнена, результат `false` - пропущена.

В случае выражения другого типа, используется следующая логика:
 * для простых строковых значений (`string`) - `Boolean.valueOf()` возвращаемого значения (т.е. если это строка и она
равна `"true"`, то это `true`; в остальных случаях `false`)
 * для простых числовых значения (`number`) - если целое значение больше нуля, то `true`; если меньше или равно нулю `false`
 * для объекта - наличие хотя бы одного поля значит `true`
 * для массива - наличие хотя бы одного элемента означает `true`

Задача, пропущенная по условию, не выполняется - у нее не будет артефактов и выхода. Но при этом она будет считаться успешно обработанной, т.к. от нее можно ставить зависимости на следующие задачи в графе.


## Доступные переменные { #variables }

Вы можете использовать [выражения](expression.md).

Для поля `if`:
* `${tasks.*...}` - результаты выполнения предыдущих задач
* `${context...}` - контекст, который будет вычислен в момент запуска базовой задачи
