# Параметризованные задачи (multiply/by)

{% note warning %}

Эта возможность нужна в редких случаях.

{% endnote %}


{% note info %}

Для понимания данного раздела необходимо понимать работу с [выражениями](expression.md), основы создания задач [на основе задач Sandbox](job-sandbox.md), [технологии Tasklet](job-tasklet.md).

{% endnote %}

В некоторых случаях требуется параллельный запуск одинаковых задач с разными входными данными. Например, вы можете в первой задаче получить список тестируемых проектов, а во второй параллельно выполнить для каждого из таких проектов соответствующие тесты. Эту проблему в CI решает использование **параметризованных задач**. Пример использования в **a.yaml**:

```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        prepare-projects: # Получаем список тестируемых проектов
          # ...
        run-tests: # Запустить тесты для всех проектов, полученных в предыдущей задаче
          needs: prepare-projects
          task: my_project/test/run_tests
          multiply: # Объявление параметризованной задачи
            by: ${tasks.prepare-projects.projects}
            title: Run tests ${index} of ${size}
          input:
            project-name: ${by.name} # Параметр, по которому происходит запуск
        run-lint: # Запустить статический анализатор кода на каждый проект параллельно
          needs: prepare-projects
          task: my_project/test/run_lint
          multiply:
            by: ${tasks.prepare-projects.projects}
            title: Run lint ${index} of ${size}
            max-jobs: 50 # Максимальное количество параллельно выполняющихся задач
          input:
            projects: ${by}
```

Здесь предполагается, что задача `prepare-projects` имеет следующий формат выходных данных:

```protobuf
syntax = "proto3";

package ci.test;

message Project {
    string name = 1;
}
message Output {
    repeated Project projects = 1;
}
```

Результат работы такой задачи может, например, выглядеть так:
```json
{
  "tasks": {
    "prepare-projects": {
      "projects": [
        {
          "name": "Market Back Office"
        },
        {
          "name": "Yandex.Disk"
        }
      ]
    }
  }
}
```

Мы используем поле `multiply > by`, чтобы указать, что мы хотим использовать объект `ci.test.Project` в качестве параметра:

```yaml
multiply:
  by: ${tasks.prepare-projects.projects}
```

В значении поля мы указываем [выражение](expression.md) `${tasks.prepare-projects.projects}`, содержащее информацию о том из какого поля выходных данных задачи `prepare-projects` брать возможные значения параметров. Далее синтаксис отличается в зависимости от того каким образом определена задача, которому мы хотим передать параметр.

## Параметризованные задачи на основе задач Sandbox { #job-sandbox }

Для задач на основе **задач Sandbox** (см. `run-tests` в примере выше) значение параметра передается в один из входных параметров Sandbox задачи. Для обращения к конкретному экземпляру параметра используется выражение `${by}`:

```yaml
input:
  project-name: ${by.name} # У Sandbox задачи должен быть входной параметр project-name
```

В нашем примере в `${by}` будут последовательно передаваться вот такие объекты:

```json
{
  "name": "Market Back Office"
}
```

Поэтому выражение `${by.name}` позволяет получить имя проекта и передать его на вход задачи. Кроме `${by}` поддерживаются переменные: `${index}` - порядковый номер параметризованной задачи, начиная с 1 и `${size}` - общее количество параллельно запущенных задач. Таким образом будет запущено две Sandbox задачи с `project-name` равным `Market Back Office` и `Yandex.Disk`.

## Параметризованные задачи на основе технологии Tasklet { #job-tasklet }

Для задач на основе **технологии Tasklet** (см. `run-lint` в примере выше) значение параметра передается в указанное поле на вход этой задачи. Например, пусть задача `run-lint` имеет такой вход:

```protobuf
syntax = "proto3";

package ci.test;

message Project {
    string name = 1;
}
message Input {
    repeated Project projects = 1; // Принимает несколько проектов на вход
}
```

Передаем данные типа `ci.test.Project` на вход в разделе `input`, если поле `projects` обычное (не `repeated`):
```yaml
multiply:
  by: ${tasks.prepare-projects.projects}
  title: Run lint ${index} of ${size}
input:
  project: ${by}
```

Если же поле `projects` объявлено как `repeated`, а выражение `multiply/by` формирует один объект, то поле нужно положить в элемент списка:
```yaml
multiply:
  by: ${tasks.prepare-projects.projects}
  title: Run lint ${index} of ${size}
input:
  projects:
    - ${by}
```

В этом случае будет создано две параметризованных задачи:

1. `run-lint-1` с параметрами `{"projects": [{"name": "Market Back Office"}]}`
2. `run-lint-2` с параметрами `{"projects": [{"name": "Yandex.Disk"}]}`

## Максимальное число запускаемых задач { #max-jobs }

По умолчанию можно создавать **до 20 параллельно запущенных** параметризованных задач. С помощью поля `max-jobs` можно увеличить это число, но **не более чем до 99**:

```yaml
run-lint:
  needs: prepare-projects
  task: my_project/test/run_lint
  multiply:
    by: ${tasks.prepare-projects.projects}
    max-jobs: 50 # Максимальное количество параллельно выполняющихся задач
  input:
    projects: ${by}
```

При превышении установленного количества параллельно запущенных задач произойдет ошибка.

## Доступные переменные { #variables }

Вы можете использовать [выражения](expression.md).

Для поля `multiply/by`:
* `${tasks.*...}` - результаты выполнения предыдущих задач
* `${context...}` - контекст, который будет вычислен в момент запуска базовой задачи

Для полей `multiply/title`, `input`, `if`:
* `${index}` - порядковый номер созданной параметризованной задачи (1..N)
* `${size}` - общее количество создаваемых параметризованных задач
* `${by}` - ссылка на объект, найденный в выражении `${by}`
* `${tasks.*...}` - результаты выполнения предыдущих задач
* `${context...}` - контекст, который будет вычислен в момент запуска каждого параметризованной задачи на исполнение. Все остальные [выражения](expression.md) будут вычислены в момент создания динамических задач из шаблона.

## Ограничения { #limitations }

* Задачи будут созданы только один раз - при первом запуске шаблона. Дальнейшие перезапуски не приведут к пересозданию  задач.
* В графе исполнения параметризованные задачи выглядят как огромное количество параллельно выполняемых задач.
* Параметризованные задачи не могут иметь зависимость (`needs`) на задачи из другой [стадии](release.md#stage). Используйте промежуточную `dummy` задачу (см. раздел [Шаги](flow.md)).
* Любые задачи не могут иметь зависимость на параметризованные задачи из другой [стадии](release.md#stage). Используйте промежуточную `dummy` задачу.
* Параметризованные задачи не могут ссылаться в [выражениях](expression.md) на другие параметризованные задачи. Используйте промежуточную `dummy` задачу.
