# Описание задач

В предыдущем разделе мы познакомились с общей структурой файлов **a.yaml**. В этом разделе мы научимся описывать последовательность задач.

## Граф исполнения { #flow }

CI, в отличие от многих современных систем непрерывной интеграции, позволяет организовать сложные связи между задачами. Можно исполнять несколько задач параллельно, запускать задачи в зависимости от выполнения определенных условий, определять зависимости между задачами, требовать ручного подтверждения запуска задач и так далее. Полный набор задач и связей между ними составляет **граф исполнения**. Граф является ациклическим и направленным слева направо. Задачи располагаются в узлах графа, а его ребра - это связи между задачами. Для наглядности граф исполнения отображается прямо в пользовательском интерфейсе CI на соответствующей странице flow.

![Граф исполнения](img/flow-graph.png "Граф исполнения" =800x)

## Задачи { #jobs }

Прежде чем познакомиться с синтаксисом описания конкретных задач, давайте посмотрим на то, как они устроены.

![Вход и выход задачи](img/flow-job.png "Вход и выход задачи" =800x)

Схематически каждую задачу можно представить в виде "черного ящика" с одним **входом** (input) и одним **выходом** (output). На вход задачи обычно подаются различные настройки ее выполнения и входные данные, а на выход поступает информация о результате выполнения задачи. Для объявления формата входа и выхода используется [Protobuf](https://developers.google.com/protocol-buffers), поэтому вход и выход задачи могут представлять сколь угодно сложный объект с множеством полей. Результаты выполнения любой задачи могут передаваться не только в соседнюю задачу, но и в любую из следующих задач графа исполнения. Ниже мы подробнее разберемся в том, как это работает. Объявление задач в **a.yaml** выглядит так:

```yaml
service: my-abc-service-slug
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      description: This flow does a lot of things.
      jobs:
        build: # Задача №1
          title: Build My App # Название задачи в UI
          description: This job builds My App. # Развернутое описание задачи
          task: common/arcadia/ya_package # Где хранится описание задачи
          input: # Вход задачи - название полей зависит от выбранной задачи
              packages: my_project/pkg.json
              resource_type: MY_APP
        deploy: # Задача №2
          needs: build
          title: Deploy My App
          task: common/deploy/release
          input: # Видно, что здесь уже другие входные данные
            config:
                sandboxResourceType: MY_APP
```

Из данного примера видно, что для добавления задачи в flow необходимо создать новый объект в секции `jobs` и указать ему несколько полей:

* В поле `title` указывается название задачи, которое будет отображаться в веб-интерфейсе CI;
* В поле `task` указывается информация о том, где хранится описание того, что нужно сделать. Полный список доступных задач хранится в [реестре задач](https://a.yandex-team.ru/arc_vcs/ci/registry), при этом реализации конкретных задач могут располагаться в любом месте единого репозитория. Например, запись `common/arcadia/ya_package` означает, что будет использоваться описание задачи из файла [/ci/registry/common/arcadia/ya_package.yaml](https://a.yandex-team.ru/arc_vcs/ci/registry/common/arcadia/ya_package.yaml). Подробнее о том, как описывать собственные задачи, рассказано в следующих разделах данной документации.
* В поле `input` передаются входные параметры конкретной задачи. Набор доступных полей зависит от выбранной задачи и должен быть описан в её документации. Например, для задачи, производящей компиляцию исходного кода, в качестве параметров могут передаваться флаги компилятора, а для задачи, выполняющей тестирование, - список тестов, которые нужно выполнить. Во многих задачах конфигурационные параметры дополнительно завернуты в поле `config`.

## Зависимости между задачами { #dependencies }

По умолчанию все объявленные задачи исполняются **параллельно**. Однако, во многих случаях требуется выдержать определенную последовательность действий. Например, выкладка приложения в тестинг идет после его сборки, а выкладка в продакшн — после выкладки в тестинг. Для того, чтобы задать порядок выполнения задач, нужно объявить зависимости между ними с помощью поля `needs`:

```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        build:
          title: Build Job
          task: common/arcadia/ya_make
          input:
            # ...
        test:
          title: Test Job
          task: some/test/job
          input:
            # ...
        deploy:
          needs:
            - build # Зависимость от задачи build
            - test # Зависимость от задачи test
          title: Deploy Job
          task: common/deploy/release
          input:
            # ...
```

Распространённым подходом к организации зависимостей является объявление пустых (`dummy`) задач. Вначале объявляется задача, которая сам по себе ничего не делает, но зависит от других задач:

```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        build-component-1:
          title: Build Component 1
          task: common/arcadia/ya_make
          input:
            # ...
        build-component-2:
          title: Build Component 2
          task: common/arcadia/ya_make
          input:
            # ...
        build-all:
          needs:
            - build-component-1
            - build-component-2
          title: Build All
          task: dummy # Не делает ничего
        deploy-component-1:
          needs:
            - build-component-1
          title: Deploy Component 1 in Testing
          task: common/deploy/release
          input:
            # ...
        deploy-all:
          needs:
            - build-all
            - deploy-component-1
            # ...
          title: Deploy All
          task: dummy
        update-infra:
          needs:
            - deploy-all
          title: Update infra event...
          # ...

```

В примере выше пустая задача `build-all` зависит от конкретных задач для сборки каждого из компонентов вашего проекта, а задача `deploy-all` зависит от `build-all` и конкретных задач выкатки компонентов проекта. При таком подходе получается, что сборки и выкладка каждого из компонентов происходит параллельно, но при этом выкладка всех компонентов, после которой нужно будет сделать какие-то другие действия, выполняется только после того как успешно завершилась сборка всех компонентов.

По умолчанию задача, зависящая от других задач, начинает выполняться только когда все зависимости завершили свою работу (`job1 AND job2 AND job3`). В некоторых случаях необходимо поведение, когда новая задача дожидается выполнения **одной из зависимостей** (`job1 OR job2 OR job3`). Для того, чтобы включить такое поведение, используется поле `needs-type`, принимающее значения `all` (по умолчанию) и `any`. Например, эту возможность можно использовать, чтобы вручную пропускать некоторые необязательные задачи.

Существует возможность выполнить задачу, если зависимость упала с ошибкой. Для этого используется поле `needs-type` со значением `fail` (упала хотя бы одна из зависимых задач).

```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        send-notifications:
          title: Send notifications
          task: my/notification/job
          input:
            # ...

        report-failed-notifications:
          title: Report about failed notitications
          task: my/notification/report
          needs-type: fail
          needs: send-notifications

        skip-sending-notifications:
          title: Skip sending notifications
          task: dummy
          manual: # Ручное подтверждение. Смотри подробности в следующих разделах.
              enabled: true
              prompt: "Skip sending notifications?"

        send-notifications-success:
          title: Send notifications (finished)
          task: dummy
          needs-type: any # Задача завершается, если выполнена хотя бы одна из зависимостей
          needs:
              - send-notifications
              - report-failed-notifications
              - skip-sending-notifications
```

## Ручное подтверждение задач { #manual-confirmation }

В некоторых сценариях требуется ручное подтверждение определенных задач. Например, сборка и выкладка приложения в тестинг может осуществляться автоматически, а выкладка в продакшн окружение — после ручного нажатия кнопки в интерфейсе CI. Задачи, требующие ручного подтверждения выглядят вот так:

![Ручное подтверждение задачи](img/flow-manual-job.png "Ручное подтверждение задачи" =800x)

Когда граф дойдет до задачи с подтверждением, там появится кнопка, на которую нужно нажать:
![Ручное подтверждение задачи, кнопка готова](img/flow-manual-job2.png "Ручное подтверждение задачи, кнопка готова" =800x)

Для того, чтобы добиться такого поведения, используется специальный параметр `manual`:

```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        automated-step:
          title: Automated Step
          task: common/arcadia/ya_make
          input:
            # ...
        manual-step:
          needs: automated-step
          title: Manual step
          task: common/deploy/release
          manual: true
          input:
            # ...
```


Можно расширить настройки подтверждения, показав нужное вам сообщение:
```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        automated-step:
          title: Automated Step
          task: common/arcadia/ya_make
          input:
            # ...
        manual-step:
          needs: automated-step
          title: Manual step
          task: common/deploy/release
          manual: # Ручное подтверждение задачи
              enabled: true
              prompt: "Launch manual step?" # Сообщение для пользователя, которое он должен подтвердить
          input:
            # ...
```

![Ручное подтверждение задачи, кнопка нажата](img/flow-manual-job3.png "Ручное подтверждение задачи, кнопка нажата" =800x)

### Ограничение подтверждения задач { #approvers }

Существует возможность ограничить список пользователей, которые могут выполнять подтверждение. Рекомендуется использовать для этого пустую `dummy` задачу с блоком `approvers`:
```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      jobs:
        automated-step:
          title: Automated Step
          task: common/arcadia/ya_make
          input:
            # ...
        manual-step:
          needs: automated-step
          title: Manual step
          task: dummy
          manual: # Ручное подтверждение задачи
              enabled: true
              prompt: "Launch manual step?" # Сообщение для пользователя, которое он должен подтвердить
              approvers:
                service: ci
                scope: administration
```

{% note info %}

Блок `approvers` поддерживает точно такой же набор значений, как и в блок [permissions](permissions.md#types) и позволяет настраивать разрешения для `scope` (групп ABC сервиса), `role` (ролей ABC сервиса) и расписаний.

{% endnote %}


## Перезапуск задач { #attempts }
По умолчанию, если задача завершается с ошибкой, то требуется действие пользователя для продолжения работы флоу. В некоторых случаях может быть полезно задать схему автоматического перезапуска (retry) упавших задач. Для этого можно указать в конфигурации задачи максимальное количество попыток запуска, которые будет выполнены автоматически, а также продолжительность паузы между попытками:

{% code 'ci/internal/ci/core/src/test/resources/ayaml/job-attempts/valid.yaml' lang='yaml' lines='documentationStart-documentationEnd' %}

По умолчанию все Sandbox задачи пересоздаются независимо от причины - ручной ли это перезапуск кубика или автоматический.

### Перезапуск задач с условием { #attempts-if }
Существует возможность указать дополнительное условие, при котором задача будет перезапущена, проверив выходные параметры задачи (опция `get-output-on-fail` будет включена по умолчанию):

{% code 'ci/internal/ci/core/src/test/resources/ayaml/job-attempts/valid-conditional.yaml' lang='yaml' lines='documentationStart-documentationEnd' %}

Результат выражения (`true`) вычитывается так же, как и в [условном выполнении задач](expression-conditional.md).

Доступны только `flow-vars` и результат выполнения текущей задачи, как [Sandbox](expression.md#access-sandbox-tasks), так и [Tasklet](expression.md#access-sandbox-tasklets).

### Перезапуск задач Tasklet V2 { #attempts-tasklet-v2 }
Тасклеты V2 будут перезапущены только в случае серверной ошибки.

Существует возможность ограничить список серверных ошибок, которые приведут к перезапуску тасклета, с помощью опции `exclude-server-errors`:

{% code 'ci/internal/ci/core/src/test/resources/ayaml/job-attempts/valid-tasklet-v2.yaml' lang='yaml' lines='documentationStart-documentationEnd' %}

### Переиспользование Sandbox задач { #sandbox-reuse }
В исключительных случаях может потребоваться не пересоздание Sandbox задач (что происходит по умолчанию), а их переиспользование, т.е. перезапуск. В этом режиме та же самая Sandbox задача будет перезапущена:

{% code 'ci/internal/ci/core/src/test/resources/ayaml/job-attempts/valid-reuse.yaml' lang='yaml' lines='documentationStart-documentationEnd' %}

Полный список статусов задач можно найти в [документации Sandbox](https://docs.yandex-team.ru/sandbox/tasks#status).

{% note info %}

Если задача находится в статусе из группы "FINISH", то она не может быть перезапущена ни при каких условиях. Такая задача будет пересоздана.

Самый простой способ перевести задачу в такой статус - это удалить её.

{% endnote %}


## Контекст flow { #context }

Формат данных на входе каждой задачи зависит от её реализации и может содержать произвольные поля. Тем не менее у каждого flow есть набор стандартных данных, которые всегда передаются каждой задаче. Такой набор называется **контекстом** и имеет тип [ci.TaskletContext](https://a.yandex-team.ru/arc_vcs/ci/tasklet/common/proto/service.proto). Контекст включает, например, такие данные как:

* Идентификатор flow
* Путь до файла `a.yaml`
* Коммит, на котором выполняется flow
* Идентификатор секрета в Секретнице
* Информация о пулл-реквесте
* [Версия релиза](release.md#versioning)

Со временем контекст может дополняться новыми полями.

## Контекст Sandbox задачи { #sandbox-context }

{% note warning %}

Эта возможность нужна в редких случаях, когда необходимо напрямую добавлять параметры в контекст некоторых старых задач в Sandbox. Не используйте её, если Sandbox задача не требует передачи таких параметров.

{% endnote %}

Если задачи запускаются в Sandbox, существует возможность напрямую передавать значения в контекст Sandbox задачи - в то, что в Sandbox называется "Other context fields". Для этого используется поле `context-input`:

```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      description: This flow does a lot of things.
      jobs:
        build:
          title: Build My App
          task: common/arcadia/ya_package
          context-input: # Передача значений в контекст Sandbox задачи
            string_key: Test
            int_key: 42
```

## Передача данных между задачами { #artifacts }

Мы уже упоминали о том, что для описания форматов входных и выходных данных между отдельными задачами используется [Protobuf](https://developers.google.com/protocol-buffers):

```protobuf
syntax = "proto3";

import "ci/tasklet/common/proto/sandbox.proto";
import "ci/tasklet/common/proto/service.proto";

package some_package;

// Пример конфигурационных параметров задачи
message Config {
    string project = 1;
    string namespace = 2;
    string sandbox_resource_type = 3;
    string url = 4;
    int32 wait_for_deploy_timeout_minutes = 5;
}

// Вход задачи (включает в себя пример конфигурационных параметров задачи)
// Состав параметров (названия полей, типы сообщений, их количество и тд.) зависит от конкретной задачи и определяется пользователем.
message Input {
    ci.TaskletContext context = 1; // Контекст задачи, который CI формирует автоматически.
    Config config = 2; // Пример пользовательского параметра
    repeated ci.SandboxResource sb_resources = 3; // Принимает множество sandbox-ресурсов, получаемых в результате выполнения задач, от которых зависит текущая задача.
}

// Выход задачи
message Output {
  // Аналогично Input. Состоит только из пользовательских параметров.
  // ...
}
```

Это значит, что все такие данные имеют строго определенный тип, и появляется возможность проанализировать весь граф исполнения и автоматически связать выход одних задач с входом других. Данные, передаваемые между задачами flow по-другому называются **артефактами**.

{% note warning %}

Предполагается, что между задачами передается небольшой объем данных: настройки и конечные результаты вычислений. Все объемные данные наподобие больших текстовых или бинарных файлов должны сохраняться в хранилище (например, в ресурсы [Sandbox](https://sandbox.yandex-team.ru/) или в [MDS](https://wiki.yandex-team.ru/mds/)), а между задачами в этом случае передается ссылка на файл или ресурс.

{% endnote %}

{% note info %}

Текущие лимиты установлены достаточно свободными и предназначены скорее для предотвращения ошибочных публикаций:

Лимит | Значение
:--- | :---
Максимальный размер артефакта | 100 KiB
Максимальное количество элементов в `multiple` артефакте на одной задаче | 250
Максимальное количество артефактов на весь flow | 1000

Лимиты могут быть сконфигурированы для каждого проекта отдельно по запросу.

{% endnote %}

Ниже приведены правила, по которым CI выбирает какие данные подаются на вход задачам (т.е. каким образом **передаются артефакты**):

1. **Прямая передача артефакта.** Задача `PACKAGE` производит один артефакт типа `ci.SandboxResource`. Следующая задача `DEPLOY_TO_SAMOGON` может принять единственный артефакт такого типа. В этом случае такой артефакт будет передан на вход задаче `DEPLOY_TO_SAMOGON`.

    ![Прямая передача артефакта](img/resources/direct-single.png "Прямая передача артефакта" =800x)

2. **Передача артефакта по типу**. Если задача требует на вход какой-то артефакт, то он обязан возвращаться одной из задач, запускаемых раньше по графу. В противном случае такой граф не может быть исполнен и при его проверке будет выброшена ошибка. В примере ниже последняя задача требует артефакт `ci.SandboxResource`. Этот артефакт не возвращается ни одной из задач ранее, поэтому такой граф содержит ошибку. При этом, если для какого-то артефакта (`VerificationResult`) нет потребителя, то это вполне допустимая ситуация.

   ![Указанный тип отсутствует](img/resources/not-found.png "Указанный тип отсутствует" =800x)

3. **Неоднозначный выбор артефакта.**. Если задача требует один артефакт, а среди предыдущих задач произведено более одного артефакта такого типа, то это приводит к ошибке.

   ![Неоднозначный выбор артефакта](img/resources/throw-extra.png "Неоднозначный выбор артефакта" =800x)

4. **Список артефактов одного типа**. Если задача требует несколько артефактов определенного типа (модификатор `repeated` у поля), то все артефакты такого типа будут собраны и поданы на вход задаче.

    ![Список артефактов](img/resources/repeated.png "Список артефактов" =800x)

5. **Пустой список артефактов**. Если задача принимает на вход список артефактов определенного типа предполагает, что таких артефактов может быть `0`.

    ![Пустой список артефактов](img/resources/repeated-even-zero.png "Пустой список артефактов" =800x)

6. **Сбор нескольких артефактов**. Артефакты собираются среди всех произведенных артефактов задачами ранее по графу:

   ![Сбор нескольких артефактов](img/resources/transient.png "Сбор нескольких артефактов" =800x)

    Если по графу выше есть несколько артефактов требуемого типа, можно собрать их все:

   ![Сбор нескольких артефактов одного типа](img/resources/transient-extra-repeated.png "Сбор нескольких артефактов одного типа" =800x)

7. **Приоритет артефактов по близости**. Приоритета для артефактов по близости к задаче нет. На примере ниже оба артефакта равноправны, и попытка передать их в задачу, в которой ожидается только один артефакт, приведет к ошибке. Этот граф содержит ошибку.

   ![Приоритет артефактов по близости](img/resources/transient-extra.png "Приоритет артефактов по близости" =800x)

8. **Приоритет артефактов по порядку входа**. Приоритета по порядку входа нет. Это значит, что артефакты будут собраны со всех источников ранее по графу в произвольном порядке.

   ![Приоритет артефактов по порядку входа](img/resources/two-input.png "Приоритет артефактов по порядку входа" =800x)
