# Введение

**[CI](http://a.yandex-team.ru/ci/)** — современное решение для организации непрерывной интеграции (CI) и непрерывной доставки (CD) кода в едином репозитории [Arcadia](https://a.yandex-team.ru). Для хранения конфигурации используются файлы с [YAML](https://en.wikipedia.org/wiki/YAML) синтаксисом, хранящиеся в едином репозитории вместе с кодом проекта.

## Поддержка { #support }

Есть три основных канала поддержки пользователей CI, в которых вы можете задавать любые возникающие вопросы:

* [Форма поддержки](https://forms.yandex-team.ru/surveys/devtools/)
* [Канал в Slack](https://yndx-all.slack.com/archives/C01EV2M105B)
* [Чат в Telegram](https://t.me/joinchat/A2HOPx2SxltDDzVpGffhgw)

## Основные понятия { #glossary }

Основные понятия в CI значительно отличаются от других систем непрерывной интеграции (Jenkins, Teamcity, Bamboo, Github Actions):

1. **Flow** - основная рабочая единица в CI. Представляет собой последовательность шагов, которые могут выполняться как последовательно, так и параллельно.

    ![Flow](img/flow.png "Flow" =800x)

    Аналогичные понятия в других системах непрерывной интеграции:

    * [Jenkins](https://www.jenkins.io/) - **build**
    * [Teamcity](https://www.jetbrains.com/teamcity/) - **build chain**
    * [Bamboo](https://www.atlassian.com/software/bamboo) - **job**
    * [Github Actions](https://github.com/features/actions) - **workflow**
    * [Gitlab CI](https://docs.gitlab.com/ee/ci/) - **pipeline**

2. **Job** (**задача**, **"кубик"**) - описание одного конкретного шага, выполняемого в процессе сборки. Например, компиляция исходного кода, сборка пакета, выкладка в тестовое окружение. Аналогичные понятия в других системах непрерывной интеграции:

    * [Jenkins](https://www.jenkins.io/) - **build step**
    * [Teamcity](https://www.jetbrains.com/teamcity/) - **build**
    * [Bamboo](https://www.atlassian.com/software/bamboo) - **task**
    * [Github Actions](https://github.com/features/actions) - **job step**
    * [Gitlab CI](https://docs.gitlab.com/ee/ci/) - **job**

    CI поставляется с большим набором доступных [готовых задач](jobs.md), который называется **реестр задач**. Если стандартных задач недостаточно, пользователь может описать и использовать собственные задачи.

3. **Action** - выполнение flow для **одного коммита** из единого репозитория. Задачи могут выполняться как в момент создания пулл-реквеста (т.н. **pre-commit check**, "прекоммитная проверка"), так и после принятия пулл-реквеста и добавления его изменений в основную ветку **trunk** единого репозитория (т.н. **post-commit check**, "посткоммитная проверка"). Примеры таких flow: выполнение дополнительных проверок пулл-реквестов, выкладка свежих изменений в коде приложения в [Yandex.Deploy](https://yd.yandex-team.ru/). Для одного проекта одновременно может выполняться произвольное количество actions, соответствующих разным коммитам и веткам.

   ![Actions](img/actions.png "Actions" =800x)

4. **Релиз** (**release**) - выполнение flow для **набора из нескольких коммитов** единого репозитория, содержащих требуемую функциональность. Релизы выполняются строго в порядке создания. Релиз также может делиться на произвольные **стадии** (**stage**), например, "сборка кода", "выкладка в тестинг", "выкладка в продакшн". В каждой стадии может выполняться одна или несколько задач. Каждая стадия релиза, соответствующего какому-то проекту, может быть занята только **одним активным релизом**. Например, нельзя выложить в тестинг новый релиз пока не выложили предыдущий релиз или не отменили его.

   ![Релизы](img/releases.png "Релизы" =600x)

## Среды исполнения { #runtimes }

Обычно системы непрерывной интеграции из внешнего мира (Jenkins, Teamcity, Bamboo и т.д.) используют отдельные машинки-агенты, на которые установлены все необходимые зависимости. CI отличается от этих систем тем, что выполняет каждую задачу в одной из поддерживаемых внешних систем (**сред исполнения**):

1. [Sandbox](https://sandbox.yandex-team.ru/) - система исполнения произвольных задач общего назначения. При использовании Sandbox каждая задача flow — это отдельная задача Sandbox.
2. [YT](https://yt.yandex-team.ru/) - сервис распределенного хранения и обработки данных с поддержкой модели MapReduce, имеющий поддержку выполнения [пользовательских задач](https://yt.yandex-team.ru/docs/description/mr/jobs). Поддержка YT находится в стадии разработки.
