# Готовые задачи (реестр)

В предыдущих разделах мы выяснили, что описание flow в файле **a.yaml** выглядит примерно так:

```yaml
service: my-abc-service-slug
ci:

  # ... secret, runtime, releases, triggers ...

  flows:
    my-flow:
      title: My Flow
      description: This flow does a lot of things.
      jobs:
        build: # Описание задачи
          title: Build My App
          task: common/arcadia/ya_package
          input:
            # ...
```

В этом разделе мы разберемся с тем откуда брать информацию о готовых задачах, из которых вы можете составлять flow, а в следующих научимся создавать собственные задачи.

## Реестр задач { #registry }

CI загружает информацию обо всех доступных задачах из специального каталога, хранящегося в едином репозитории. Этот каталог называется **реестром задач** и находится в [/ci/registry](https://a.yandex-team.ru/arc/trunk/arcadia/ci/registry). Реестр состоит из нескольких разделов-подкаталогов:

Раздел | Назначение
:--- | :---
**common** | Содержит описания базовых задач для сборки исходного кода, выкладки в облачные платформы, работу мониторингами и так далее.
**demo** | Содержит описания задач, используемых для демонстрации работы CI. В реальных проектах не используется.
**junk** | Содержит описания экспериментальных задач.
**projects** | Содержит описания задач, относящихся к конкретному проекту в едином репозитории. Внутри располагаются каталоги конкретных проектов.

Внутри каждого из разделов может располагаться набор каталогов произвольной вложенности. На самом нижнем уровне всегда
находится один или несколько файлов **<имя-задачи>.yaml**. Таким образом, указывая в **a.yaml** поле `task` равным,
например, `common/arcadia/ya_package` имеется в виду, что информация о задаче будет зачитана из
файла [/ci/registry/common/arcadia/ya_package.yaml](https://a.yandex-team.ru/arc/trunk/arcadia/ci/registry/common/arcadia/ya_package.yaml)
. Синтаксис YAML файла в реестре отличается от синтаксиса **a.yaml** и будет описан в следующих разделах.

В настоящий момент новые задачи можно создавать несколькими способами:

1. **Использовать готовую Sandbox задачу.** Для того, чтобы преобразовать
   задачу [Sandbox](https://sandbox.yandex-team.ru/) в задачу CI, нужно добавить в реестр YAML файл c указанием типа
   задачи, её входных параметров и требуемых вычислительных ресурсов.
2. **Использовать задачу на основе технологии Tasklet.** В этом случае необходимо описать задачу в
   виде [Protobuf](https://developers.google.com/protocol-buffers) файла, написать реализацию её работы на
   поддерживаемом языке программирования, а затем добавить YAML файл с описанием новой задачи в реестр.

{% note warning %}

Правка реестра не тригерит обновление используемой версии флоу в проекте. Изменения применяются в момент, когда
соотвествущий a.yaml **a.yaml** будет "потроган".
Т.е. либо будет изменен, либо в проекте появится любой коммит, который его задевает (см [{#T}](discovery.md)).

Это поведение будет исправлено в задаче [CI-933](https://st.yandex-team.ru/CI-933)

{% endnote %}
