# Управление доступом в CI

Существует возможность ограничить или расширить доступ пользователей к операциям в CI.
Такая возможность полезна для больших команд или работающих над одним `a.yaml` с разделением зон ответственности.
Например:
1) Файл `a.yaml` поддерживается одной командой, но запускаются все флоу другой командой, отвечающей за их работу.
2) Нужно дать доступ к запуску флоу сразу нескольким командам.
3) Запретить форсированную остановку или пропуск задач во флоу всем, кроме ответственных за релизы.

По умолчанию CI разрешает все операции над задачами всем пользователям, входящим в указанный в `a.yaml` сервис:
```yaml
service: ci # Все пользователи этого сервиса, независимо от роли, могут делать с задачами в этом a.yaml что угодно
title: Сборка CI
ci:
...
```

Существует возможность ограничить доступ к разным частям системы с помощью `permissions`.

Например, эта опция полностью аналогична настройкам по умолчанию:
```yaml
service: ci
title: Сборка CI
ci:
  permissions:
    start-flow:
      - service: ci
...
```

Можно разрешить доступ пользователей из разных сервисов
```yaml
service: ci
title: Сборка CI
ci:
  permissions:
    start-flow: # Разрешена работа пользователям из обоих сервисов
      - service: ci
      - service: testenv
...
```

## Варианты разрешений { #types }

{% note info %}

Все условия применяются как "или", т.е. доступ разрешен, если у человек имеет хотя бы одну роль/входит в одну группу/в одно дежурство.

{% endnote %}

Можно ограничить доступ группой ролей ABC в привязке к сервису (`scope` или группа ролей).
Разрешено использовать (в порядке приоритета) slug группы, английское наименование группы, русское наименование группы и числовой код.

```json
{
  "role": {
    "scope": {
      "id": 5,
      "slug": "development",
      "name": {
        "ru": "Разработка",
        "en": "Development"
      }
    }
  }
}
```

```yaml
service: ci
title: Сборка CI
ci:
  permissions:
    start-flow:
      - service: ci # Разрешена работа пользователям из сервиса ci с группой development
        scope: development
      - service: testenv
        scope: # Все эти значения полностью равноправны. Можно выбирать способ фильтрации, который вам удобен
          - development # slug
          - Development # name.en
          - Разработка # name.ru
          - 5 # id
...
```

Можно огранчить доступ ролью ABC в привязке к сервису (`role` или роль).
Разрешено использовать (в порядке приоритета) code роли, английское наименование роли, русское наименование роли и числовой код.

```json
{
  "role": {
    "id": 8,
    "name": {
      "ru": "Разработчик",
      "en": "Developer"
    },
    "code": "developer"
  }
}
```

```yaml
service: ci
title: Сборка CI
ci:
  permissions:
    start-flow:
      - service: ci # Разрешена работа пользователям из сервиса ci с ролью developer
        role: developer
      - service: testenv
        role:  # Все эти значения полностью равноправны. Можно выбирать способ фильтрации, который вам удобен
          - developer
          - Developer
          - Разработчик
          - 8
...
```


Можно огранчить доступ значением расписания (`duty`).
Разрешено использовать (в порядке приоритета) slug расписания, название расписания и числовой код.

```json
[
  {
    "id": 4886457,
    "schedule": {
      "id": 3080,
      "name": "CI Task Duty",
      "slug": "task-duty"
    },
    "is_approved": true,
    "start_datetime": "2022-02-28T00:00:00+03:00",
    "end_datetime": "2022-03-07T00:00:00+03:00"
  },
]
```

```yaml
service: ci
title: Сборка CI
ci:
  permissions:
    start-flow:
      - service: ci # Разрешена работа пользователям из сервиса ci с ролью developer
        duty: task-duty
      - service: testenv
        duty:  # Все эти значения полностью равноправны. Можно выбирать способ фильтрации, который вам удобен
          - task-duty
          - CI Task Duty
          - 3080
...
```

Можно использовать несколько условий одновременно. В этом случае логика тоже "or" - т.е. проверяется наличие доступа хотя бы к одной из указанных сущностей:
```yaml
service: ci
title: Сборка CI
ci:
  permissions:
    start-flow:
      - service: ci
        scope: Разработка
        role: Developer
        duty: task-duty
...
```

## Блоки разрешений { #scopes }

{% note info %}

Настройки разрешения на `start-flow` - это настройка по умолчанию.
Все разрешения наследуют эти правила, если не переопределены.

{% endnote %}

Существуют следующие разрешения:
* `start-flow` - ручной запуск любого flow (action-а или релизов), а также любые действия с flow (настройка по умолчанию для всех остальных разрешений)
* `start-hotfix` - запуск Hotfix релизов
* `rollback-flow` - запуск Rollback релизов
* `cancel-flow` - отмена flow (action-ов или релизов)
* `add-commit` - ручное добавление коммита
* `create-branch` - ручное создание бранча
* `start-job` - ручной запуск задачи (например, после manual trigger-а) или перезапуск упавшей задачи
* `skip-job` - пропуск задачи (как правило, упавшей)
* `toggle-autorun` - переключение автозапуска
* `kill-job` - отмена выполняемой задачи
* `manual-trigger` - включение/выключение manual trigger-а


## Переопределение правил для action-ов и релизов { #override }

Все action-ы и релизы наследуют базовые разрешения.
Но также существует возможность их переопределить:
```yaml
service: ci
title: Сборка CI
ci:
  permissions:
    start-flow:
      - service: ci # Операции от пользователя в scope=development в сервисе ci
        scope: development

  actions:
    my-action:
      flow: flow-action
      permissions: # Унаследованы все операции от пользователя в scope=development в сервисе ci
          kill-job: # А вот останавливать задачи могут только пользователи в scope=administration
          - service: ci
            scope: administration
    ...
  releases:
    my-release:
      flow: release-action
      permissions:
        start-flow:
          - service: ci # Операции от любого пользователя из сервиса ci
    ...
...
```

## Запрет на доступ к управлению кубиками для автора прекоммитной проверки { #default-permissions-for-owner }

По умолчанию автор прекоммитной проверки (action on pr) имеет полный доступ к управлению кубиками в этом flow, независимо от текущих настроек `permissions`, а именно к правам:
* SKIP_JOB
* START_JOB
* MANUAL_TRIGGER
* KILL_JOB


В исключительных случаях можно запретить такое поведение, добавив опцию `default-permissions-for-owner` в блок `permissions` на любом уровне:
```yaml
service: ci
title: Сборка CI
ci:
  permissions:
      default-permissions-for-owner: [] # По умолчанию эта опция имеет значение "default-permissions-for-owner: pr"
```

Также можно разрешить доступ владельца к управлению кубиками и для посткоммитных проверок, и для релизов:
```yaml
service: ci
title: Сборка CI
ci:
  permissions:
      default-permissions-for-owner:
        - pr      # прекоммитные action-ы
        - commit  # посткоммитные action-ы
        - release # релизы
```

## Кастомизация разрешений (аппрувы) изменений в a.yaml { #config-edit-approvals }

[По умолчанию](secret.md#security) любые изменения в a.yaml, сделанные человеком не из сервиса (указанном в этом a.yaml) требуют аппрува от людей из сервиса - такое требование будет сформировано в виде комментария в пулл реквесте (в коммите без пулл реквеста конфиг станет неделегированным и потребует делегации уже в интерфейсе CI).

Такое поведение можно изменить, задав нужные вам сервисы и scope-ы в параметре `config-edit-approvals`.

По умолчанию эта настройка выглядит так:
```yaml
service: ci
title: Сборка CI
ci:
    config-edit-approvals:
        - service: ci # Значение из поля `service`, требовать approve-а от любого человека из ABC сервиса ci
```

А можно уточнить такие правила:
```yaml
service: ci
title: Сборка CI
ci:
    config-edit-approvals:
        - service: ci
          scope: administration # Требовать approve-а от людей из scope-а `administration` ABC сервиса ci
```

Правила аппрува работают аналогично [разрешениям в параметре permissions](permissions.md#types).
