# Быстрый старт

Для того, чтобы подключить CI к своему проекту, требуется выполнить три простых шага:

1. Получить и сохранить в [Секретницу](https://yav.yandex-team.ru/) [OAuth](https://en.wikipedia.org/wiki/OAuth)-токен для пользователя-робота, от имени которого будут запускаться flow.
2. Создать в каталоге проекта файл **a.yaml** с описанием flow и добавить его в единый репозиторий через пулл-реквест.
3. Разрешить доступ к секретам. Доступ будет автоматически запрошен при первом запуске любого flow с использованием нового секрета в **a.yaml**.

## Шаг 1. Получение токена { #get-token }

1. Выберите или [создайте](https://wiki.yandex-team.ru/tools/support/zombik/) служебного пользователя-робота, от имени которого будут запускаться flow. Дождитесь тикета HDRFS с паролем, он пригодится на втором этапе.
2. Зайдите по [ссылке](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=5c2eb9ec7cc74dcd960f400ff32b7b38) от имени этого робота и получите токен. Проверьте, что вы действительно зашли от имени робота (это можно увидеть в правом верхнем углу).
3. Создайте секрет в [Секретнице](https://yav.yandex-team.ru/) и положите в него токен в ключ с именем `ci.token`. Рекомендуется, чтобы к секрету был доступ у всей команды сервиса. После создания секрета вы увидите его ID вида `sec-XXXXXX`. В данный секрет в дальнейшем нужно складывать любые другие секретные данные, которые могут потребоваться вам в работе flow.
   ![Создание токена для CI](img/ci-token.png "Создание токена для CI" =800x)
4. Убедитесь в том, что у вашего пользователя-робота есть доступ к созданному секрету через доступ команды или выдайте его явно.
5. Убедитесь, что у вас есть [квота (группа) в Sandbox](https://sandbox.yandex-team.ru/admin/groups) и в этой квоте прописан ваш робот. Если квоты ещё нет, то [её нужно завести](https://docs.yandex-team.ru/sandbox/quota#manage-quotas). Квота понадобится на следующем шаге для параметра `sandbox-owner`.

## Шаг 2. Создание файла a.yaml { #create-a-yaml }

В данном примере мы хотим настроить CI таким образом, чтобы на каждый коммит в trunk, выводилось `Hello world!`.

{% note warning %}

В параметре `service` мы требуем указывать `slug` вашего сервиса в ABC строчными буквами - это является привычным способом указания `slug`-ов в Яндексе.

{% endnote %}

1. Создайте в каталоге проекта файл **a.yaml** со следующим содержимым:

    ```yaml
    service: my-abc-service-slug # Slug вашего сервиса в ABC (https://abc.yandex-team.ru/)
    title: Hello World Project # Имя проекта на странице CI
    ci:
      secret: sec-XXXXXX # Токен для работы самого CI и другие секреты
      runtime: # Где запускать flow
        # Квота в Sandbox (https://sandbox.yandex-team.ru/admin/groups)
        sandbox-owner: MY_SANDBOX_GROUP
      actions:
        hello-world-flow:
          title: Hello world action
          flow: hello-world-flow
          triggers: # При каких условиях запускать flow
            - on: pr # Запускаем flow hello-world-flow на создание/обновление пулл-реквеста
              into: trunk
      flows: # Описания сборок
        hello-world-flow: # Объявление flow hello-world-flow
          title: Print Hello World
          jobs: # Задачи конкретного flow
            echo-hello-world:
              title: Print Hello World
              # Описание задачи (https://a.yandex-team.ru/arc/trunk/arcadia/ci/registry/common/misc#commonmiscrun_command)
              task: common/misc/run_command
              input:
                config:
                  arc_mount_config:
                    enabled: true
                  cmd_line: |
                    set -x
                    echo Hello world!
                    echo List arcadia directory:
                    ls -la
    ```
   {% note warning %}

    * Файл должен называться **a.yaml**. Если написать **a.yml** - не будет работать.
    * В данном примере указан сервис `My-abc-service-slug` и квота MY_SANDBOX_GROUP в Sandbox. Вам нужно подставить сюда свои значения.

   {% endnote %}

2. Создайте пулл-реквест с этим файлом:

    ```bash
    $ arc checkout -b new-a-yaml
    $ arc add a.yaml
    $ arc commit -m 'Added a.yaml'
    $ arc pr create --push --publish
    ```

   При проверке пулл-реквеста происходит автоматическая проверка синтаксиса файла **a.yaml**.

   {% note warning %}
    * При создании нового a.yaml мы запросим делегацию секрета прямо в комментариях в вашем Pull Request-е. Зачем это нужно будет описано в следующем разделе.

   ![Подтверждение делегации для CI](img/ci-delegation.png "Подтверждение делегации для CI" =800x)

    * Если вы правите a.yaml и не являетесь частью команды ABC сервиса, который этим a.yaml владеет (`service`), то в пулл-реквесте робот добавит такой же комментарий.

    * Без подтверждения делегации ваши изменения применены не будут.

   {% endnote %}

3. После того как файл **a.yaml** добавлен в единый репозиторий, он автоматически считывается и описанные в нем flow становятся доступны в [интерфейсе CI](https://a.yandex-team.ru/ci/).

   {% note warning %}

    Путь до файла `a.yaml` является частью идентификатора релиза или экшена. При перемещении файла все процессы из него будут считаться новыми, с независимой историей, версиями и т.д.

   {% endnote %}

## Шаг 3. Разрешить доступ к секретам { #allow-secret-access }

Этот шаг необходим для того, чтобы Sandbox смог запускать задачи под вашим роботом - выполняя безопасное обращение к вашим секретам в Секретнице.

Система безопасности Секретницы устроена таким образом, что для того, чтобы внешняя система могла получить доступ к вашим секретам (токенам, паролям, ключам и т.д., которые вы будете использовать в задачах CI), необходимо **один раз** разрешить доступ к этим секретам вручную. В случае CI токен из поля `secret` в **a.yaml** передается в Sandbox (это и есть внешняя система), т.к. скачивает нужные секреты именно Sandbox.

Разрешение доступа к секретам для внешней системы называется **делегированием** или **выдачей делегирующего токена**. Для того, чтобы разрешить доступ, необходимо один раз запустить flow вручную и подтвердить разрешение через пользовательский интерфейс. Например, это можно сделать в окне ручного запуска релиза:

![Пример делегирования токена](img/ui/token-delegation-during-release-launch.png "Пример делегирования токена" =800x)

Подробнее о том, как устроен пользовательский интерфейс рассказывается в следующем разделе.


# Не только CI: полный старт со всем стеком Яндекса { #complete-start }

[Как я перестал волноваться и полюбил выкладки в Deploy через новый CI](https://guschin.at.yandex-team.ru/753)
