# Безопасность и cекреты

## Секреты { #secret }

**Секрет** - любые данные, которые нужно хранить и загружать из безопасного хранилища. Обычно секреты - это пароли, токены, закрытая часть пары SSH или GPG ключей и так далее. Рекомендуемым решением для хранения секретов в Яндексе является [Секретница](https://yav.yandex-team.ru/).

{% note warning %}

CI позволяет одновременно использовать только один секрет из Секретницы. Все секретные данные, которые вы хотите использовать в flow, должны быть скопированы в секрет, указанный в **a.yaml**.

{% endnote %}

В предыдущих разделах уже упоминалось, что секрет указывается в **a.yaml** следующим образом:

```yaml
service: my-abc-service-slug # Сервис в https://abc.yandex-team.ru/
title: Hello World Project
ci:
  secret: sec-XXXXXX # Идентификатор секрета в Секретнице

  # Остальные разделы...
```

Получение конкретного секрета выполняется в коде задачи. В [контексте](flow.md#context) задачи автоматически передается идентификатор секрета, указанный в поле `secret`. Код задачи может самостоятельно обратиться к нужному ключу в секрете и использовать его значение. Обычно значение ключа либо жестко зафиксировано в коде задачи, либо имеется параметр, позволяющий указать из какого ключа брать значение. Например:


```yaml
service: my-abc-service-slug
title: My Project in CI
ci:

  # ... secret, runtime, releases, triggers ...
  flows:
    my-flow:
      title: My Flow
      jobs:
        deploy:
          title: Deploy App
          task: common/deploy/release
          input:
            config:
              releaseTokenYavKey: my-token-key # Из какого ключа в секрете брать токен
```

Подробности о том, как передавать секреты в конкретной задаче, следует читать в её документации.

## Безопасность { #security }

В предыдущие годы [происходили](https://clubs.at.yandex-team.ru/security/12583) ситуации, когда все сборки совершенно разных команд, выполнялись от имени одного и того же пользователя-робота. Это значит, что потенциально одна команда могла получать доступ в системы, к которым у неё не должно было быть доступа. Например, это могло привести к тому, что злоумышленник мог выкладывать чужие приложения или создавать пакеты с вредоносным кодом. В CI эта проблема решена на уровне архитектуры.

1. Каждая команда обязана выполнять все свои flow от имени **собственного пользователя-робота**. Все доступы, токены и секреты выдаются на этого робота и хранятся в [Секретнице](https://yav.yandex-team.ru/). Если у вас нет такого пользователя, его можно завести через [форму](https://wiki.yandex-team.ru/tools/support/zombik/).

2. Для работы CI требуется токен для доступа к [исходным кодам](https://a.yandex-team.ru/) единого репозитория и в API [Sandbox](https://sandbox.yandex-team.ru/). Запросить токен можно, зайдя от имени робота по [ссылке](https://oauth.yandex-team.ru/authorize?response_type=token&client_id=5c2eb9ec7cc74dcd960f400ff32b7b38). CI ищет данный токен в ключе `ci.token` в секрете, указанном в **a.yaml**.

3. Когда вы начинаете работу с CI, он от имени робота получает значение токена `ci.token` и дальше с его помощью запускает задачи в Sandbox. Sandbox работает совершенно независимо от CI и является внешней системой по отношению к нему. Поэтому для того, чтобы Sandbox мог использовать токен `ci.token` необходимо один раз вручную выдать разрешение на это. Подобная операция называется **делегированием токена** и [выполняется](quick-start-guide.md#allow-secret-access) через пользовательский интерфейс CI.

4. Права на изменение конфигурации **a.yaml** имеют только сотрудники, состоящие в [ABC](https://abc.yandex-team.ru/) сервисе, указанном в нем (хотя это поведение [можно изменить](permissions.md#config-edit-approvals)). Если конфигурацию меняет кто-то не из её владельцев, CI прекращает запускать такую конфигурацию и требует подтверждения от её владельцев (через [UI](ui.md) CI системы или [Arcanum](https://a.yandex-team.ru/)).

5. Если в конфигурации меняется ABC сервис, CI прекращает запускать эту конфигурацию и требует заново делегировать токен во внешние системы.

6. Запускать релизы и action-ы вручную могут только пользователи, входящие в ABC сервис, указанный в конфиге CI.
