# Пользовательский интерфейс

Пользовательский интерфейс CI встроен в [Arcanum](https://a.yandex-team.ru/) и располагается по адресу: [https://a.yandex-team.ru/ci/](https://a.yandex-team.ru/ci/).

## Список проектов { #projects-list }

![Список проектов](img/ui-projects-list.png "Список проектов" =800x)

Главная страница CI отображает **список проектов**, т.е. те сервисы в [ABC](https://abc.yandex-team.ru/), для которых в репозитории были созданы файлы **a.yaml**. По умолчанию отображается список избранных проектов, который может изначально быть пуст.

![Все проекты](img/ui-all-projects.png "Все проекты" =800x)

Для того, чтобы просмотреть все существующие проекты, нужно переключиться на вкладку **All**. На ней же можно добавить интересующие проекты в список избранных.

## Страница проекта { #project-page }

На странице проекта отображаются все flow, описанные в **a.yaml** файлах, которые относятся к одному ABC-сервису (поле `service: ` в соответствующем **a.yaml** файле ). В проектном каталоге может быть создано любое количество каталогов с файлом **a.yaml**. По умолчанию все flow, определенные во всех таких файлах, отображаются общим списком. В этом списке **releases** (релизы) и **actions** сгруппированы отдельно.

![Общий список flow проекта](img/project-page-combined.png "Общий список flow проекта" =800x)

При необходимости можно переключиться в режим, когда flow, относящиеся к разным файлам **a.yaml**, показываются отдельно.

![Пофайловый список flow проекта](img/project-page-per-file.png "Пофайловый список flow проекта" =800x)

При нажатии на один из flow в списке релизов отображается список релизов, выполненных при помощи данного flow. Внутри каждого релиза можно увидеть список коммитов, вошедших в него. Также при нажатии на заголовок релиза можно перейти на страницу со списком выполненных задач. Для ручного запуска нового релиза нужно нажать на кнопку **Run release** и указать коммит, который будет использоваться для создания релиза:

![Запуск релиза вручную](img/project-page-manual-release.png "Запуск релиза вручную" =800x)

При нажатии на один из flow в списке actions отображаются все запуски, связанные с этим flow. В списке указана информация о ревизии, на которой выполняется flow, его состояние и список тегов. Есть возможность закрепить (pin) flow и присвоить им произвольные теги.

![Список actions](img/project-page-actions-list.png "Список actions" =800x)

Для ручного запуска нового action нужно нажать на кнопку **Run action** и указать коммит, который будет использоваться:

![Запуск action вручную](img/project-page-manual-action.png "Запуск action вручную" =800x)

## Страница запуска { #flow }

Из любого релиза или action можно перейти на список задач, которые выполнялись при его работе. Для каждой задачи присутствует ссылка на ее запуск в соответствующей среде исполнения (например, Sandbox). Также может указываться другая дополнительная информация, зависящая от самой задачи. Например, при выкладке сервиса в [Yandex.Deploy](https://yd.yandex-team.ru/) может указываться ссылка на соответствующее окружение.

![Список задач](img/ui-flow.png "Список задач" =800x)

При падении отдельных задач можно перезапустить их без перезапуска всего flow:

![Перезапуск задач](img/ui-flow-restart.png "Перезапуск задач" =600x)
