Observer reader
=============

Отвечает за обработку потока данных от автосборочных задач и стораджа, вычисляет время выполнения стадий автосборочных проверок.

Архитектура и модель данных
-----------------------
**Чек (проверка), Итерация, Чек таска (таска)** - аналогично Storage
**Трейс** - сообщение о начале/завершении отдельных стадий итерации/таски (таблица `CheckTasksPartitionTraces`)

---

**Стейбл и тестинг на данный момент читают одинаковые внешние топики**

Observer-reader читает данные из следующих внешних топиков LB:
1. `/ci/autocheck/stable/main/trunk/precommit` - транковые прекоммиты (от автосборочных задач)
2. `/ci/autocheck/stable/main/trunk/postcommit` - транковые посткоммиты (от автосборочных задач)
3. `/ci/autocheck/stable/main/branch/precommit` - бранчевые прекоммиты (от автосборочных задач)
4. `/ci/autocheck/stable/main/branch/postcommit` - бранчевые посткоммиты (от автосборочных задач)
5. `/ci/autocheck/stable/events` - различные ивенты: регистрация, отмена, трейсы стораджа, завершение обработки итерации (от Storage)

Observer-reader пишет и читает данные из следующих внутренних топиков LB:
1. `/ci/autocheck/stable/observer/internal` - стейбл обсервера
2. `/ci/autocheck/testing/observer/internal` - тестинг обсервера

---

Схема обработки сообщений:

- `/ci/autocheck/stable/main/*` обрабатывваются в `ObserverMainStreamReadProcessor` -
напрямую обрабатываются только трейсы (пишутся в базу), остальные сообщения перекладываются в топик **internal**.
- `/ci/autocheck/stable/events` обрабатывваются в `ObserverEventsStreamReadProcessor` -
напрямую обрабатываются сообщения регистрации (`ObserverRegistrationProcessor`), трейсы (пишутся в базу), остальные сообщения перекладывваются в топик **internal**.
- `/ci/autocheck/*/observer/internal` обрабатывается в `ObserverInternalStreamReadProcessor` -
партиция выбирается на основе checkId таким образом, что данные по одному чеку отправляются всегда в одну партицию **internal**,
это позволяет работать с одним чеком/итерацией/таской в рамках одного потока и использовать кеши.

---

Вычисление времени выполнения стадий
-----------------------

Вся агрегация отдельных трейсов во времена выполнения стадий тасок и итераций выполняется в `StageAggregationUtils`.

1. Трейсы агрегируются для отдельных тасок и партиций в `timestampedStagesByPartitions` -
эти метрики соответствуют детальному графику времени выполнения отдельной итерации по таскам и партициям
([пример](https://datalens.yandex-team.ru/preview/7hom905swaes0-ci-autocheck-iteration-tasks-stages-new?checkId=50100000001086&iterationType=FULL&iterationNumber=1)).
2. Для дальнейшей агрегации всех тасок в итерацию трейсы агрегируются в `timestampedStagesAggregation`,
эта метрика считается отлично от детальной метрики по партициям:
они вычисляются в "плоском" варианте, когда одновременно исполняется лишь одна стадия,
к примеру в `timestampedStagesByPartitions` SANDBOX стадия считается от старта до завершения sandbox задачи, а в "плоском" варианте до начала стадии CONFIGURE.
3. Далее выполняется агрегация времени выполнениия стадий итерации на основе стадий тасок в `stagesAggregation` -
эти метрики соответствуют столбчатому графику итераций ([пример](https://datalens.yandex-team.ru/preview/t1lmiunbx24sm?pool=ANY_POOL))
