# Тасклеты Фронтенда

## common/frontend/hermione

Тасклет для запуска [hermione](https://github.com/gemini-testing/hermione)-тестов в окружении [Sandbox'a](https://sandbox.yandex-team.ru).

### Конфигурирование

Пример запуска hermione-тестов со всеми доступными полями в `input`:

```yaml
flows:
  # ...
  example-flow:
    jobs:
      # ...
      run_hermione:
        title: Run hermione tests
        task: common/frontend/hermione
        input:
          config:
            # Команда запуска hermione-тестов. Для запуска hermione необходимо запустить тасклет в окружении вашего LXC-контейнера.
            # В контейнере стоит поставлять как минимум nvm, node и пакетный менеджер (например, npm).
            run_tests_cmd: |
              ./node_modules/.bin/hermione

            # Путь до проекта относительно корня аркадии (cwd). Переходит в нее после маунта аркадии и затем запускает тесты
            project_dir: frontend/projects/web4

            # Аркадия всегда монтируется при запуске тасклета
            arc_mount:
              revision_hash: "trunk"  # (optional) Если не указывать, будет взят из контекста по ключу `context.target_revision.hash`, т.е. текущая ревизия на которой выполняется flow

            # Подготовка окружения. Указанные переменные окружения будут доступны по указанному ключу (например, $SOME_ENVIRONMENT) в команде запуска тестов
            environment:
              # Публичные переменные окружения
              variables:
                - key: SOME_ENVIRONMENT
                  value: some_value
              # Переменные окружения, которые заполняются из секретницы (yav).
              # У робота, от имени которого выполняется тасклет, должен быть доступ к секрету.
              # Секрет должен быть проделегирован для CI. Секрет в `a.yaml` (`ci:secret`) уже проделегирован, поэтому лучше использовать его.
              secret_variables:
                - key: SOME_AUTH_TOKEN
                  secret_spec:
                    uuid: sec-01fy8yvd4w1b35mrhcrr2akzn2 # (optional) Если не указывать, будет взят `ci:secret`
                    key: some.token # Название ключа по которому сохранен секрет в yav
              # Переменные окружения, которые сохраняются в секретнице (yav) в виде файлов.
              # В переменной окружения будет находится содержимое файла закодированное в base64.
              # Требования к секрету аналогичны `secret_variables`.
              secret_file_variables:
                - key: FILE_AUTH_TOKEN
                  secret_spec:
                    uuid: sec-01fy8yvd4w1b35mrhcrr2akzn2 # (optional) Если не указывать, будет взят `ci:secret`
                    key: file.token # Название ключа по которому сохранен секрет в yav

            # Перечисление ресурсов, которые необходимо найти в sandbox или в списке ресурсов, созданных выше по графу (находятся в контексте тасклета), и скачать.
            # Скачивание ресурсов осуществляется после маунта аркадии и до запуска hermione-тестов.
            # При поиске русурсов в графе должен находиться один единственный ресурс. Если найдется 0 или больше 1, то тасклет упадет и нужно будет уточнить фильтр.
            # При поиске ресурсов в sandbox ищется последний созданный ресурс удовлетворяющий фильтру. Если ресурс не был найден, то тасклет упадет и нужно будет уточнить фильтр.
            # Для корректной фильтрации должно быть указано хотя бы одно из следующих полей: `id`, `task_id`, `type`, `attributes`
            dependent_resources:
              # Пример скачивания заархивированного результата сборки из графа
              - search: graph # (optional) Где необходимо искать ресурс. По умолчанию `graph`. Другое возможное значение - `sandbox`
                placeholder: build # (optional) Содержит путь до скачанного ресурса. Подставляется в команду пользователя, т.е. обратиться к ресурсу можно, указав в команде `{build}`. Название плейсхолдеров должно быть уникально
                uncompress: true # (optional) Флаг, определяющий нужно ли распаковать скачанный ресурс или нет. По умолчанию `true`. Распаковка происходит в случае, если архив имеет расширение `tar`, `tgz` или `tar.gz`
                path: my_resources # (optional) Путь до папки относительно указанного project_dir, в которую разархивируется ресурс. По умолчанию разархивируется в project_dir. В данном примере результат сборки окажется в ${project_dir}/my_resources/build
                id: 2898182411 # (optional) ID ресурса в sandbox
                task_id: 1252448793 # (optional) ID таски, в которой был зарегистрирован ресурс
                type: OTHER_RESOURCE # (optional) Тип ресурса в терминах sandbox
                attributes: # (optional) Список дополнительных атрибутов, которые должны присутствовать в ресурсе
                  type: build
                  ttl: inf

              # Пример скачивания незаархивированного результата сборки (build_2) из sandbox
              - search: sandbox # (optional) Где необходимо искать ресурс. По умолчанию `graph`. Другое возможное значение - `sandbox`
                placeholder: build_2 # (optional) Содержит путь до скачанного ресурса. Подставляется в команду пользователя, т.е. обратиться к ресурсу можно, указав в команде `{build_2}`. Название плейсхолдеров должно быть уникально
                uncompress: false # (optional) Флаг, определяющий нужно ли распаковать скачанный ресурс или нет. По умолчанию `true`. Распаковка происходит в случае, если архив имеет расширение `tar`, `tgz` или `tar.gz`
                path: my_resources # (optional) Путь до папки относительно указанного project_dir, в которую сохранится ресурс. По умолчанию сохраняется в project_dir. В данном примере результат сборки окажется в ${project_dir}/my_resources/build_2
                id: 2898182686 # (optional) ID ресурса в sandbox
                task_id: 1252448793 # (optional) ID таски, в которой был зарегистрирован ресурс
                type: OTHER_RESOURCE # (optional) Тип ресурса в терминах sandbox
                attributes: # (optional) Список дополнительных атрибутов, которые должны присутствовать в ресурсе
                  type: build_2
                  ttl: inf

            # Возможность сохранить ресурсы из тасклета после выполнения тестов.
            # Путь до ресурса указывается относительно project_dir и затем копируется в рабочую директорию таски.
            # Копирование необходимо так как при завершении тасклета арк размонтируется и пути для сохраняния ресурсов становятся не доступны.
            # Сохраненные ресурсы попадут в output тасклета и их можно будет использовать дальше по графу.
            result_resources:
              # Пример сохранения файла
              - path: .hermione.conf.js # Путь до файла относительно указанного project_dir
                target_path: .hermione_2.conf.js # (optional) Уникальный путь до файла в рабочей директории таски куда копируется файл указанный в path. Необходим в случае когда создается несколько ресурсов с одинаковым полем path. По умолчанию используется значение из path
                description: Example # Описание ресурса в sandbox
                type: OTHER_RESOURCE # Тип ресурса в терминах sandbox
                compression_type: none # (optional) Флаг, определяющий сжатие данных ресурса. По умолчанию "tgz". Другие возможные значения "none" и "tar"
                optional: true # (optional) Если файл/папка не будет найдена по указанному пути, то исключение не будет выброшено. По умолчанию `false`
                attributes: # Список дополнительных атрибутов для установки в ресурс, любые комбинации ключ+значение
                  released: stable
                  ttl: inf
              # Пример сохранения папки в виде tar.gz архива.
              # Название папки будет включено в собранный архив.
              - path: hermione-report # Путь до папки относительно указанного project_dir
                target_path: hermione-report-tgz # (optional) Уникальный путь до папки в рабочей директории таски куда копируется папка указанная в path. Необходим в случае когда создается несколько ресурсов с одинаковым полем path. По умолчанию используется значение из path
                description: Tgz example # Описание ресурса в sandbox
                type: OTHER_RESOURCE # Тип ресурса в терминах sandbox
                compression_type: tgz # (optional) Флаг, определяющий сжатие данных ресурса. По умолчанию "tgz". Другие возможные значения "none" и "tar"
                optional: true # (optional) Если файл/папка не будет найдена по указанному пути, то исключение не будет выброшено. По умолчанию `false`
                attributes: # Список дополнительных атрибутов для установки в ресурс, любые комбинации ключ+значение
                  released: stable
                  ttl: inf
                ci_badge: true #(optional) Если указан, то ссылка на этот ресурс будет добавлена badge-ем в кубик CI
                ci_badge_path: index.html #(optional) Если указан, то в badge будет добавлена ссылка именно на этот файл в загруженной директории
```

#### Пример настройки node перед запуском hermione-тестов

Hermione - это нодовая библиотека и для ее выполнения необходим [node.js](https://nodejs.org/en/), который обычно поставляется с помощью [nvm](https://github.com/nvm-sh/nvm). В примере предположим, что они к нам приезжают из нашего [LXC-контейнера](https://linuxcontainers.org/).

```yaml
flows:
  # ...
  example-flow:
    jobs:
      # ...
      run_hermione:
        title: Run hermione tests
        task: common/frontend/hermione
        requirements:
          # Используем LXC контейнер
        input:
          config:
            # "/opt/nvm" - следует поменять на вашу папку в которую вы установливаете nvm в контейнере.
            run_tests_cmd: |
              . /opt/nvm/nvm.sh
              nvm use

              ./node_modules/.bin/hermione
```

#### Пример запуска с использованием LXC контейнера

В [sandbox](https://sandbox.yandex-team.ru) есть возможность запустить тасклет в окружении [LXC контейнера](https://docs.yandex-team.ru/ci/requirement#lxc). В контейнер устанавливается все необходимое окружение (инструменты, библиотеки, компиляторы и т.д.). Для запуска с использованием LXC необходимо сообщить запускаемой задаче id-ресурса в котором находится ваш контейнер.
Также следует добавить условие `LXC` в список тэгов, чтобы задача не запланировалась на несовместимой машинке.

```yaml
flows:
  # ...
  example-flow:
    jobs:
      # ...
      run_hermione:
        title: Run hermione tests
        task: common/frontend/hermione
        requirements:
          sandbox:
            client_tags: GENERIC & LINUX & SSD & LXC # Теги Sandbox, позволяющие выбрать конкретные агенты
            container_resource: 2696926739 # Ресурс, из которого запускается LXC-окружение задачи
        input:
          config:
            # ...
```
