Тасклеты для проведения нагрузочного теста и оценки его результатов.
=====

### Тасклет нагрузочного тестирования.
Выполняет обстрел по заданному конфигурационному файлу. Для использования тасклета:
- Проведите предварительные стрельбы и определитесь с конфигурацией стрельбы для автоматического запуска.
- Положите эту конфигурацию в аркадию или хранилище ресурсов.
- Получите OAuth токен для запуска задач в [Sandbox](https://docs.yandex-team.ru/sandbox/api) и положите его в секрет, который указан в вашем a.yaml.
- Сконфигурируйте задачу, добавив в `input` необходимые поля.

**Пример конфигурации**
  ```yaml
    sandbox:
      owner: LOAD # Владелец дочерней sandbox задачи.
      token: sandbox_oauth_token # OAuth токен для Sandbox.
      description: Shooting via CI # Описание для задачи нагрузочного тестирования.
    load:
      config: arcadia/load/tools/ci-example/load.yaml # путь от корня Аркадии до файла конфигурации или http ссылка на ресурс с этим файлом.
  ```

### Тасклет оценки стрельбы
Выполняет сравнение результатов стрельбы от тасклета нагрузочного тестирования с соответствующими результатами стрельб из заданного списка по заданному критерию. Для использования тасклета:
- Проведите предварительные стрельбы с тем же конфигом, что используется в тасклете нагрузочного тестирования и выберите из них те, результаты которых удовлетворяют критериям стрессоустойчивости сервиса.
- Получите OAuth токен для [StartTrek](https://wiki.yandex-team.ru/tracker/api/) и положите его в секрет, который указан в вашем a.yaml (*опционально*).
- Сконфигурируйте задачу добавив в `input` необходимые поля.

**Пример конфигурации**
  ```yaml
    conditions:
      reference: [111, 222, 333] # список ID стрельб, с которыми будет проводиться сравнение.
      threshold: 7 # допустимый порог превышения в % (опционально, по умолчанию 5%).
      tests: ['quantile50', 'quantile80', 'http_codes'] # список тестов оценки (опционально).
      ticket: LOAD-1111 # Тикет в StarTrek для комментария (опционально).
      st_token: ROBOT_STARTREK_TOKEN # OAuth токен для StarTrek (опционально).
  ```

Более подробно о тасклетах нагрузочного тестирования можно узнать на страницах нашей документации:
[О нагрузочном тестировании в CI](https://wiki.yandex-team.ru/Load/howto/CI_load_way/)
[О тасклетах нагрузочного тестирования](https://wiki.yandex-team.ru/Load/themethod/tasklet_shooting/)
