# Тасклеты Метрики

Представленные здесь тасклеты большей частью являются фасадами к Sandbox-задачам, которые используются для
построения [пайплайнов](https://wiki.yandex-team.ru/users/konkov/pipelines-in-sandbox/realizacija/).

Что бы эффективно использовать эти элементы в workflows в CI нужно что бы их входы и выходы были типизированы,
причём так, что бы входы одних тасклетов описывались через типы, описывающие выходы других тасклетов.

Поэтому proto-файлы потребляющего некоторый ресурс тасклета импортируют proto-файлы порождающего данный ресуср тасклета.

Сама же реализация тасклета является фасадом, который содержит следующую логику:
1. Преобразование входных ресурсов в параметры Sandbox-задачи.
1. Запуск и ожидание Sandbox-задачи.
1. Формирование выходных ресурсов на основе результатов из выходных параметров Sandbox-задачи и значений в её контексте.

Основную работу в рамках данного подхода выполняют уже имеющиеся Sandbox-задачи, что позволяет их напрямую переиспользовать.

## ```projects/metrika/build_deb_package```
### Описание
Выполняет сборку одного или нескольких Deb-пакетов на основе файлов ```package.json```.

Является фасадом Sandbox-задачи ```METRIKA_YA_PACKAGE```.

### Вход
1. ```sandbox``` - артефакт с параметрами, специфичными для Sandbox
   1. ```owner``` - владелец задачи
1. ```packages``` - артефакт с перечнем пакетов для сборки
   1. ```paths``` - список путей в аркадии до файлов ```package.json```
1. ```upload``` - артефакт с перечнем пакетов для сборки
   1. ```key_user``` - пользователь для загрузки пакетов на dist
   1. ```publish_to``` - репозиторий для загрузки на dist

### Выход
1. ```packages``` - множество артефактов типа ```PackageDescriptor```, которые описывают собранные пакеты. Может быть использован для создания кондукторного тикета.
   1. ```name``` - имя пакета
   1. ```version``` - версия пакета

## ```projects/metrika/build_tarball_for_deploy```
### Описание
Выполняет сборку одного или нескольких tarball'ов на основе файлов ```package.json``` для последующго их релиза в Deploy.

Является фасадом Sandbox-задачи ```METRIKA_YA_PACKAGE```.

### Вход
1. ```sandbox``` - артефакт с параметрами, специфичными для Sandbox
   1. ```owner``` - владелец задачи
   1. ```yp_token_vault``` - наименование секрета в Sandbox-vault в котором содержится OAuth-токен для доступа к API YP, в формате ```'name'``` или ```'OWNER:name'```
1. ```packages``` - артефакт с перечнями пакетов для сборки и типами ресурсов, оба списка должны быть одинаковой длины.
   1. ```paths``` - список путей в аркадии до файлов ```package.json```
   1. ```resource_types``` - список типов ресурсов
1. ```release_mode``` - артефакт с режимом релиза
   1. ```release_per_resource``` - если ```true```, то на каждый собранный ресурс будет создан свой объект релиза, иначе будет создан один объект релиза со всеми собранными ресурсами.

### Выход
1. ```ya_package``` - артефакт типа ```YaPackage```, который описывает собранные тарболы. Может быть использован для последующего релиза в Deploy.
   1. ```task_id``` - идентификатор задачи, которая собрала тарболы.

## ```projects/metrika/build_tasklet_binary```
### Описание
Выполняет сборку указанного бинаря с тасклетами и загружает его в Sandbox.

Является фасадом Sandbox-задачи ```METRIKA_BUILD_TASKLET```

### Вход
1. ```sandbox``` - артефакт с параметрами, специфичными для Sandbox
   1. ```owner``` - владелец задачи
   1. ```login``` - логин пользователя ssh-ключ которого используется в задаче
   1. ```ssh_key``` - наименование секрета в Sandbox-vault в котором содержится ssh-ключ для логина выше, в формате ```'name'``` или ```'OWNER:name'```
1. ```tasklet``` - артефакт, в котором содержится путь к исходному коду тасклета, который нужно собрать.
   1. ```target``` - путь в Аркадии до проекта с тасклетом

### Выход
1. ```tasklet``` - артефакт типа ```TaskletBinary```, может быть использован для обновления реестра CI-тасклетов.
   1. ```resource_id``` -  идентификатор ресурса, созданный в результате загрузки собранного бинаря в Sandbox

## ```projects/metrika/create_conductor_ticket```
### Описание
Создаёт кондукторный тикет на основе ранее собранных Deb-пакетов.

### Вход
1. ```packages``` - список артефактов типа ```PackageDescriptor```, которые порождаются тасклетом ```projects/metrika/build_deb_package```
1. ```ticket``` - артефакт, в котором содержатся параметры создаваемого кондукторного тикета
   1. ```branch``` - ветка репозитория - одна из ```unstable```, ```testing```, ```prestable```, ```stable```, ```hotfix```, ```fallback```
   1. ```packages_to_remove``` - список строк - имена пакетов для удаления
   1. ```mailcc``` -  список строк - email-адреса для нотификаций
   1. ```skip_restart``` - если ```true```, то не перезапускать сервисы
   1. ```no_autoinstall``` - если ```true```, то не начинать автовыкладку
   1. ```projects``` -  список строк - наименования проектов
   1. ```comment``` - комментарий к тикету

### Выход
1. ```result``` - артефакт типа ```TicketDescriptor```, который может использоваься для ожидания завершения выкладки
   1. ```name``` - имя - идентификатор созданного кондукторного тикета

## ```projects/metrika/create_deploy_release```
### Описание
Выполняет релиз собранных тарболов в Deploy.

Является фасадом Sandbox-задачи ```METRIKA_YA_PACKAGE```.

По действию аналогично релизу Sandbox-задачи.

### Вход
1. ```ya_package``` - артефакт типа ```YaPackage```, который порождается тасклетом ```projects/metrika/build_tarball_for_deploy```
1. ```release``` - артефакт, описывающий релиз
   1. ```branch``` - ветка релиза - одно из ```unstable```, ```testing```, ```prestable```, ```stable```
   1. ```subject``` - краткое описание релиза
   1. ```message``` - более длинное описание релиза
1. ```commit_release_ticket``` - артефакт, описывающий нужно ли коммитить деплойные релизные тикеты
   1. ```force_commit``` - если ```true```, то созданные в результате релиза деплойные тикеты будут закоммичены принудительно.
Полезно, если не нужны дополнительные аппрувы в Деплое и не настроен автокоммит в релизных рулах.

### Выход
1. ```releases``` - артефакты типа ```DeployRelease```.
   1. ```release_id``` - идентификатор релиза в Деплой
   1. ```deploy_tickets``` - список созданных для данного релиза деплойных тикетов

## ```projects/metrika/update_ci_registry```
### Описание
Обновляет идентификатор stable-версии ресурса тасклета в ```ci/registry```.

Является фасадом Sandbox-задачи ```METRIKA_UPDATE_CI_REGISTRY```

### Вход
1. ```sandbox``` - артефакт с параметрами, специфичными для Sandbox
   1. ```owner``` - владелец задачи
   1. ```login``` - логин пользователя ssh-ключ которого используется в задаче
   1. ```ssh_key``` - наименование секрета в Sandbox-vault в котором содержится ssh-ключ для логина выше, в формате ```'name'``` или ```'OWNER:name'```
   1. ```arcanum_token``` - наименование секрета в Sandbox-vault в котором содержится oauth-токен для доступа к API Arcanum, в формате ```'name'``` или ```'OWNER:name'```
1. ```tasklet``` - артефакт типа ```TaskletBinary```, который порождается тасклетом ```projects/metrika/build_tasklet_binary```
1. ```registry``` - артефакт, описывающий CI-тасклеты у которых будет обновлен идентификатора stable-версии ресурса
   1. ```ci_tasklets``` -  список идентификаторов CI-тасклетов у которых будет обновлен идентификатора stable-версии ресурса. Идентификатором тасклета является путь до тасклета, без ```.yaml``` расширения и части пути ```ci/registry```.
1. ```wait``` - артефакт, описывающий ожидание коммита изменений в ```ci/registry```
   1. ```is_wait``` - ```true```, если нужно ждать коммита изменений в ```ci/registry```
   1. ```tick``` - начальный период проверки ревью, в секундах
   1. ```max_tick``` - максимальный период проверки ревью, в секундах
   1. ```max_wait``` - максимальное время ожидания мержа ревью, в секундах

### Выход
1. ```review```
   1. ```review_id```

## ```projects/metrika/wait_for_conductor_ticket```
### Описание
Ожидает указанный кондукторный тикет.

### Вход
1. ```ticket``` - артефакт типа ```TicketDescriptor```, который порождается тасклетом ```projects/metrika/create_conductor_ticket```
1. ```wait``` - артефакт, описывающий параметры ожидания
   1. ```positive_states``` - список состояний кондукторного тикета, при достижении которых считается, что ожидание завершено успешно.
   1. ```negative_states``` - список состояний кондукторного тикета, при достижении которых ожидание завершается провалом
   1. ```timeout``` - максимальное время ожидания, в формате ```google.protobuf.Duration```, например ```"600s""```
   1. ```poll_period``` - максимальное время ожидания, в формате ```google.protobuf.Duration```, например ```"10s""```

### Выход
1. ```result``` - артефакт типа ```ResultDescriptor``` описывающий результат ожидания
   1. ```result``` - ```true``` если кондукторный тикет перешёл в один из статусов, перечисленных в ```positive_states```, иначе - ```false```
   1. ```status``` - статус кондукторного тикета на момент завершения ожидания.


## ```projects/metrika/run_arcadia_tests```
### Описание
Выполняет прогон Аркадийных тестов с генерацией Allure-отчёта.

Является в некотором смысле гейтом - тасклет рапортует статус __FAILED__ если есть проваленные тесты.

Является фасадом Sandbox-задачи ```METRIKA_CORE_ARCADIA_TESTS_RUN```

### Вход
1. ```sandbox``` - артефакт с параметрами, специфичными для Sandbox
   1. ```owner``` - владелец задачи
1. ```tests``` - артефакт, описывающий список тестов
   1. ```targets``` - список путей в Аркадии - целей для запуска тестов

### Выход
1. ```result``` - артефакт типа ```Result``` описывающий результат ожидания
   1. ```is_success``` - ```true``` если проваленных тестов не было

## ```projects/metrika/build_binary_task```
### Описание
Выполняет сборку бинаря указанной Sandbox-задачи и релиз ресурса.

Является Sandbox-задачей ```METRIKA_BUILD_BINARY_TASK```

### Вход
1. ```arcadia_url``` - URL Аркадии для сборки
2. ```task_type``` - Имя типа собираемой Sandbox-задачи
3. ```release_branch``` - ветка для релиза - ```stable```/```testing```/```unstable```
4. ```test``` - запускать ли тестовый прогон собранной задачи (если таковое возможно)

## ```projects/metrika/tasks_list```
### Описание
Выполняет обновление списков Sandbox-задач в исходном коде

Является Sandbox-задачей ```METRIKA_TASKS_LIST```

### Вход
1. ```arcadia_url``` - URL Аркадии для сканирования
2. ```tasks_path``` - подкаталог, в котором осуществляется поиск Sandbox-задач
