USE hahn;
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

DECLARE $param_dict AS Dict<String, String>;

$base_dir = IF(
  $param_dict["branch"] = "prod",
  "//home/vipplanners/sow",
  "//home/vipplanners/sow_dev" || '/' || $param_dict["branch"]
);

-- input
$intersection = $base_dir || '/' || 'dict/intersection/latest';
$agency_bl = $base_dir || '/' || 'dict/agency_bl';

-- output
$result = $base_dir || '/' || 'dict/curr_client_spark_id/wscore_adj.v12';

$spam_crit_values = (
SELECT criterion, value
FROM $intersection
GROUP BY criterion, value
HAVING COUNT(DISTINCT client_id) > 1000
);

$spam_values = (
SELECT value
FROM $intersection
GROUP BY value
HAVING COUNT(DISTINCT client_id) > 1000
);

$client_stat = (
SELECT client_id, SUM(cost) AS cost_rub_wo_nds
FROM RANGE(`//home/comdep-cubes/direct/production/hypercubes/clients`, `2019-01-01`)
GROUP BY client_id
);

$spark_id_bl = (
SELECT *
FROM $agency_bl
WHERE counterparties_covered > 10
  AND main_okved2_name IN (
    "Деятельность рекламная",
    "Деятельность рекламных агентств"
    )
);

-- ручной маппинг точно правильных связей
$custom_curr_main_spark_id = (
SELECT client_id, SOME(spark_id) AS spark_id
FROM `//home/vipplanners/sow/dict/custom_curr_main_spark_id`
GROUP BY client_id
);

$fix_weight = ($x, $type) -> {
  RETURN
    CASE $type
      WHEN "email_vcard" THEN 0.9
      WHEN "email_balance_person" THEN 0.86
      WHEN "inn_balance" THEN 0.86
      WHEN "inn_sprav_company" THEN 0.86
      WHEN "inn_sprav_banner" THEN 0.86
      WHEN "ogrn_sprav_company" THEN 0.86
      WHEN "ogrn_sprav_banner" THEN 0.86
      WHEN "email_crm" THEN 0.85
      WHEN "email_balance" THEN 0.84
      WHEN "domain" THEN 0.83
      WHEN "phone_vcard" THEN 0.8
      WHEN "email_direct" THEN 0.78
      WHEN "phone_balance_person" THEN 0.75
      WHEN "phone_sprav" THEN 0.75
      WHEN "phone_crm" THEN 0.67
      WHEN "phone_balance" THEN 0.51
      WHEN "phone_direct" THEN 0.49
    ELSE $x
  END;
};

$wscore_adj = (
SELECT
  c.client_id AS client_id
, NVL(cp.spark_id, c.spark_id) AS spark_id
, s.cost_rub_wo_nds AS cost_rub_wo_nds
FROM (
  SELECT
    client_id
  , MAX_BY(spark_id, score) AS spark_id
  FROM (
    SELECT
      client_id
    , spark_id
    , SUM($fix_weight(score, i.criterion)) AS score
    FROM $intersection AS i
    LEFT ONLY JOIN $spark_id_bl AS sbl
      ON i.spark_id = sbl.spark_id
    JOIN `//home/comdep-analytics/public/client_tiers/fact/latest_v2` AS crm
      ON i.client_id = crm.client_id
    LEFT ONLY JOIN $spam_crit_values AS bl
      ON i.criterion = bl.criterion
     AND i.value = bl.value
    LEFT ONLY JOIN $spam_values AS blv
      ON i.value = blv.value
    WHERE nvl(crm.agency_id, 0) == 0
      OR (
            NOT (i.criterion ILIKE "%balance%")
        AND i.criterion != "inn_balance"
      )
    GROUP BY
      i.client_id AS client_id
    , i.spark_id AS spark_id
  )
  GROUP BY client_id
) AS c
LEFT JOIN $client_stat AS s
  ON c.client_id = s.client_id
LEFT JOIN $custom_curr_main_spark_id AS cp
  ON c.client_id = cp.client_id
);


$counterparty_main_spark_id = (
SELECT
  curr_counterparty_id
, MAX_BY(spark_id, cost_rub_wo_nds) AS spark_id
FROM (
  SELECT
    curr_counterparty_id
  , spark_id
  , SUM(ms.cost_rub_wo_nds) AS cost_rub_wo_nds
  FROM `//home/comdep-analytics/public/client_tiers/fact/latest_v2` AS crm
  JOIN $wscore_adj AS ms
    ON crm.client_id = ms.client_id
  GROUP BY
    crm.curr_counterparty_id AS curr_counterparty_id
  , ms.spark_id AS spark_id
)
GROUP BY curr_counterparty_id
);

INSERT INTO $result WITH TRUNCATE
SELECT
  crm.client_id AS client_id
, NVL(ms.spark_id, mcs.spark_id) AS spark_id
FROM `//home/comdep-analytics/public/client_tiers/fact/latest_v2` AS crm
LEFT JOIN $wscore_adj AS ms
  ON crm.client_id = ms.client_id
LEFT JOIN $counterparty_main_spark_id AS mcs
  ON crm.curr_counterparty_id = mcs.curr_counterparty_id
WHERE NVL(ms.spark_id, mcs.spark_id) > 0
  AND crm.client_id > 0
;
