PRAGMA yt.InferSchema = '1';
PRAGMA yt.PoolTrees             = "physical";
PRAGMA yt.DefaultOperationWeight = '100.0';
PRAGMA yt.TentativePoolTrees    = "cloud";
PRAGMA yt.OptimizeFor           = "scan";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yson.AutoConvert; 
PRAGMA yt.MaxJobCount = "100000";
PRAGMA SimpleColumns;

use hahn;

DECLARE $param_dict AS Dict<String, String>;

$base_dir = IF(
  $param_dict["branch"] = "prod",
  "//home/vipplanners/sow",
  "//home/vipplanners/sow_dev" || '/' || $param_dict["branch"]
);

-- input
-- схематизированные данные спарка
$spark_schematized = '//home/comdep-analytics/zedlaa/spark/all_2';

-- output
$output_path = $base_dir || '/' || 'money/latest';


$get_one_element = ($p_str_yson) ->
{
    $v_date_begin = NVL($p_str_yson.date_begin,"");
    $v_date_end = NVL($p_str_yson.date_end,"");
    $v_period_name = NVL($p_str_yson.period_name,"");
    RETURN ListMap($p_str_yson.string_list,($x) -> {return 
            AsDict(
        AsTuple("date_begin", $v_date_begin),
        AsTuple("date_end", $v_date_end),
        AsTuple("period_name", $v_period_name),
        AsTuple("name", NVL($x.name,"")),
        --AsTuple("name", '1'),
        AsTuple("value", NVL(CAST($x.value As String),""))
        --AsTuple("value", '1')
        )})
 
};

$get_finance = ($p_finance) ->
{
    RETURN ListMap($p_finance,($x) -> {return $get_one_element ($x)})
};


$tmp = 
(
Select spark_id
,      $get_finance(finance) As finance
from $spark_schematized As spark_all
);

$tmp1 = 
(
Select spark_id
,      finance_temp1
from $tmp
FLATTEN LIST BY finance As finance_temp1
);

$res = 
(
Select spark_id As spark_id
,      finance_temp2['date_begin'] As date_begin
,      finance_temp2['date_end'] As date_end
,      finance_temp2['period_name'] As period_name
,      finance_temp2['name'] As name
,      finance_temp2['value'] As value
from $tmp1
FLATTEN LIST BY finance_temp1 As finance_temp2
);

INSERT INTO $output_path WITH TRUNCATE 
select distinct spark_id
,      date_begin
,      date_end
,      period_name
,      name
,      value
from
    $res
;
