/* OPERANALYTICS-401
Возможные варианты прореживания:
- домен
- логин в Я
Директ:
- логины агентств
- логины субклиентов
- логины со статиской
- домены со статистикой
Партнеры РСЯ:
- логины партнеров с показами
- домены партнеров с показами
Антиспам:
- домены с порно
Первая помощь:
- домены с отказами
Модерация:
- домены c блокировками
Николай Дорофеев:
  - хосты, которые уже есть в Директе
Толя Канивецкий:
  - партнеры РСЯ, субклиенты, аккаунты агентств и их клиентов
Наиль Хаитов
  - хосты, которым было отказано в бесплатной настройке Директа
  - https://wiki.yandex-team.ru/contentprojects/Proekty/Direkt/Tablica-dlja-analitiki/
Михаил Костин
  - порно: https://yt.yandex-team.ru/hahn/navigation?path=//home/antispam/nasty/linear/porno_database&
Валентина Семенова
  - запрещенка: https://yandex.ru/support/direct/moderation/restricted-categories.html#restricted-categories
*/
USE hahn;
PRAGMA File('libcrypta_identifier_udf.so', 'yt://hahn/home/crypta/public/udfs/stable/libcrypta_identifier_udf.so');
PRAGMA Udf('libcrypta_identifier_udf.so');
/* ----------------------- */
-- Данные для прореживания --
/* ----------------------- */
$normalize_login = ($x) -> {
  RETURN String::Strip(String::ReplaceAll(String::ToLower($x), '-', '.'));
};
$normalize_domain = ($x) -> {
  RETURN Url::GetSignificantDomain(
    Url::PunycodeToHostName($x)
  )
};
-- Директ: логины агентств, субклиентов
$agency_login_bl = (
SELECT client_login
FROM `//home/comdep-analytics/public/client_tiers/fact/latest_v2`
WHERE agency_id > 0
  AND client_login > ''
GROUP BY $normalize_login(client_login) AS client_login
HAVING client_login > ''
);
-- Директ: логины с прошлой активностью
$old_login_bl = (
SELECT client_login
FROM `//home/yabs/dict/path_to_dict_order_info_table` AS o
JOIN `//home/direct/db/users` AS u
  ON o.ClientID = u.ClientID
WHERE o.Cost > 0
  AND o.EngineID = 7  -- Директ
  AND u.login > ''
GROUP BY $normalize_login(u.login) AS client_login
HAVING client_login > ''
);
$normalize_domain = ($x) -> {
-- https://yql.yandex-team.ru/docs/yt/udf/list/url/
-- возвращает домен второго уровня в большинстве случаев
  RETURN Url::GetSignificantDomain(
    Url::PunycodeToHostName($x)
  )
};
-- Директ: основные домены с прошлой активностью
-- OPERANALYTICS-982
$old_domain_bl_depricated = (
SELECT client_domain
FROM `//home/direct/export/balance/BillingOrderDomains`
WHERE ServiceID = 7  -- Директ
  AND Cost > 0
  AND Domain > ''
GROUP BY $normalize_domain(Domain) AS client_domain
HAVING client_domain > ''
);
$old_domain_bl_new = (
SELECT client_domain
FROM `//home/direct/export/balance/BillingOrderDomainsSplittedStat`
WHERE ServiceID = 7  -- Директ
  AND Cost > 0
  AND Domain > ''
GROUP BY $normalize_domain(Domain) AS client_domain
HAVING client_domain > ''
);
$old_domain_bl = (
SELECT DISTINCT client_domain
FROM (
  SELECT * FROM $old_domain_bl_depricated
  UNION ALL
  SELECT * FROM $old_domain_bl_new
));

-- Партнеры РСЯ
-- только страницы РСЯ с показами за любое время
$rsya_active_page_id = (
SELECT page_id
FROM `//home/comdep-analytics/YAN/stats/chevent_stats/all`
WHERE direct_ad_shows > 0
);
-- Партнеры РСЯ: логины
$rsya_partner_login_bl = (
SELECT partner_login
FROM `//home/comdep-analytics/YAN/cubes/yan_new/dicts/latest/pages` AS p
LEFT SEMI JOIN $rsya_active_page_id AS wl
  ON p.page_id == wl.page_id
WHERE p.partner_login > ''
  AND NOT p.is_page_app
  AND p.target_type == 3
GROUP BY $normalize_login(p.partner_login) AS partner_login
HAVING partner_login > ''
);
-- Партнеры РСЯ: домены
$rsya_partner_domain_bl = (
SELECT partner_domain
FROM `//home/comdep-analytics/YAN/cubes/yan_new/dicts/latest/pages` AS p
LEFT SEMI JOIN $rsya_active_page_id AS wl
  ON p.page_id == wl.page_id
WHERE p.domain_root > ''
  AND NOT p.is_page_app
  AND p.target_type == 3
GROUP BY $normalize_domain(p.domain_root) AS partner_domain
HAVING partner_domain > ''
);
-- Антиспам: домены с порно
$porno_domain_bl = (
SELECT porno_domain
FROM `//home/antispam/export/comdep/porno_hosts.pre`
WHERE Host > ''
GROUP BY $normalize_domain(Host) AS porno_domain
HAVING porno_domain > ''
);
-- Первая помощь: домены с отказами
$firsthelp_domain_bl = (
SELECT firsthelp_domain
FROM `//home/yacaredcat/MP/production/orders_data`
WHERE declined
  AND client_url_type == "site"
  AND decline_reason IN (
    "unsafe_site",
    "illegal",
    "moderation_blacklist",
    "agency_login",
  )
  AND client_url > ''
GROUP BY $normalize_domain(client_url) AS firsthelp_domain
HAVING firsthelp_domain > ''
);
-- Модерация: плохие домены
$moderate_domain_bl = (
SELECT moderate_domain
FROM `//home/modadvert/DomainWarnings`
WHERE type == "warning"
  AND domain > ''
GROUP BY $normalize_domain(domain) AS moderate_domain
HAVING moderate_domain > ''
);
/* ----------------------- */
-- Контакты из Вебмастера  --
/* ----------------------- */
-- Список email пользователей из ЕВРО
-- https://wiki.yandex-team.ru/users/p-shishkova/luchshaja-analitika-v-vebmastere/
$email_bl = (
    SELECT Identifiers::Email(email).Normalize
    FROM `//home/crypta/public/ids_storage/email/emails_eu`
);
-- Таблица кому можно отправить уведомления, но надо дополнительно прореживать.
-- Для этого:
-- 1. (по user_id, host_id) подтягивается валидный host_url
-- 2. Для host_url подсчитывается важное для фильтрации в
--    смежных сервисах: модерация, антиспам, директ
$email_user_host = (
SELECT
  contact_email
, ya_login
, user_id
, host_id
FROM `//home/webmaster/prod/user/user-notification-settings/user-notification-channel-settings`
WHERE channel_email
  AND notification_type = 'GLOBAL_NOTIFICATION'
  AND language = "RU"
  AND email IS NOT NULL
  AND email NOT IN $email_bl
GROUP BY
  email AS contact_email
, login AS ya_login
, user_id
, host_id
);
$wm_last_table = (
SELECT MAX(Path)
FROM FOLDER(`//home/webmaster/prod/export/archive/webmaster-verified-hosts`)
);
$wm_last_table = Unwrap('' || $wm_last_table);
$url_user_host = (
SELECT
  host_url
, user_id
, host_id
FROM $wm_last_table
WITH INFER_SCHEMA
GROUP BY
  host_url
, CAST(user_id AS Uint64) AS user_id
, host_id
);
INSERT INTO @wm_user_host_emails WITH TRUNCATE
SELECT
  normed_host
, wm_uid
, ya_login
, contact_email
FROM $url_user_host AS u
JOIN $email_user_host AS e
  ON u.user_id = e.user_id
 AND u.host_id = e.host_id
GROUP BY
  $normalize_domain(u.host_url) AS normed_host
, e.user_id AS wm_uid
, $normalize_login(e.ya_login) AS ya_login
, e.contact_email AS contact_email
; COMMIT;
/* ------------- */
-- Прореживание --
/* ------------- */
INSERT INTO `//home/vipplanners/share/webmaster/novice_contact` WITH TRUNCATE
SELECT
  normed_host
, wm_uid
, ya_login
, contact_email
FROM @wm_user_host_emails AS wm
-- логины субклиентов и агентств
LEFT ONLY JOIN $agency_login_bl AS a
  ON wm.ya_login = a.client_login
-- логины клиентов Директа
LEFT ONLY JOIN $old_login_bl AS ol
  ON wm.ya_login = ol.client_login
-- домены клиентов Директа
LEFT ONLY JOIN $old_domain_bl AS od
  ON wm.normed_host = od.client_domain
-- логины партнеров РСЯ
LEFT ONLY JOIN $rsya_partner_login_bl AS pl
  ON wm.ya_login = pl.partner_login
-- домены партнеров РСЯ
LEFT ONLY JOIN $rsya_partner_domain_bl AS pd
  ON wm.normed_host = pd.partner_domain
-- домены размеченные Антиспамом как порно
LEFT ONLY JOIN $porno_domain_bl AS prn
  ON wm.normed_host = prn.porno_domain
-- домены с отказом в Первой Помощи за нарушения
LEFT ONLY JOIN $firsthelp_domain_bl AS fhd
  ON wm.normed_host = fhd.firsthelp_domain
-- домены с нарушениями в Модерации
LEFT ONLY JOIN $moderate_domain_bl AS md
  ON wm.normed_host = md.moderate_domain
ORDER BY wm_uid
;