-- Отображение таблиц по маске
CREATE TABLE mediastat_v
(
 `has_coord`        Int8    DEFAULT -1,
 `timestamp`        UInt64  DEFAULT 0,
 `event_date`       MATERIALIZED toDate(`timestamp` / 1e6),
 `event_date_time`  ALIAS toDateTime(`timestamp` / 1e6),
 `userid`           UInt64  DEFAULT 0,
 `user_id_type`     Int8    DEFAULT -1,
 `yandexuid`        UInt64  DEFAULT 0,
 `adid`             Int32   DEFAULT -1,
 `placementid`      Int32   DEFAULT -1,
 `mime_type`        Int8    DEFAULT -1,
 `height`           Int16   DEFAULT -1,
 `width`            Int16   DEFAULT -1,
 `actionid`         Int16   DEFAULT -1,
 `geo_zone`         Int32   DEFAULT 10000,
 `rtb_request_id`   UInt64  DEFAULT 0,
 `dsp_price`        Int64   DEFAULT -1,
 `rtb_resource_id`  Int32   DEFAULT -1,
 `rtb_host_id`      Int16   DEFAULT -1,
 `sectionid`        Int32   DEFAULT -1,
 `lon`              Float64 DEFAULT nan,
 `lat`              Float64 DEFAULT nan,
 `rtb_stlm_price`   Int32   DEFAULT -1,
 `is_mobile`        Int8    DEFAULT -1,
 `is_tablet`        Int8    DEFAULT -1,
 `os_family`        String  DEFAULT '',
 `device_vendor`    String  DEFAULT '',
 `bandwidth`        Int32   DEFAULT -1,
 `user_regular_location_lat` Array(Float64) DEFAULT emptyArrayFloat64(),
 `user_regular_location_lon` Array(Float64) DEFAULT emptyArrayFloat64(),
 `user_search_cats`  Array(UInt32) DEFAULT emptyArrayUInt32(),
 `user_adhoc_prob`   Array(UInt32) DEFAULT emptyArrayUInt32(),
 `user_adhoc_strict` Array(UInt32) DEFAULT emptyArrayUInt32(),
 `user_goals`        Array(UInt32) DEFAULT emptyArrayUInt32(),
 `sd_gender`         Int8          DEFAULT -1,
 `sd_age`            Int8          DEFAULT -1,
 `sd_income`         Int8          DEFAULT -1
) ENGINE = Merge(default, '^[0-9]{4}(-[0-9][0-9]){2}$');
