# -*- coding: utf-8 -*-
from datetime import datetime
from datetime import timedelta
from os.path import basename
from templates import read_yml_config

DICTS = read_yml_config('dicts.yml')


def pretty_period_from_date(date, period_1, period_2, time_detail, short=True):
    if period_1['first_date'] <= date <= period_1['last_date']:
        return get_pretty_period(period_1['first_date'], period_1['last_date'], time_detail, short)

    elif period_2['first_date'] <= date <= period_2['last_date']:
        return get_pretty_period(period_2['first_date'], period_2['last_date'], time_detail, short)

    else:
        return None


def pretty_date_from_date(date, time_detail):
    if not isinstance(date, datetime):
        date = datetime.strptime(date, '%Y-%m-%d')

    return pretty_short_date(date, time_detail, for_charts=True)


def get_pretty_period(date_1, date_2, time_detail, short=False):
    if not isinstance(date_1, datetime):
        date_1 = datetime.strptime(date_1, '%Y-%m-%d')
    if not isinstance(date_2, datetime) and date_2 is not None:
        date_2 = datetime.strptime(date_2, '%Y-%m-%d')
    if date_2 is None:
        date_2 = date_1

    if time_detail == u'Недели':
        if date_1 == date_2:
            date_2 = date_1 + timedelta(days=6)
        else:
            date_2 = date_2 + timedelta(days=6)

    if short:
        date_1, date_2 = pretty_short_date(date_1, time_detail), pretty_short_date(date_2, time_detail)
    else:
        date_1, date_2 = pretty_footnote_date(date_1, time_detail), pretty_footnote_date(date_2, time_detail)

    if date_1 == date_2 or date_2 is None:
        return date_1

    else:
        if not short:
            date_2 = date_2.lower()
        return u'{} – {}'.format(date_1, date_2)


def pretty_footnote_date(date, time_detail):
    months = DICTS['months']['ru']

    day = date.day
    month = months[date.month]
    year = str(date.year)

    if time_detail in [u'Дни', u'Недели']:
        return u'{dd} {mmm}\'{yy}'.format(dd=day, mmm=month[:3].lower(), yy=year[2:])

    elif time_detail == u'Месяцы':
        return u'{Month} {year}'.format(Month=month, year=year)


def pretty_short_date(date, time_detail, for_charts=False):
    months = DICTS['months']['ru']

    day = date.day
    month = months[date.month]
    year = str(date.year)

    if for_charts:
        if time_detail in [u'Дни', u'Недели']:
            return u'{dd} {mmm}'.format(dd=day, mmm=month[:3].lower())
        elif time_detail == u'Месяцы':
            if date.month == 1:
                return year
            else:
                return month[:3]

    else:
        if time_detail in [u'Дни', u'Недели']:
            return u'{dd} {mmm}\'{yy}'.format(dd=day, mmm=month[:3].lower(), yy=year[2:])

        elif time_detail == u'Месяцы':
            return u'{Mmm}\'{yy}'.format(Mmm=month[:3], yy=year[2:])


def round_metric(value, lang='ru'):
    if value >= 10. ** 6:
        value = value / 10. ** 6
        cap = u'млн'
    elif value >= (10. ** 3) * 100:
        value = value / 10. ** 3
        cap = u'тыс.'
    else:
        cap = ''

    return value, cap


def get_pptx_name(some_result_path):
    name_parts = basename(some_result_path).replace('.xlsx', '').split('_')
    return u'{f_num}_{client}_{region}'.format(f_num=name_parts[0], client=name_parts[1], region=name_parts[2])
