# -*- coding: utf-8 -*-
from benchmarking import calculate_bench_table, calculate_comp_table, calculate_yoy_table
from grouped_tables import calculate_grouped_table
from utils import fill_client_comp_columns, fill_empty_df, fill_with_dashes


def retail_bench_tables(task, data_df, *opt):
    column, params = opt
    formula = params.get('formula')
    group_cols, cols = get_cols(column, formula)

    for col in task.filter_by.values():
        if col not in cols:
            cols.append(col)

    data_df = (data_df.loc[:, group_cols + cols].copy()
               .groupby(group_cols, as_index=False)
               .sum())
    data_df = fill_client_comp_columns(task.client, data_df, cols)

    tables = []
    for i, fn in enumerate([calculate_bench_table, calculate_comp_table, calculate_yoy_table], 1):
        df = fn(task, data_df.copy(), column, formula)

        descr = {}
        if i == 1:
            descr = {
                'position': {'row': 3, 'column': 1},
                'columns': [u'Date', u'PrettyDate', 'Client%s' % column, 'Comp%s' % column, u'CompMax', u'CompMin']}
        elif i == 2:
            descr = {
                'position': {'row': 2, 'column': 43},
                'columns': [u'Date', u'PrettyDate'] +
                           [col for col in df.columns if col not in [u'Date', u'PrettyDate']],
                'draw_column_names': True}
        elif i == 3:
            descr = {'position': {'row': 3, 'column': 8},
                     'columns': [u'Period', 'Client%s' % column, 'Comp%s' % column]}

        setattr(df, 'descr', descr)
        tables.append(df)

    return tables


def retail_place_device_tables(task, data_df, *opt, **kwargs):
    results = []

    group_by, device = kwargs.get('group_by'), kwargs.get('device')
    column, params = opt
    formula = params.get('formula')

    df = calculate_grouped_table(task, data_df, *opt, **kwargs)[0]
    columns = [group_by] + ['Client%s' % column, 'CompSum'] if formula is None else \
        [group_by] + ['Client%s' % column, 'Comp%s' % column]
    descr = {}
    if group_by == 'Place' and device is None:
        descr = {'position': {'row': 8, 'column': 12},
                 'columns': columns,
                 }
    elif group_by == 'Device':
        descr = {'position': {'row': 8, 'column': 16}, 'columns': columns}
    setattr(df, 'descr', descr)
    results.append(df)

    if column in ['CR', 'CPA']:
        notes_df = fill_with_dashes(task, df.copy(), column)
        descr = {}
        if group_by == 'Place' and device is None:
            descr = {'position': {'row': 10, 'column': 12},
                     'columns': columns,
                     }
        elif group_by == 'Device':
            descr = {'position': {'row': 10, 'column': 16}, 'columns': columns}
        setattr(notes_df, 'descr', descr)
        results.append(notes_df)

    return results


def categories_table(task, data_df, *opt):
    column, params = opt
    group_by = 'Category'

    df = calculate_grouped_table(task, data_df, *opt, group_by='Category')[0]

    if df.empty:
        df = fill_empty_df({
            group_by: [group_by], 'Client%s' % column: [0], 'Comp%s' % column: [0]
        })

    setattr(df, 'descr', {
        'position': {'row': 8, 'column': 8},
        'columns': [group_by, 'Client%s' % column, 'Comp%s' % column]
    })
    return [df]


def get_cols(column, formula):
    group_cols = ['Date', 'Client']
    cols = [formula['divinded'], formula['devider']] if formula else [column]

    return group_cols, cols
