# -*- coding: utf-8 -*-
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
import smtplib


def send_mail(from_, password, to, subject, message):
    msg = MIMEMultipart('alternative')
    text = MIMEText(message, 'html', 'utf8')

    msg['From'] = from_
    msg['To'] = ', '.join(to)
    msg['Subject'] = subject
    msg.attach(text)

    conn = smtplib.SMTP_SSL('smtp.yandex-team.ru', 465)
    conn.set_debuglevel(False)
    conn.login(from_, password)

    try:
        conn.sendmail(from_, to, msg.as_string())
    finally:
        conn.close()
