# -*- coding: utf-8 -*-
from os.path import join, dirname
import re
import yaml


PATTERN = re.compile(
    (r'\A####\n'
     r'task\n'
     r'####\n'
     r'####\n'
     r'(?P<params>.*?)\n'
     r'####\n'
     r'(?P<field>.*?)\n'
     r'####\n'
     r'(?P<competitors>.*?)\n'
     r'####\n'
     r'####.*\Z'),
    flags=re.DOTALL)


def read_yml_config(config_name):
    with open(join(dirname(__file__), config_name)) as fd:
        return yaml.load(fd)
