# -*- coding: utf-8 -*-
from distutils.core import setup
from os.path import join, dirname
import pickle
import py2exe
import sys
from textwrap import dedent

sys.setrecursionlimit(5000)


# Make resources.py
data_files = [
    # resource_name
    ('config', join(dirname(__file__), 'report_maker', 'report_config.yml')),
    ('template', join(dirname(__file__), 'templates', 'ARIAL_ZA_ru+en_v25.0_22April25.xlsx')),
]


with open('resources.py', 'w') as fd:
    fd.write(dedent('import pickle\n'))
    for name, path in data_files:
        with open(path, 'rb') as src:
            fd.write('%s = pickle.loads(r"""%s""")\n' % (name, pickle.dumps(src.read())))

setup(
    console=[{'script': 'main.py'}],
    options={
        'py2exe': {
            'includes': ['exceller', 'lxml', 'lxml.etree', 'lxml._elementpath', 'const', 'report_maker', 'resources'],
            'excludes': ['json', 'unittest'],
            'bundle_files': 1,
            'compressed': True
        }
    },
    zipfile=None
)
