-- OPERANALYTICS-834
PRAGMA AnsiInForEmptyOrNullableItemsCollections;

USE hahn;

DEFINE SUBQUERY $sum_event($dir) AS
SELECT
  eventdate
, pageid
, impid
, orderid
, SUM(cost_rub_wo_nds) AS cost_rub_wo_nds
FROM RANGE($dir)
GROUP BY
  eventdate
, pageid
, impid
, orderid
;
END DEFINE;

$navig_pages = (
  472668, 472667, 593113, 593111,  -- Навигатор Native pages
  588231, 588230, 591292, 591289   -- Навигатор YAN pages
);
-- https://wiki.yandex-team.ru/users/ntumasheva/medijjka-navi/
$classify_product = ($page, $block) -> {
  RETURN CASE 
    WHEN $page IN (355417, 355501) THEN "Метро"
    -- 
    WHEN $page = 472668 AND $block = 1 THEN "Навигатор (прямые)"
    WHEN $page = 472667 AND $block = 2 THEN "Навигатор (прямые)"
    WHEN $page = 593113 AND $block = 1 THEN "Навигатор (прямые)"
    WHEN $page = 593111 AND $block = 1 THEN "Навигатор (прямые)"
    WHEN $page = 472668 AND $block = 7 THEN "Навигатор (прямые)"
    WHEN $page = 472667 AND $block = 8 THEN "Навигатор (прямые)"
    WHEN $page = 593113 AND $block = 3 THEN "Навигатор (прямые)"
    WHEN $page = 593111 AND $block = 3 THEN "Навигатор (прямые)"
    -- 
    WHEN $page = 588231 AND $block = 1 THEN "Навигатор (рся)"
    WHEN $page = 588230 AND $block = 1 THEN "Навигатор (рся)"
    WHEN $page = 591292 AND $block = 1 THEN "Навигатор (рся)"
    WHEN $page = 591289 AND $block = 1 THEN "Навигатор (рся)"
    WHEN $page = 472668 AND $block = 3 THEN "Навигатор (рся)"
    WHEN $page = 472667 AND $block = 4 THEN "Навигатор (рся)"
    WHEN $page = 472667 AND $block = 4 THEN "Навигатор (рся)"
    WHEN $page = 588231 AND $block = 5 THEN "Навигатор (рся)"
    WHEN $page = 588230 AND $block = 3 THEN "Навигатор (рся)"
    WHEN $page = 591292 AND $block = 5 THEN "Навигатор (рся)"
    WHEN $page = 591289 AND $block = 5 THEN "Навигатор (рся)"
    WHEN $page = 588231 AND $block = 2 THEN "Навигатор (рся)"
    WHEN $page = 588230 AND $block = 2 THEN "Навигатор (рся)"
    WHEN $page = 591292 AND $block = 3 THEN "Навигатор (рся)"
    WHEN $page = 588231 AND $block = 4 THEN "Навигатор (рся)"
    WHEN $page = 588231 AND $block = 4 THEN "Навигатор (рся)"
    WHEN $page = 588230 AND $block = 4 THEN "Навигатор (рся)"
    WHEN $page = 591292 AND $block = 7 THEN "Навигатор (рся)"
    WHEN $page = 588230 AND $block = 6 THEN "Навигатор (рся)"
    WHEN $page = 588231 AND $block = 6 THEN "Навигатор (рся)"
    -- 
    WHEN $page IN $navig_pages THEN "Навигатор (прочее)"
    ELSE "Прочее"
  END;
};

$orderinfo = (
SELECT OrderID, ExportID
FROM `//home/yabs/dict/CaesarOrderInfo`
WHERE OrderType == 1  -- commercial
  AND EngineID = 7  -- Директ
);

$balance_order_info = (
SELECT
  oi.OrderID AS order_id
, bo.service_order_id AS service_order_id
, bo.client_id AS client_id
, bo.agency_id AS agency_id
, nvl(c.name, '') AS client_name
, nvl(a.name, '') AS agency_name
FROM `//home/balance/prod/bo/t_order` AS bo
JOIN $orderinfo AS oi
  ON bo.service_order_id = oi.ExportID
LEFT JOIN `//home/balance/prod/bo/t_client` AS c
  ON bo.client_id = c.id
LEFT JOIN `//home/balance/prod/bo/t_client` AS a
  ON bo.agency_id = a.id
WHERE bo.service_id = 7  -- Директ
);

$product_stat = (
SELECT
  campaign_id
, event_date
, product_name
, SOME(oi.client_id) AS client_id
, nvl(SOME(oi.agency_id), 0) AS agency_id
, SOME(oi.order_id) AS order_id
, nvl(SOME(oi.agency_name), '') AS agency_name
, SOME(oi.client_name) AS client_name
, SUM(ps.cost_rub_wo_nds) AS cost_rub_wo_nds
FROM (
  SELECT * FROM $sum_event("//home/vipplanners/dashboard_geoproducts_clients/daily/chevent") UNION ALL
  SELECT * FROM $sum_event("//home/vipplanners/dashboard_geoproducts_clients/daily/action")
) AS ps
JOIN $balance_order_info AS oi
  ON ps.orderid = oi.order_id
GROUP BY
  oi.service_order_id AS campaign_id
, ps.eventdate AS event_date
, $classify_product(ps.pageid, ps.impid) AS product_name
);


INSERT INTO `//home/vipplanners/dashboard_geoproducts_clients/cube/cid_product_day_stat` WITH TRUNCATE
SELECT
  ps.*
, lc.contract_eid AS contract_eid
FROM $product_stat AS ps
LEFT JOIN `//home/vipplanners/dict/balance/cid_last_contract` AS lc
  ON ps.campaign_id = lc.cid
ORDER BY
  campaign_id
, event_date
, product_name
;
