USE hahn;
PRAGMA yt.ParallelOperationsLimit = "7";  -- дефолтный лимит на пользователя 10
PRAGMA yt.DefaultOperationWeight = "0.5"; -- дефолт 1.0
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";

$SRC_PATH = "//home/vipplanners/dashboard_strategy_balance/daily/order_strategy_log";

INSERT INTO `//home/vipplanners/dashboard_strategy_balance/daily/client_strategy_changes` WITH TRUNCATE
SELECT
-- автобюджетные стратегии
  client_id
, cube_date
, COUNT_IF(
  NVL(campaign_is_auto_strategy_prev, False)
  AND NOT NVL(campaign_is_auto_strategy, False)
  AND NOT NVL(campaign_is_status_archived, False)
  ) AS order_stop_autostrategy
, COUNT_IF(
  NOT NVL(campaign_is_auto_strategy_prev, False)
  AND NVL(campaign_is_auto_strategy, False)
  AND NOT NVL(campaign_is_status_archived, False)) AS order_start_autostrategy
-- оплата за конверсии
, COUNT_IF(
  NVL(campaign_pay_for_conversion_prev, False)
  AND NOT NVL(campaign_pay_for_conversion, False)
  AND NOT NVL(campaign_is_status_archived, False)
  ) AS order_stop_pay_for_conversion
, COUNT_IF(
  NOT NVL(campaign_pay_for_conversion_prev, False)
  AND NVL(campaign_pay_for_conversion, False)
  AND NOT NVL(campaign_is_status_archived, False)) AS order_start_pay_for_conversion
-- атрибуты для фильтрации на дашборде
, SOME(client_age_days) AS client_age_days
, SOME(curr_client_tier) AS curr_client_tier
, SOME(client_type) AS client_type
, SOME(client_first_day) AS client_first_day
, SOME(curr_industry) AS curr_industry
-- опции на клиенте
, SOME(has_pro_strategy_use) AS has_pro_strategy_use
, SOME(has_simplified_strategy_use) AS has_simplified_strategy_use  -- дефолт True
, SOME(is_pro_strategy_view_enabled) AS is_pro_strategy_view_enabled
FROM $SRC_PATH
GROUP BY
  client_id
, cube_date
ORDER BY
  client_id
, cube_date
;
