USE hahn;
PRAGMA yt.ParallelOperationsLimit = "7";  -- дефолтный лимит на пользователя 10
PRAGMA yt.DefaultOperationWeight = "0.5"; -- дефолт 1.0
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";
PRAGMA AnsiInForEmptyOrNullableItemsCollections;


$client_campaign_strategy_usage = (
SELECT
  client_id
, MAX(ListHas(ListMap(String::SplitToList(opts, ','), String::Strip), "is_simplified_strategy_view_enabled")) AS has_simplified_strategy_use
, NOT MIN(ListHas(ListMap(String::SplitToList(opts, ','), String::Strip), "is_simplified_strategy_view_enabled")) AS has_pro_strategy_use
FROM `//home/direct/db/campaigns`
WHERE ClientID > 0
GROUP BY ClientID AS client_id
);

$client_default_strategy_view = (
SELECT
  ClientID AS client_id
, ListHas(ListMap(String::SplitToList(client_flags, ','), String::Strip), "is_pro_strategy_view_enabled") AS is_pro_strategy_view_enabled
FROM `//home/direct/db/clients`
WHERE ClientID > 0
);

$client_stat = (
SELECT
  c.*
-- атрибуты для фильтрации на дашборде
, NVL(crm.curr_counterparty_reporting_tier.name, "unkown") AS curr_client_tier
, NVL(crm.client_type, "unkown") AS client_type
, NVL(crm.client_first_date, "1970-01-01") AS client_first_day
, NVL(crm.curr_counterparty_industry.industry, "unkown") AS curr_industry
-- опции на клиенте
, NVL(cu.has_pro_strategy_use, False) AS has_pro_strategy_use
, NVL(cu.has_simplified_strategy_use, False) AS has_simplified_strategy_use
, NVL(cv.is_pro_strategy_view_enabled, False) AS is_pro_strategy_view_enabled
FROM (
  SELECT
    client_id
  , CAST(cube_date AS Date) AS cube_date
  , NVL(SUM(autobudget_orders), 0) > 0 AS has_autobudget_orders
  , NVL(SUM(cpa_strategy_orders), 0) > 0 AS has_cpa_strategy_orders
  , NVL(SUM(shows), 0) AS shows
  FROM RANGE(`//statbox/cube/daily/comdep/hypercubes/v1/clients`)
  WHERE client_id > 0
  GROUP BY
    client_id
  , cube_date
  HAVING SUM(shows) > 0
) AS c
LEFT JOIN `//home/comdep-analytics/public/client_tiers/fact/latest_v2` AS crm
  ON c.client_id = crm.client_id
LEFT JOIN $client_campaign_strategy_usage AS cu
  ON c.client_id = cu.client_id
LEFT JOIN $client_default_strategy_view AS cv
  ON c.client_id = cv.client_id
);

-- Первый день с автостратегией
$autobudget_start_date = (
SELECT 
  client_id
, MIN(cube_date) AS autobudget_start_date
FROM $client_stat
WHERE client_id > 0
  AND has_autobudget_orders
GROUP BY client_id
);

-- Первый день с конверсионной автостратегией
$cpa_strategy_start_date = (
SELECT 
  client_id
, MIN(cube_date) AS cpa_strategy_start_date
FROM $client_stat
WHERE client_id > 0
  AND has_cpa_strategy_orders
GROUP BY client_id
);

$client_autobudget_log = (
SELECT
  cs.client_id AS client_id
, cs.cube_date AS cube_date
, cs.has_autobudget_orders AS has_autobudget_orders
, cs.shows AS shows
, ab.autobudget_start_date AS autobudget_start_date
, DateTime::ToDays(cs.cube_date - ab.autobudget_start_date) AS autobudget_age_days
-- атрибуты для фильтрации
, cs.curr_client_tier AS curr_client_tier
, cs.client_type AS client_type
, cs.client_first_day AS client_first_day
, cs.curr_industry AS curr_industry
-- опции на клиенте
, cs.has_pro_strategy_use AS has_pro_strategy_use
, cs.has_simplified_strategy_use AS has_simplified_strategy_use
, cs.is_pro_strategy_view_enabled AS is_pro_strategy_view_enabled
FROM $client_stat AS cs
LEFT JOIN $autobudget_start_date AS ab
  ON cs.client_id = ab.client_id
WHERE cs.cube_date >= ab.autobudget_start_date
);

$client_cpa_strategy_log = (
SELECT
  cs.client_id AS client_id
, cs.cube_date AS cube_date
, cs.has_cpa_strategy_orders AS has_cpa_strategy_orders
, cs.shows AS shows
, ab.cpa_strategy_start_date AS cpa_strategy_start_date
, DateTime::ToDays(cs.cube_date - ab.cpa_strategy_start_date) AS cpa_strategy_age_days
-- атирбуты для фильтрации
, cs.curr_client_tier AS curr_client_tier
, cs.client_type AS client_type
, cs.client_first_day AS client_first_day
, cs.curr_industry AS curr_industry
-- опции на клиенте
, cs.has_pro_strategy_use AS has_pro_strategy_use
, cs.has_simplified_strategy_use AS has_simplified_strategy_use
, cs.is_pro_strategy_view_enabled AS is_pro_strategy_view_enabled
FROM $client_stat AS cs
LEFT JOIN $cpa_strategy_start_date AS ab
  ON cs.client_id = ab.client_id
WHERE cs.cube_date >= ab.cpa_strategy_start_date
);


$full_week_autobudget = (
SELECT cube_week_date
FROM $client_autobudget_log
GROUP BY DateTime::MakeDate(DateTime::StartOfWeek(cube_date)) AS cube_week_date
HAVING COUNT(DISTINCT cube_date) = 7
);

INSERT INTO `//home/vipplanners/dashboard_strategy_balance/cohort/autobudget_log` WITH TRUNCATE
SELECT
  client_id
, cube_date
, has_autobudget_orders
, autobudget_age_days / 7 AS stat_week
, DateTime::MakeDate(DateTime::StartOfWeek(autobudget_start_date)) AS autobudget_start_week
-- атрибуты для фильтрации
, curr_client_tier
, client_type
, client_first_day
, curr_industry
-- опции на клиенте
, has_pro_strategy_use
, has_simplified_strategy_use
, is_pro_strategy_view_enabled
FROM $client_autobudget_log
WHERE autobudget_start_date >= Date("2019-01-01")
  AND DateTime::MakeDate(DateTime::StartOfWeek(cube_date)) IN COMPACT $full_week_autobudget
ORDER BY
  client_id
, cube_date
;

$full_week_cpa = (
SELECT cube_week_date
FROM $client_cpa_strategy_log
GROUP BY DateTime::MakeDate(DateTime::StartOfWeek(cube_date)) AS cube_week_date
HAVING COUNT(DISTINCT cube_date) = 7
);

INSERT INTO `//home/vipplanners/dashboard_strategy_balance/cohort/cpa_strategy_log` WITH TRUNCATE
SELECT
  client_id
, cube_date
, has_cpa_strategy_orders
, cpa_strategy_age_days / 7 AS stat_week
, DateTime::MakeDate(DateTime::StartOfWeek(cpa_strategy_start_date)) AS cpa_strategy_start_week
-- атрибуты для фильтрации
, curr_client_tier
, client_type
, client_first_day
, curr_industry
-- опции на клиенте
, has_pro_strategy_use
, has_simplified_strategy_use
, is_pro_strategy_view_enabled
FROM $client_cpa_strategy_log
WHERE cpa_strategy_start_date >= Date("2019-01-01")
  AND DateTime::MakeDate(DateTime::StartOfWeek(cube_date)) IN COMPACT $full_week_cpa
ORDER BY
  client_id
, cube_date
;
