-- OPERANALYTICS-1168
-- баланс притока по стратегиям
PRAGMA yt.ParallelOperationsLimit = "7";  -- дефолтный лимит на пользователя 10
PRAGMA yt.DefaultOperationWeight = "0.5"; -- дефолт 1.0
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.TentativePoolTrees = "cloud";
USE hahn;

-- кампании по дням
$SRC_PATH = "//home/vipplanners/dashboard_strategy_balance/daily/order_strategy_log";

DEFINE SUBQUERY $week_stat($begin, $finish) AS
SELECT
  campaign_strategy_name
, campaign_strategy_name_prev
, campaign_pay_for_conversion
, campaign_pay_for_conversion_prev
, curr_client_tier
, COUNT(*) AS order_strategy_changes
FROM $SRC_PATH AS s
JOIN `//home/comdep-analytics/public/client_tiers/fact/latest_v2` AS crm
  ON s.client_id = crm.client_id
WHERE s.cube_date BETWEEN $begin AND $finish
  AND (s.campaign_strategy_name != s.campaign_strategy_name_prev
    OR s.campaign_pay_for_conversion != s.campaign_pay_for_conversion_prev
    )
GROUP BY
  s.campaign_strategy_name AS campaign_strategy_name
, s.campaign_strategy_name_prev AS campaign_strategy_name_prev
, s.campaign_pay_for_conversion AS campaign_pay_for_conversion
, s.campaign_pay_for_conversion_prev AS campaign_pay_for_conversion_prev
, crm.curr_counterparty_reporting_tier.name AS curr_client_tier
END DEFINE;

-- даты для статистики по двум непересекающимся неделям
$last_date_w1 = (SELECT MAX(cube_date) FROM $SRC_PATH);
$start_date_w1 = CAST(CAST($last_date_w1 AS Date) - Interval("P6D") AS String);
$last_date_w2 = CAST(CAST($last_date_w1 AS Date) - Interval("P7D") AS String);
$start_date_w2 = CAST(CAST($last_date_w1 AS Date) - Interval("P13D") AS String);

INSERT INTO @strategy_change_top_7d WITH TRUNCATE
SELECT
  NVL(
    curr.campaign_strategy_name,
    ref.campaign_strategy_name,
    curr_rev.campaign_strategy_name_prev,
    ref_rev.campaign_strategy_name_prev,
  ) AS strategy_target
, NVL(
    curr.campaign_strategy_name_prev,
    ref.campaign_strategy_name_prev,
    curr_rev.campaign_strategy_name,
    ref_rev.campaign_strategy_name,
  ) AS strategy_source
, NVL(
    curr.campaign_pay_for_conversion,
    ref.campaign_pay_for_conversion,
    curr_rev.campaign_pay_for_conversion_prev,
    ref_rev.campaign_pay_for_conversion_prev,
  ) AS pay_target
, NVL(
    curr.campaign_pay_for_conversion_prev,
    ref.campaign_pay_for_conversion_prev,
    curr_rev.campaign_pay_for_conversion,
    ref_rev.campaign_pay_for_conversion,
  ) AS pay_source
, NVL(
    curr.curr_client_tier,
    ref.curr_client_tier,
    curr_rev.curr_client_tier,
    ref_rev.curr_client_tier,
  ) AS curr_client_tier
, NVL(curr.order_strategy_changes, 0) AS order_strategy_changes_curr_week
, NVL(curr_rev.order_strategy_changes, 0) AS order_strategy_changes_back
, NVL(ref.order_strategy_changes, 0) AS order_strategy_changes_past_week
, NVL(ref_rev.order_strategy_changes, 0) AS order_strategy_changes_back_past_week
FROM $week_stat($start_date_w1, $last_date_w1) AS curr
FULL JOIN $week_stat($start_date_w2, $last_date_w2) AS ref
   ON curr.campaign_strategy_name = ref.campaign_strategy_name
  AND curr.campaign_strategy_name_prev = ref.campaign_strategy_name_prev
  AND curr.campaign_pay_for_conversion = ref.campaign_pay_for_conversion
  AND curr.campaign_pay_for_conversion_prev = ref.campaign_pay_for_conversion_prev
  AND curr.curr_client_tier = ref.curr_client_tier
FULL JOIN $week_stat($start_date_w1, $last_date_w1) AS curr_rev
   ON curr.campaign_strategy_name = curr_rev.campaign_strategy_name_prev
  AND curr.campaign_strategy_name_prev = curr_rev.campaign_strategy_name
  AND curr.campaign_pay_for_conversion = curr_rev.campaign_pay_for_conversion_prev
  AND curr.campaign_pay_for_conversion_prev = curr_rev.campaign_pay_for_conversion
  AND curr.curr_client_tier = curr_rev.curr_client_tier
FULL JOIN $week_stat($start_date_w2, $last_date_w2) AS ref_rev
   ON ref.campaign_strategy_name = ref_rev.campaign_strategy_name_prev
  AND ref.campaign_strategy_name_prev = ref_rev.campaign_strategy_name
  AND ref.campaign_pay_for_conversion = ref_rev.campaign_pay_for_conversion_prev
  AND ref.campaign_pay_for_conversion_prev = ref_rev.campaign_pay_for_conversion
  AND ref.curr_client_tier = ref_rev.curr_client_tier
;

$start_date_14d_1 = CAST(CAST($last_date_w1 AS Date) - Interval("P13D") AS String);
$last_date_14d_1 = CAST(CAST($last_date_w1 AS Date) - Interval("P14D") AS String);
$start_date_14d_2 = CAST(CAST($last_date_w1 AS Date) - Interval("P27D") AS String);

INSERT INTO @strategy_change_top_14d WITH TRUNCATE
SELECT
  NVL(
    curr.campaign_strategy_name,
    ref.campaign_strategy_name,
    curr_rev.campaign_strategy_name_prev,
    ref_rev.campaign_strategy_name_prev,
  ) AS strategy_target
, NVL(
    curr.campaign_strategy_name_prev,
    ref.campaign_strategy_name_prev,
    curr_rev.campaign_strategy_name,
    ref_rev.campaign_strategy_name,
  ) AS strategy_source
, NVL(
    curr.campaign_pay_for_conversion,
    ref.campaign_pay_for_conversion,
    curr_rev.campaign_pay_for_conversion_prev,
    ref_rev.campaign_pay_for_conversion_prev,
  ) AS pay_target
, NVL(
    curr.campaign_pay_for_conversion_prev,
    ref.campaign_pay_for_conversion_prev,
    curr_rev.campaign_pay_for_conversion,
    ref_rev.campaign_pay_for_conversion,
  ) AS pay_source
, NVL(
    curr.curr_client_tier,
    ref.curr_client_tier,
    curr_rev.curr_client_tier,
    ref_rev.curr_client_tier,
  ) AS curr_client_tier
, NVL(curr.order_strategy_changes, 0) AS order_strategy_changes_curr_week
, NVL(curr_rev.order_strategy_changes, 0) AS order_strategy_changes_back
, NVL(ref.order_strategy_changes, 0) AS order_strategy_changes_past_week
, NVL(ref_rev.order_strategy_changes, 0) AS order_strategy_changes_back_past_week
FROM $week_stat($start_date_14d_1, $last_date_w1) AS curr
FULL JOIN $week_stat($start_date_14d_2, $last_date_14d_1) AS ref
   ON curr.campaign_strategy_name = ref.campaign_strategy_name
  AND curr.campaign_strategy_name_prev = ref.campaign_strategy_name_prev
  AND curr.campaign_pay_for_conversion = ref.campaign_pay_for_conversion
  AND curr.campaign_pay_for_conversion_prev = ref.campaign_pay_for_conversion_prev
  AND curr.curr_client_tier = ref.curr_client_tier
FULL JOIN $week_stat($start_date_14d_1, $last_date_w1) AS curr_rev
   ON curr.campaign_strategy_name = curr_rev.campaign_strategy_name_prev
  AND curr.campaign_strategy_name_prev = curr_rev.campaign_strategy_name
  AND curr.campaign_pay_for_conversion = curr_rev.campaign_pay_for_conversion_prev
  AND curr.campaign_pay_for_conversion_prev = curr_rev.campaign_pay_for_conversion
  AND curr.curr_client_tier = curr_rev.curr_client_tier
FULL JOIN $week_stat($start_date_14d_2, $last_date_14d_1) AS ref_rev
   ON ref.campaign_strategy_name = ref_rev.campaign_strategy_name_prev
  AND ref.campaign_strategy_name_prev = ref_rev.campaign_strategy_name
  AND ref.campaign_pay_for_conversion = ref_rev.campaign_pay_for_conversion_prev
  AND ref.campaign_pay_for_conversion_prev = ref_rev.campaign_pay_for_conversion
  AND ref.curr_client_tier = ref_rev.curr_client_tier
;
COMMIT;

INSERT INTO `//home/vipplanners/dashboard_strategy_balance/top/strategy_pay_change_top_7d` WITH TRUNCATE
SELECT
  curr_client_tier
, strategy_source
, pay_source
, strategy_target
, pay_target
, order_strategy_changes_curr_week AS ch_curr_week
, order_strategy_changes_back AS ch_curr_week_reverse
, CAST(order_strategy_changes_curr_week AS Int64) - CAST(order_strategy_changes_back AS Int64) AS curr_balance
, CAST(order_strategy_changes_past_week AS Int64) - CAST(order_strategy_changes_back_past_week AS Int64) AS ref_balance
FROM @strategy_change_top_7d
ORDER BY curr_client_tier, strategy_source, pay_source, curr_balance DESC
INTO RESULT top_changes_7d;

INSERT INTO `//home/vipplanners/dashboard_strategy_balance/top/strategy_pay_change_top_14d` WITH TRUNCATE
SELECT
  curr_client_tier
, strategy_source
, pay_source
, strategy_target
, pay_target
, order_strategy_changes_curr_week AS ch_curr_week
, order_strategy_changes_back AS ch_curr_week_reverse
, CAST(order_strategy_changes_curr_week AS Int64) - CAST(order_strategy_changes_back AS Int64) AS curr_balance
, CAST(order_strategy_changes_past_week AS Int64) - CAST(order_strategy_changes_back_past_week AS Int64) AS ref_balance
FROM @strategy_change_top_14d
ORDER BY curr_client_tier, strategy_source, pay_source, curr_balance DESC
INTO RESULT top_changes_14d;
;