/* Таблица с динамикой показателей по частным специалистам

Тикет: OKK-2934
*/
USE hahn;

$YT_SPECIALIST_DATA_FOLDER = "home/vipplanners/freelance_info/specialist";
-- Готовая статистика в разбивке по частным специалистам
$YT_SPEC_HISTORY_PATH = "home/vipplanners/freelance_info/export/specialist_history";
$YT_SPEC_LAST_PATH = "home/vipplanners/freelance_info/export/specialist_last";
-- Готовая статистика по сервису
$YT_TOTAL_HISTORY_PATH = "home/vipplanners/freelance_info/export/total_history";

$LAST_DATE = (
SELECT MAX(Cast(TableName(Path) AS Date))
FROM FOLDER($YT_SPECIALIST_DATA_FOLDER)
WHERE Type == "table"
);
-- граница выбрана "экспертно", можно менять
$FIRST_DATE = $LAST_DATE - Interval("P400DT");

$is_good_period = ($table_name) -> {
  $date = CAST($table_name AS Date);
  RETURN ($date BETWEEN EvaluateExpr($FIRST_DATE) AND EvaluateExpr($LAST_DATE)) ?? false;
};


$MERGED_DATA = (
SELECT 
  FLClientID
, FLName
, Cast(TableName(TablePath()) AS Date) AS Date
, QAShows
, QAClicks
, QAClientCostUnit
, QAClientCount
, BSFLRank
, QAPrGoodShowsRank
, QAPrGoodShowsShare
, BSFLScore
FROM FILTER($YT_SPECIALIST_DATA_FOLDER, $is_good_period)
);

-- Таблица со всеми специалистами для всех учтенных дат
$ALL_FL = (SELECT DISTINCT FLClientID, FLName FROM $MERGED_DATA);
$ALL_DATE = (SELECT DISTINCT Date FROM $MERGED_DATA);
$ALL_FL_DATE = (
SELECT
  f.FLClientID AS FLClientID
, f.FLName AS FLName
, d.Date AS Date
FROM $ALL_FL AS f
CROSS JOIN $ALL_DATE AS d
);

$SPEC_HISTORY = (
SELECT 
  k.FLClientID AS FLClientID
, k.FLName AS FLName
, k.Date AS Date
, d.QAShows AS QAShows
, d.QAClicks AS QAClicks
, d.QAClientCostUnit AS QAClientCostUnit
, d.QAClientCount AS QAClientCount
, d.BSFLRank AS BSFLRank
, d.BSFLScore AS BSFLScore
, d.QAPrGoodShowsRank AS QAPrGoodShowsRank
, d.QAPrGoodShowsShare AS QAPrGoodShowsShare
FROM $ALL_FL_DATE AS k
LEFT JOIN $MERGED_DATA AS d
  USING (FLClientID, Date)
);
-- Export
INSERT INTO $YT_SPEC_HISTORY_PATH WITH TRUNCATE 
SELECT 
  FLClientID
, FLName
, Date
, QAShows
, QAClicks
, QAClientCostUnit
, QAClientCount
, BSFLRank
, BSFLScore
, QAPrGoodShowsRank
, QAPrGoodShowsShare
FROM $SPEC_HISTORY
ORDER BY FLClientID, Date
;

$TOTAL_HISTORY = (
SELECT 
  Date
, SUM(QAShows) AS QAShows
, SUM(QAClicks) AS QAClicks
, SUM(QAClientCostUnit) AS QAClientCostUnit
, MAX(BSFLRank) AS BSSpecCount
, SUM(BSFLScore * QAShows) / SUM(QAShows) AS BSFLScore
, MAX(QAPrGoodShowsRank) AS QASpecCount
, SUM(QAPrGoodShowsShare * QAShows) / SUM(QAShows) AS QAPrGoodShowsShare
FROM $SPEC_HISTORY
GROUP BY Date
);

INSERT INTO $YT_TOTAL_HISTORY_PATH WITH TRUNCATE 
SELECT
  Date
, QAShows
, QAClicks
, QAClientCostUnit
, BSSpecCount
, BSFLScore
, QASpecCount
, QAPrGoodShowsShare
FROM $TOTAL_HISTORY
ORDER BY Date
;

$_LAST_DATA_PATH = EvaluateExpr($YT_SPECIALIST_DATA_FOLDER || '/' || DateTime::ToStringFormat($LAST_DATE, "%F"));
INSERT INTO $YT_SPEC_LAST_PATH WITH TRUNCATE 
SELECT 
  FLClientID
, FLName
, QAShows
, QAClicks
, QAClientCostUnit
, QAClientCount
, BSFLRank
, BSFLScore
, QAPrGoodShowsRank
, QAPrGoodShowsShare
, TableName(TablePath()) AS TableName
, QATopClientCost
FROM $_LAST_DATA_PATH
ORDER BY QAPrGoodShowsRank
;
