/* Рекомендация про минус-фразы

Тикет: OKK-2935

## Данные для проработки
1. В какой кампании больше всего подозрительного
Хотим подсказать, с чего лучше начать работу
Список кампаний с суммой показов и нашим прогнозом по подозрительному объему
- Надо ли показывать примеры запросов?
- Сразу разрешаем добавлять новые фразы в список единых на кампанию минус-фраз?
- Как подсказывать какие конкретно мнус-фразы стоит добавить?

-> проваливаемся в кампанию
Показываем самые подозрительные тройки: баннер, фразы, запросы.
Отображаем статистику фактических показов за последние 30-ть дней.
По какому сегменту показывать топ: баннеры, фразы или запросы?

2. В какой группе больше всего подозрительного
...как с кампаниями
-> проваливаемся в группу
...как с кампаниями
*/


USE hahn;

$YT_DIRECT_FL_PATH = "//home/direct/export/freelancers/freelancers_projects";
$YT_CA_RECOMMENDATIONS_PATH = "//home/vipplanners/ta_report/recommendations/current";
$YT_FL_RECOMMENDATIONS_PATH = "//home/vipplanners/freelance_info/export/recommendations";

-- Справочник специалистов и клиентов
-- только открытые сотрудничества
$OPEN_PROJECT = (
SELECT
  ClientID AS client_id
, FLClientID AS fl_client_id
, freelancer_name AS fl_name
FROM (
    SELECT SOME(TableRow())
    FROM $YT_DIRECT_FL_PATH
    WHERE
    -- проект актуален, специалист сотрудничает с клиентом
      finish_date IS NULL
    GROUP BY
      customer_client_id AS ClientID
    , freelancer_client_id AS FLClientID
)
FLATTEN COLUMNS
);

INSERT INTO $YT_FL_RECOMMENDATIONS_PATH WITH TRUNCATE
SELECT
  fl_client_id??0 AS fl_client_id
, fl_name??"" AS fl_name
, client_id??0 AS client_id
, login??"" AS login
, cid??0 AS cid
, campaign_name??"" AS campaign_name
, pid??0 AS pid
, shows??0 AS part_shows
, pr_bad_shows??0.0 AS pr_part_bad_shows
, exact_bad_shows??0.0 AS exact_part_bad_shows
, pr_bad_shows_share??0.0 AS pr_part_bad_shows_share
, exact_bad_shows_share??0.0 AS exact_part_bad_shows_share
, top_examples.0??"" AS title_db
, top_examples.1??"" AS body_db
, top_examples.2??"" AS phrase
, top_examples.3??"" AS query
, top_examples.4??0.0 AS pr_segment_bad_shows
FROM (
  SELECT
    f.fl_client_id AS fl_client_id
  , f.fl_name AS fl_name
  , r.client_id AS client_id
  , r.login AS login
  , r.cid AS cid
  , r.campaign_name AS campaign_name
  , r.pid AS pid
  , r.shows AS shows
  , r.pr_bad_shows AS pr_bad_shows
  , r.exact_bad_shows AS exact_bad_shows
  , r.pr_bad_shows_share AS pr_bad_shows_share
  , r.exact_bad_shows_share AS exact_bad_shows_share
  , r.top_examples AS top_examples
  FROM $YT_CA_RECOMMENDATIONS_PATH AS r
  JOIN $OPEN_PROJECT AS f
    USING (client_id)
  WHERE r.exact_bad_shows >= 1
)
FLATTEN BY top_examples
ORDER BY
  fl_client_id
, client_id
, cid
, pid
;
