-- ADCAMPAIGN-67: таблицы для дашборда про деньги по стриму "Эксперименты с настройками"
$TICKET_WEEKS = "//home/vipplanners/insights/data/startrek/tables/offers";
$VEC_IMPACT = "//home/vipplanners/insights/data/clientid_impact_vectors/weeks";
$RESULT = "//home/vipplanners/insights/data/dash_client_impact/weeks";
$RESULT_ACC = "//home/vipplanners/insights/data/dash_client_impact/weeks_acc";

USE hahn;

$week_from_mls = ($mls) -> {
  $date = DateTime::FromMilliseconds($mls);
  $year = DateTime::GetYear($date);
  $week = DateTime::GetWeekOfYear($date);
  RETURN CAST($year * 100 + $week AS Uint32);
};

-- список пар (Клиент, Дата), от которых замерять — ADCAMPAIGN-142
$ticket_wl = (
SELECT
  client_id
, activation_week
, COUNT(key) AS ticket_count
, MAX_BY(key, time_spent_total_h) AS main_ticket_key
, MAX_BY(type, time_spent_total_h) AS main_ticket_type
, SUM(time_spent_total_h) AS  time_spent_total_h
FROM $TICKET_WEEKS
WHERE
  -- Проверка на возраст последнего контакта 8_week_OK
  -- Берем в замер только задачи с возрастом контанкта не менее 8 недель.
  is_good_age  
  -- нет смысла смотреть свежие тикеты, по ним нет статистики
  AND (CurrentUtcDateTime() - DateTime::FromMilliseconds(task_activation_mls)) > Interval("P7D")
GROUP BY
  client_id
, task_activation_week AS activation_week
);

-- Дополнительная информаци для сегментации
$crm = (
SELECT
  client_id
, COALESCE(SOME(client_name), "") || "# " || Cast(client_id AS String) AS client_name
, SOME(curr_client_tier) ?? "Неизвестно" AS tier
, SOME(curr_office_rus) ?? "Неизвестно" AS client_root_office_17
FROM `home/comdep-analytics/public/client_tiers/fact/latest`
GROUP BY client_id
);

-- clientid_impact_vectors/weeks: вектора с прогнозными и фактическими затратами
-- для пар (client_id, week).
-- Для ускорения clientid_impact_vectors/weeks изначально считается для неполного
-- набора пар, подробнее тут: 
--  - https://a.yandex-team.ru/arc/trunk/arcadia/client_analytics/insights/vec_impact.sql
INSERT INTO @weeks WITH TRUNCATE
SELECT
  Unwrap(st.activation_week) AS activation_week
, Unwrap(st.client_id) AS ticket_client_id
, st.ticket_count AS ticket_count
, ci.test_mean_dd_full_impact ?? 0.0 AS test_mean_dd_full_impact
, ci.test_median_dd_full_impact ?? 0.0 AS test_median_dd_full_impact
, ci.test_mean_dd_impact ?? 0.0 AS test_mean_dd_impact
, ci.test_median_dd_impact ?? 0.0 AS test_median_dd_impact
, ci.test_wavg_dd_impact ?? 0.0 AS test_wavg_dd_impact
, ci.test_wavg2_dd_impact ?? 0.0 AS test_wavg2_dd_impact
, ci.test_self_impact ?? 0.0 AS test_self_impact
, ci.is_new_client AS is_new_client
, ci.is_good_history AS is_good_history
, IF(ci.is_good_history, ci.test_median_dd_impact, ci.test_self_impact) AS test_combined_impact
, ListSum(ci.test_future_vec) ?? 0.0 AS test_actual_cost
, ListSum(ci.validate_mean_future_vec) ?? 0.0 AS validate_mean_future_vec
, ListLast(ci.test_accum_impact_vec) ?? 0.0 AS test_impact_cost
, ListLength(ci.test_accum_impact_vec) * 1.0 ?? 0.0 AS test_impact_weeks
, st.main_ticket_key ?? 0 AS main_ticket_key
, CASE st.main_ticket_type
    WHEN "income" THEN "Входящие"
    WHEN "newFeature" THEN "Проактив"
    ELSE "Неизвестно"
  END AS main_ticket_type
, st.time_spent_total_h ?? 0.0 AS time_spent_total_h
, crm.tier ?? "Неизвестно" AS test_client_tier
, crm.client_name AS client_name
, crm.client_root_office_17 ?? "Неизвестно" AS client_root_office_17
FROM $VEC_IMPACT AS ci
RIGHT JOIN $ticket_wl AS st
   ON st.client_id = ci.test_client_id
  AND st.activation_week = ci.test_impact_week
LEFT JOIN $crm AS crm
  ON crm.client_id = st.client_id
WHERE ListLength(ci.test_future_vec) > 0
; COMMIT;

INSERT INTO $RESULT WITH TRUNCATE
SELECT *
FROM @weeks
ORDER BY activation_week, ticket_client_id
; COMMIT;

INSERT INTO $RESULT_ACC WITH TRUNCATE
SELECT
  activation_week
, main_ticket_type
, SUM(test_impact_cost) OVER week_w AS test_impact_cost
, SUM(test_mean_dd_full_impact) OVER week_w AS test_mean_dd_full_impact
, SUM(test_mean_dd_impact) OVER week_w AS test_mean_dd_impact
, SUM(test_median_dd_full_impact) OVER week_w AS test_median_dd_full_impact
, SUM(test_median_dd_impact) OVER week_w AS test_median_dd_impact
, SUM(test_wavg_dd_impact) OVER week_w AS test_wavg_dd_impact
, SUM(test_wavg2_dd_impact) OVER week_w AS test_wavg2_dd_impact
, SUM(test_combined_impact) OVER week_w AS test_combined_impact
FROM (
  SELECT
    activation_week
  , main_ticket_type
  , SUM(test_impact_cost) ?? 0.0 AS test_impact_cost
  , SUM(test_mean_dd_full_impact) ?? 0.0 AS test_mean_dd_full_impact
  , SUM(test_mean_dd_impact) ?? 0.0 AS test_mean_dd_impact
  , SUM(test_median_dd_full_impact) ?? 0.0 AS test_median_dd_full_impact
  , SUM(test_median_dd_impact) ?? 0.0 AS test_median_dd_impact
  , SUM(test_wavg_dd_impact) ?? 0.0 AS test_wavg_dd_impact
  , SUM(test_wavg2_dd_impact) ?? 0.0 AS test_wavg2_dd_impact
  , SUM(test_combined_impact) ?? 0.0 AS test_combined_impact
  FROM @weeks
  GROUP BY activation_week, main_ticket_type
)
WINDOW week_w AS (PARTITION BY main_ticket_type ORDER BY activation_week)
ORDER BY activation_week
;
