/* ADCAMPAIGN-69: Склейка инсайтов

Пути до инсайтов:
 - //home/vipplanners/insights/{dev,pub}/{insight_id}/{dimension}/{date}

Пути до склееных инсайтов:
 - //home/vipplanners/insights/{dev,pub}/merged/{dimension}

1. Каждый инсайт подключается явно
2. Для каждого инсайта берется последняя версия
3. Инсайты внутри клиента оссортированы по профициту на час работы
5. Склееная таблица упорядочена по клиентам, на каждого клиента одна запись
*/
USE hahn;

DEFINE SUBQUERY $last_table($folder) AS
  SELECT MAX_BY(Path, CAST(TableName(Path) AS Date)) AS Path
  FROM FOLDER($folder)
; END DEFINE;

$_dev_client_id = (
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/1/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/2/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/3/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/4/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/5/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/6/client_id")
);
$dev_client_id = (
SELECT AGGREGATE_LIST(Path)
FROM $_dev_client_id
);

$_dev_counterparty = (
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/1/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/2/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/3/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/4/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/5/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/dev/6/counterparty")
);
$dev_counterparty = (
SELECT AGGREGATE_LIST(Path)
FROM $_dev_counterparty
);

$_pub_client_id = (
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/1/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/2/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/3/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/4/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/5/client_id") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/6/client_id")
);
$pub_client_id = (
SELECT AGGREGATE_LIST(Path)
FROM $_pub_client_id
);

$_pub_counterparty = (
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/1/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/2/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/3/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/4/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/5/counterparty") UNION ALL
  SELECT Path FROM $last_table("//home/vipplanners/insights/pub/6/counterparty")
);
$pub_counterparty = (
SELECT AGGREGATE_LIST(Path)
FROM $_pub_counterparty
);

$profit = ($data) -> {
  $tmp = Yson::ConvertToDict($data)["diff_ltv30"];
  RETURN IF($tmp IS NULL, 0.0, Yson::ConvertToDouble($tmp));
};
$eta = ($data) -> {
  $tmp = Yson::ConvertToDict($data)["task_est_hours"];
  RETURN IF($tmp IS NULL, 0.0, Yson::ConvertToDouble($tmp));
};

INSERT INTO `//home/vipplanners/insights/dev/merged/client_id` WITH TRUNCATE 
SELECT
  client_id
, Yson::SerializePretty(Yson::From(top_insight_full)) AS top_insight_full
, Yson::SerializePretty(Yson::From(top_insight_short)) AS top_insight_short
FROM (
  SELECT
    client_id
  , TOP_BY(TableRow(), $profit(data), 1000) AS top_insight_full
  , TOP_BY(
     AsStruct(
      insight_type AS id,
      $profit(data) AS profit,
      $eta(data) AS eta
    ),
    $profit(data),
    1000
  ) AS top_insight_short
  FROM EACH($dev_client_id)
  GROUP BY client_id
)
ORDER BY client_id
;

INSERT INTO `//home/vipplanners/insights/pub/merged/client_id` WITH TRUNCATE 
SELECT
  client_id
, Yson::SerializePretty(Yson::From(top_insight_full)) AS top_insight_full
, Yson::SerializePretty(Yson::From(top_insight_short)) AS top_insight_short
FROM (
  SELECT
    client_id
  , TOP_BY(TableRow(), $profit(data), 1000) AS top_insight_full
  , TOP_BY(
     AsStruct(
      insight_type AS id,
      $profit(data) AS profit,
      $eta(data) AS eta
    ),
    $profit(data),
    1000
  ) AS top_insight_short
  FROM EACH($pub_client_id)
  GROUP BY client_id
)
ORDER BY client_id
;

INSERT INTO `//home/vipplanners/insights/dev/merged/counterparty` WITH TRUNCATE 
SELECT
  counterparty
, Yson::SerializePretty(Yson::From(top_insight_full)) AS top_insight_full
, Yson::SerializePretty(Yson::From(top_insight_short)) AS top_insight_short
FROM (
  SELECT
    counterparty
  , TOP_BY(TableRow(), $profit(data), 1000) AS top_insight_full
  , TOP_BY(
     AsStruct(
      insight_type AS id,
      $profit(data) AS profit,
      $eta(data) AS eta
    ),
    $profit(data),
    1000
  ) AS top_insight_short
  FROM EACH($dev_counterparty)
  GROUP BY counterparty
)
ORDER BY counterparty
;

INSERT INTO `//home/vipplanners/insights/pub/merged/counterparty` WITH TRUNCATE 
SELECT
  counterparty
, Yson::SerializePretty(Yson::From(top_insight_full)) AS top_insight_full
, Yson::SerializePretty(Yson::From(top_insight_short)) AS top_insight_short
FROM (
  SELECT
    counterparty
  , TOP_BY(TableRow(), $profit(data), 1000) AS top_insight_full
  , TOP_BY(
     AsStruct(
      insight_type AS id,
      $profit(data) AS profit,
      $eta(data) AS eta
    ),
    $profit(data),
    1000
  ) AS top_insight_short
  FROM EACH($pub_counterparty)
  GROUP BY counterparty
)
ORDER BY counterparty
;
