/* ADCAMPAIGN-57: Клиенты без уточнений

Только по активным ТГО кампаниям на момент расчета.
Отбор происходит по порогу, оценивается доля показов 
случившихся на баннерах без расширений.
*/

$PERIOD_CALC = 30;
$INSIGHT_ID = 3;
$NOW = EvaluateExpr(CurrentUtcTimestamp());
$format_date = DateTime::Format("%Y-%m-%d");

$DIMENSION_1 = "client_id";
$DIMENSION_2 = "counterparty";
$YT_DST_1 = "home/vipplanners/insights/pub/" || CAST($INSIGHT_ID AS String) || '/' || $DIMENSION_1 || '/' || $format_date($NOW);
$YT_DST_2 = "home/vipplanners/insights/pub/" || CAST($INSIGHT_ID AS String) || '/' || $DIMENSION_2 || '/' || $format_date($NOW);

USE hahn;

-- Список таблиц для расчета за последние Ч дней.
$tables = (
SELECT TOP_BY(Path, CAST(TableName(Path) AS Date), 30)
FROM FOLDER(`home/comdep-cubes/direct/production/cube`)
);

-- Только активные кампании на момент расчета
DEFINE SUBQUERY $cids() AS
SELECT DISTINCT cid
FROM `home/direct/db/campaigns`
WHERE 
      statusActive = 'Yes'
  AND archived = 'No'
  AND OrderID > 0
  AND type = "text"
;
END DEFINE;

$count_callouts = ($additions) -> {
  RETURN Coalesce(Yson::GetLength(Yson::ConvertToDict($additions)["callout"]), 0);
};

-- Баннеры без БС
DEFINE SUBQUERY $bad_bids() AS
SELECT DISTINCT b.bid AS bid
FROM `//home/direct/db/banners` AS b
JOIN $cids() AS c
  ON b.cid = c.cid
WHERE b.banner_type = "text"
  AND b.statusModerate = "Yes"
  AND b.statusArch = "No"
  AND b.bid > 0
  AND $count_callouts(b.additions) < 1
; END DEFINE;


INSERT INTO @cid_stat WITH TRUNCATE 
SELECT 
  SOME(client_id) AS client_id
, cid
, SUM_IF(cost_rub_wo_nds, bad.bid > 0) AS cost_bad
, SUM_IF(clicks, bad.bid > 0) AS clicks_bad
, SUM_IF(shows, bad.bid > 0) AS shows_bad
, SUM(shows) AS shows
, SUM(clicks) AS clicks
, SUM(cost_rub_wo_nds) AS cost
FROM EACH($tables) AS c
LEFT SEMI JOIN $cids() AS wh  -- white_list
  ON c.cid = wh.cid
LEFT JOIN $bad_bids() AS bad
  ON c.bid = bad.bid
GROUP BY c.cid AS cid
HAVING SUM(cost_rub_wo_nds) > 0
; COMMIT;

INSERT INTO @counterparty_cid_stat WITH TRUNCATE
SELECT
  s.client_id AS client_id
, c.curr_counterparty_name AS counterparty
, s.cid AS cid
, s.cost_bad AS cost_bad
, s.clicks_bad AS clicks_bad
, s.shows_bad AS shows_bad
, s.shows AS shows
, s.clicks AS clicks
, s.cost AS cost
FROM @cid_stat AS s
JOIN `//home/comdep-analytics/public/client_tiers/fact/latest` AS c
  ON c.client_id = s.client_id
; COMMIT;

$_ltv = ($data) -> { 
  -- максимальный эффект назначен экспертно
  RETURN ($data.badness_pct / 100.0 * 0.01) * $data.client_cost_rub_wo_nds;
};
$_hours = ($data) -> {
  RETURN $data.cid_count * 0.08;
};

$add_forecasts = ($data) -> {
  $data = AddMember($data, "diff_ltv30", $_ltv($data));
  $data = AddMember($data, "task_est_hours", $_hours($data));
  RETURN $data;
};

INSERT INTO $YT_DST_1 WITH TRUNCATE
SELECT
  client_id
, $INSIGHT_ID AS insight_type
, DateTime::ToSeconds($NOW) AS insight_time
, Yson::SerializePretty(
    Yson::From(
      $add_forecasts(data)
    )
  ) AS data
FROM (
  SELECT 
    client_id
  , AsStruct(
      (SUM(shows_bad) * 1.0) / SUM(shows) * 100 AS badness_pct,  -- Доля показов с ошибкой
      SUM(shows) AS client_shows,                                -- Всего показов по активным ТГО кампаниям
      SUM(clicks) AS client_clicks,                              -- Всего кликов по активным ТГО кампаниям
      SUM(cost) AS client_cost_rub_wo_nds,                       -- Всего затрат по активным ТГО кампаниям
      SUM(shows_bad) AS client_shows_bad,                        -- Всего показов в проблемных группах по активным ТГО кампаниям
      SUM(cost_bad) AS client_cost_bad,                          -- Всего затрат в проблемных группах по активным ТГО кампаниям
      SUM(clicks_bad) AS client_clicks_bad,                      -- Всего кликов в проблемных группах по активным ТГО кампаниям
      TOP_BY(AsTuple(cid, cost), cost_bad, 100) AS cid_top_bad,  -- Топ активных ТГО кампаний по количеству плохих затрат
      COUNT_IF(shows_bad > 0) AS cid_count                       -- Количество кампаний с проблемой
  ) AS data
  FROM @cid_stat
  GROUP BY client_id
)
WHERE data.badness_pct > 30  -- Граница выбрана экспертно
  AND data.client_shows > 1000
;

INSERT INTO $YT_DST_2 WITH TRUNCATE
SELECT
  counterparty
, $INSIGHT_ID AS insight_type
, DateTime::ToSeconds($NOW) AS insight_time
, Yson::SerializePretty(
    Yson::From(
      $add_forecasts(data)
    )
  ) AS data
FROM (
  SELECT 
    counterparty
  , AsStruct(
      (SUM(shows_bad) * 1.0) / SUM(shows) * 100 AS badness_pct,  -- Доля показов с ошибкой
      SUM(shows) AS client_shows,                                -- Всего показов по активным ТГО кампаниям
      SUM(clicks) AS client_clicks,                              -- Всего кликов по активным ТГО кампаниям
      SUM(cost) AS client_cost_rub_wo_nds,                       -- Всего затрат по активным ТГО кампаниям
      SUM(shows_bad) AS client_shows_bad,                        -- Всего показов в проблемных группах по активным ТГО кампаниям
      SUM(cost_bad) AS client_cost_bad,                          -- Всего затрат в проблемных группах по активным ТГО кампаниям
      SUM(clicks_bad) AS client_clicks_bad,                      -- Всего кликов в проблемных группах по активным ТГО кампаниям
      TOP_BY(AsTuple(cid, cost), cost_bad, 100) AS cid_top_bad,  -- Топ активных ТГО кампаний по количеству плохих затрат
      COUNT_IF(shows_bad > 0) AS cid_count                       -- Количество кампаний с проблемой
  ) AS data
  FROM @counterparty_cid_stat
  GROUP BY counterparty
)
WHERE data.badness_pct > 30  -- Граница выбрана экспертно
  AND data.client_shows > 1000
;
