/* ADCAMPAIGN-25: Клиенты без картинок

Только по активным ТГО кампаниям с возможностью показов в сетях на момент расчета.
Отбор происходит по порогу, оценивается доля показов случившихся на баннерах без картинки.
*/


$PERIOD_CALC = 30;
$INSIGHT_ID = 2;
$NOW = EvaluateExpr(CurrentUtcTimestamp());
$format_date = DateTime::Format("%Y-%m-%d");

$DIMENSION_1 = "client_id";
$DIMENSION_2 = "counterparty";
$YT_DST_1 = "home/vipplanners/insights/pub/" || CAST($INSIGHT_ID AS String) || '/' || $DIMENSION_1 || '/' || $format_date($NOW);
$YT_DST_2 = "home/vipplanners/insights/pub/" || CAST($INSIGHT_ID AS String) || '/' || $DIMENSION_2 || '/' || $format_date($NOW);

USE hahn;

-- Список таблиц для расчета за последние Ч дней.
$tables = (
SELECT TOP_BY(Path, CAST(TableName(Path) AS Date), $PERIOD_CALC)
FROM FOLDER(`home/comdep-cubes/direct/production/cube`)
);

-- Только клиенты с возможностью показываться в сетях
DEFINE SUBQUERY $client_context_count() AS
SELECT 
  ClientID AS client_id
, COUNT_IF(platform  = "both") AS cid_both_count
, COUNT_IF(platform  = "context") AS cid_context_count
FROM `home/direct/db/campaigns`
WHERE 
      statusActive = 'Yes'
  AND archived = 'No'
  AND OrderID > 0
  AND type = "text"
GROUP BY ClientID
HAVING COUNT_IF(platform IN ("both", "context")) > 0
; END DEFINE ;

-- Только активные кампании на момент расчета
DEFINE SUBQUERY $cids() AS
SELECT DISTINCT cid, platform
FROM `home/direct/db/campaigns`
WHERE 
      statusActive = 'Yes'
  AND archived = 'No'
  AND OrderID > 0
  AND type = "text"
;
END DEFINE;

-- Баннеры без картинок в подходящих кампаниях
DEFINE SUBQUERY $bad_bids() AS
SELECT bid
FROM `//home/direct/db/banners` AS b
JOIN $cids() AS c
  ON b.cid = c.cid
WHERE
-- Условие отбора: https://a.yandex-team.ru/arc/trunk/arcadia/direct/jobs/src/main/resources/recommendations/addBannerExtensionSitelinksAdditionsHref.sql?rev=4719705#L62
      b.image_hash IS NULL
  AND b.creative_id IS NULL
  AND b.canvas_creative_id IS NULL
  AND b.performance_creative_id IS NULL
  AND b.video_addition_creative_id IS NULL
  AND b.banner_type = "text"
  AND b.statusModerate = "Yes"
  AND b.statusArch = "No"
  AND b.bid > 0
  AND c.platform IN ("both", "context")
GROUP BY b.bid AS bid
; END DEFINE;

INSERT INTO @cid_stat WITH TRUNCATE 
SELECT 
  SOME(cu.client_id) AS client_id
, cid
, SUM_IF(cost_rub_wo_nds, bad.bid > 0) AS cost_bad
, SUM_IF(clicks, bad.bid > 0) AS clicks_bad
, SUM_IF(shows, bad.bid > 0) AS shows_bad
, SUM(shows) AS shows
, SUM(clicks) AS clicks
, SUM(cost_rub_wo_nds) AS cost
, SOME(cid_context_count) AS cid_context_count
, SOME(cid_both_count) AS cid_both_count
, SOME(cp.platform) AS platform
FROM EACH($tables) AS cu
JOIN $client_context_count() AS cl
  ON cu.client_id = cl.client_id
JOIN $cids() AS cp
  ON cu.cid = cp.cid
LEFT JOIN $bad_bids() AS bad
  ON cu.bid = bad.bid
GROUP BY cu.cid AS cid
HAVING SUM(cost_rub_wo_nds) > 0
; COMMIT;

INSERT INTO @counterparty_cid_stat WITH TRUNCATE
SELECT
  s.client_id AS client_id
, c.curr_counterparty_name AS counterparty
, s.cid AS cid
, s.cost_bad AS cost_bad
, s.clicks_bad AS clicks_bad
, s.shows_bad AS shows_bad
, s.shows AS shows
, s.clicks AS clicks
, s.cost AS cost
, s.cid_context_count AS cid_context_count
, s.cid_both_count AS cid_both_count
, s.platform AS platform
FROM @cid_stat AS s
JOIN `//home/comdep-analytics/public/client_tiers/fact/latest` AS c
  ON c.client_id = s.client_id
; COMMIT;

$_ltv = ($data) -> { 
  -- максимальный эффект назначен экспертно
  RETURN ($data.badness_pct / 100.0 * 0.15) * $data.client_cost_rub_wo_nds;
};
$_hours = ($data) -> {
  -- 10-30 минут на добавление картинок в кампанию + 2 часа на разаделение, если надо
  RETURN $data.badness_pct / 100.0 * 0.5 * $data.cid_context_count + 2.0 * IF($data.cid_both_count > 0, 1, 0);
};

$add_forecasts = ($data) -> {
  $data = AddMember($data, "diff_ltv30", $_ltv($data));
  $data = AddMember($data, "task_est_hours", $_hours($data));
  RETURN $data;
};

INSERT INTO $YT_DST_1 WITH TRUNCATE
SELECT
  client_id
, $INSIGHT_ID AS insight_type
, DateTime::ToSeconds($NOW) AS insight_time
, Yson::SerializePretty(
    Yson::From(
      $add_forecasts(data)
    )
  ) AS data
FROM (
  SELECT
    client_id
  , AsStruct(
      (SUM(shows_bad) * 1.0) / SUM(shows) * 100 AS badness_pct,  -- Доля показов с ошибкой
      SUM(shows) AS client_shows,                                -- Всего показов по активным ТГО кампаниям
      SUM(clicks) AS client_clicks,                              -- Всего кликов по активным ТГО кампаниям
      SUM(cost) AS client_cost_rub_wo_nds,                       -- Всего затрат по активным ТГО кампаниям
      SUM(shows_bad) AS client_shows_bad,                        -- Всего показов в проблемных группах по активным ТГО кампаниям
      SUM(cost_bad) AS client_cost_bad,                          -- Всего затрат в проблемных группах по активным ТГО кампаниям
      SUM(clicks_bad) AS client_clicks_bad,                      -- Всего кликов в проблемных группах по активным ТГО кампаниям
      TOP_BY(
        AsTuple(cid, cost, platform),
        cost_bad,
        100
      ) AS cid_top_bad,                              -- Топ активным ТГО кампаний по количеству плохих затрат
      SOME(cid_context_count) AS cid_context_count,  -- Количество кампаний с возможностью показывать только в сетях
      SOME(cid_both_count) AS cid_both_count         -- Количество кампаний с возможностью показывать на сетях и поиске одновременно
  ) AS data
  FROM @cid_stat AS cs
  GROUP BY client_id
)
WHERE data.badness_pct > 10  -- Граница выбрана экспертно
  AND data.client_shows > 1000
;

INSERT INTO $YT_DST_2 WITH TRUNCATE
SELECT
  counterparty
, $INSIGHT_ID AS insight_type
, DateTime::ToSeconds($NOW) AS insight_time
, Yson::SerializePretty(
    Yson::From(
      $add_forecasts(data)
    )
  ) AS data
FROM (
  SELECT
    counterparty
  , AsStruct(
      (SUM(shows_bad) * 1.0) / SUM(shows) * 100 AS badness_pct,  -- Доля показов с ошибкой
      SUM(shows) AS client_shows,                                -- Всего показов по активным ТГО кампаниям
      SUM(clicks) AS client_clicks,                              -- Всего кликов по активным ТГО кампаниям
      SUM(cost) AS client_cost_rub_wo_nds,                       -- Всего затрат по активным ТГО кампаниям
      SUM(shows_bad) AS client_shows_bad,                        -- Всего показов в проблемных группах по активным ТГО кампаниям
      SUM(cost_bad) AS client_cost_bad,                          -- Всего затрат в проблемных группах по активным ТГО кампаниям
      SUM(clicks_bad) AS client_clicks_bad,                      -- Всего кликов в проблемных группах по активным ТГО кампаниям
      TOP_BY(
        AsTuple(cid, cost, platform),
        cost_bad,
        100
      ) AS cid_top_bad,                              -- Топ активным ТГО кампаний по количеству плохих затрат
      SOME(cid_context_count) AS cid_context_count,  -- Количество кампаний с возможностью показывать только в сетях
      SOME(cid_both_count) AS cid_both_count         -- Количество кампаний с возможностью показывать на сетях и поиске одновременно
  ) AS data
  FROM @counterparty_cid_stat AS cs
  GROUP BY counterparty
)
WHERE data.badness_pct > 10  -- Граница выбрана экспертно
  AND data.client_shows > 1000
;
