/* ADCAMPAIGN-30: Клиенты с потерями в текущих категориях

*/

$SUBSPACE = "pub";
$PERIOD_CALC = 30;
$INSIGHT_ID = 5;
$NOW = EvaluateExpr(CurrentUtcTimestamp());
$format_date = DateTime::Format("%Y-%m-%d");

$DIMENSION_1 = "client_id";
$DIMENSION_2 = "counterparty";
$YT_DST_1 = "home/vipplanners/insights/" || $SUBSPACE || '/' || CAST($INSIGHT_ID AS String) || '/' || $DIMENSION_1 || '/' || $format_date($NOW);
$YT_DST_2 = "home/vipplanners/insights/" || $SUBSPACE || '/' || CAST($INSIGHT_ID AS String) || '/' || $DIMENSION_2 || '/' || $format_date($NOW);

USE hahn;
-- Список таблиц для расчета за последние Ч дней.
$cube_tables = (
SELECT TOP_BY(Path, CAST(TableName(Path) AS Date), $PERIOD_CALC)
FROM FOLDER(`home/comdep-cubes/direct/production/cube`)
);

$good_banner_dict = (
SELECT 
  b.BannerID AS banner_id
, b.Category AS category_id
, wl.CategoryName AS category_name
, wl.Bootstrap AS bootstrap_name
FROM `//home/comdep-analytics/banner-categories/BannerIDCatalogia` AS b
JOIN `//home/vipplanners/insights/data/dict/bootstrap_categoryid` AS wl
  ON b.Category = wl.CategoryID
);


INSERT INTO @cube_stat WITH TRUNCATE
SELECT
  s.client_id AS client_id
, crm.curr_counterparty_name AS counterparty
, s.banner_id AS banner_id
, s.shows AS shows
, s.clicks AS clicks
, s.cost_rub_wo_nds AS cost_rub_wo_nds
, s.text_shows AS text_shows
, s.text_clicks AS text_clicks
, s.text_cost_rub_wo_nds AS text_cost_rub_wo_nds
, s.perfomance_shows AS perfomance_shows
, s.perfomance_clicks AS perfomance_clicks
, s.perfomance_cost_rub_wo_nds AS perfomance_cost_rub_wo_nds
, s.dynamic_shows AS dynamic_shows
, s.dynamic_clicks AS dynamic_clicks
, s.dynamic_cost_rub_wo_nds AS dynamic_cost_rub_wo_nds
FROM (
  SELECT 
    client_id
  , banner_id
  , SUM(shows) ?? 0 AS shows
  , SUM(clicks) ?? 0 AS clicks
  , SUM(cost_rub_wo_nds) ?? 0 AS cost_rub_wo_nds
  , SUM_IF(shows, campaign_type="text") ?? 0 AS text_shows
  , SUM_IF(clicks, campaign_type="text") ?? 0 AS text_clicks
  , SUM_IF(cost_rub_wo_nds, campaign_type="text") ?? 0 AS text_cost_rub_wo_nds
  , SUM_IF(shows, campaign_type="perfomance") ?? 0 AS perfomance_shows
  , SUM_IF(clicks, campaign_type="perfomance") ?? 0 AS perfomance_clicks
  , SUM_IF(cost_rub_wo_nds, campaign_type="perfomance") ?? 0 AS perfomance_cost_rub_wo_nds
  , SUM_IF(shows, campaign_type="dynamic") ?? 0 AS dynamic_shows
  , SUM_IF(clicks, campaign_type="dynamic") ?? 0 AS dynamic_clicks
  , SUM_IF(cost_rub_wo_nds, campaign_type="dynamic") ?? 0 AS dynamic_cost_rub_wo_nds
  FROM EACH($cube_tables)
  GROUP BY client_id, banner_id
) AS s
JOIN `//home/comdep-analytics/public/client_tiers/fact/latest` AS crm
  ON s.client_id = crm.client_id
; COMMIT;


$client_stat = (
SELECT
  client_id
, SOME(counterparty) AS counterparty
, SUM(shows) AS shows
, SUM(clicks) AS clicks
, SUM(cost_rub_wo_nds) AS cost_rub_wo_nds
, SUM(text_shows) AS text_shows
, SUM(text_clicks) AS text_clicks
, SUM(text_cost_rub_wo_nds) AS text_cost_rub_wo_nds
, SUM(perfomance_shows) AS perfomance_shows
, SUM(perfomance_clicks) AS perfomance_clicks
, SUM(perfomance_cost_rub_wo_nds) AS perfomance_cost_rub_wo_nds
, SUM(dynamic_shows) AS dynamic_shows
, SUM(dynamic_clicks) AS dynamic_clicks
, SUM(dynamic_cost_rub_wo_nds) AS dynamic_cost_rub_wo_nds
FROM @cube_stat
GROUP BY client_id
HAVING SUM(cost_rub_wo_nds) > 100
);

$counterparty_stat = (
SELECT
  counterparty
, SUM(shows) AS shows
, SUM(clicks) AS clicks
, SUM(cost_rub_wo_nds) AS cost_rub_wo_nds
, SUM(text_shows) AS text_shows
, SUM(text_clicks) AS text_clicks
, SUM(text_cost_rub_wo_nds) AS text_cost_rub_wo_nds
, SUM(perfomance_shows) AS perfomance_shows
, SUM(perfomance_clicks) AS perfomance_clicks
, SUM(perfomance_cost_rub_wo_nds) AS perfomance_cost_rub_wo_nds
, SUM(dynamic_shows) AS dynamic_shows
, SUM(dynamic_clicks) AS dynamic_clicks
, SUM(dynamic_cost_rub_wo_nds) AS dynamic_cost_rub_wo_nds
FROM @cube_stat
GROUP BY counterparty
HAVING SUM(cost_rub_wo_nds) > 100
);

$client_mediagroup_stat = (
SELECT 
  client_id
, category_id
, category_name
, bootstrap_name
, SUM(shows) AS shows
FROM @cube_stat AS b
JOIN $good_banner_dict AS mg
  ON b.banner_id = mg.banner_id
GROUP BY 
  b.client_id AS client_id
, mg.category_id AS category_id
, mg.category_name AS category_name
, mg.bootstrap_name AS bootstrap_name
-- фильтр отсечь мусорные на клиенте категории
-- если мусора останется много, можно фильтровать по проценту на клиенте
HAVING SUM(cost_rub_wo_nds) > 1000
);

$counterparty_mediagroup_stat = (
SELECT 
  counterparty
, category_id
, category_name
, bootstrap_name
, SUM(shows) AS shows
FROM @cube_stat AS b
JOIN $good_banner_dict AS mg
  ON b.banner_id = mg.banner_id
GROUP BY 
  b.counterparty AS counterparty
, mg.category_id AS category_id
, mg.category_name AS category_name
, mg.bootstrap_name AS bootstrap_name
-- фильтр отсечь мусорные на клиенте категории
-- если мусора останется много, можно фильтровать по проценту на клиенте
HAVING SUM(cost_rub_wo_nds) > 1000
);

$mediagroup_max_shows = (
SELECT
  category_id
, MAX(shows) AS shows
FROM $client_mediagroup_stat
GROUP BY category_id
);

$clientid_data = (
SELECT
  a.client_id AS client_id
, AsStruct(
    a.category_top_lost AS category_top_lost
  , a.badness_pct AS badness_pct
  , a.lost_shows AS lost_shows
  , a.category_count AS category_count
  , c.shows AS client_shows
  , c.clicks AS client_clicks
  , c.cost_rub_wo_nds AS client_cost_rub_wo_nds
  , c.text_shows AS client_text_shows
  , c.text_clicks AS client_text_clicks
  , c.text_cost_rub_wo_nds AS client_text_cost_rub_wo_nds
  , c.perfomance_shows AS client_perfomance_shows
  , c.perfomance_clicks AS client_perfomance_clicks
  , c.perfomance_cost_rub_wo_nds AS client_perfomance_cost_rub_wo_nds
  , c.dynamic_shows AS client_dynamic_shows
  , c.dynamic_clicks AS client_dynamic_clicks
  , c.dynamic_cost_rub_wo_nds AS client_dynamic_cost_rub_wo_nds
) AS data
FROM (
  SELECT
    client_id
  , TOP_BY(AsTuple(cm.category_name, cm.shows, mm.shows, cm.bootstrap_name), mm.shows - cm.shows, 100) AS category_top_lost
  , SUM(mm.shows - cm.shows) AS lost_shows
  , AVG(MIN_OF(100.0, (mm.shows - cm.shows) * 100.0 / cm.shows)) AS badness_pct
  , COUNT(*) AS category_count
  FROM $client_mediagroup_stat AS cm
  JOIN $mediagroup_max_shows AS mm
    ON cm.category_id = mm.category_id
  GROUP BY cm.client_id AS client_id
) AS a
JOIN $client_stat AS c
  ON a.client_id = c.client_id
WHERE lost_shows > 0
); COMMIT;

$counterparty_data = (
SELECT
  a.counterparty AS counterparty
, AsStruct(
    a.category_top_lost AS category_top_lost
  , a.badness_pct AS badness_pct
  , a.lost_shows AS lost_shows
  , a.category_count AS category_count
  , c.shows AS client_shows
  , c.clicks AS client_clicks
  , c.cost_rub_wo_nds AS client_cost_rub_wo_nds
  , c.text_shows AS client_text_shows
  , c.text_clicks AS client_text_clicks
  , c.text_cost_rub_wo_nds AS client_text_cost_rub_wo_nds
  , c.perfomance_shows AS client_perfomance_shows
  , c.perfomance_clicks AS client_perfomance_clicks
  , c.perfomance_cost_rub_wo_nds AS client_perfomance_cost_rub_wo_nds
  , c.dynamic_shows AS client_dynamic_shows
  , c.dynamic_clicks AS client_dynamic_clicks
  , c.dynamic_cost_rub_wo_nds AS client_dynamic_cost_rub_wo_nds
) AS data
FROM (
  SELECT
    counterparty
  , TOP_BY(AsTuple(cm.category_name, cm.shows, mm.shows, cm.bootstrap_name), mm.shows - cm.shows, 100) AS category_top_lost
  , SUM(mm.shows - cm.shows) AS lost_shows
  , AVG(MIN_OF(100.0, (mm.shows - cm.shows) * 100.0 / cm.shows)) AS badness_pct
  , COUNT(*) AS category_count
  FROM $counterparty_mediagroup_stat AS cm
  JOIN $mediagroup_max_shows AS mm
    ON cm.category_id = mm.category_id
  GROUP BY cm.counterparty AS counterparty
) AS a
JOIN $counterparty_stat AS c
  ON a.counterparty = c.counterparty
WHERE lost_shows > 0
);

$_ltv = ($data) -> {
  -- полезность найденного завсит от того на сколько суммарный объем значим в сравнении со статистикой по клиенту
  $criticality = MIN_OF($data.lost_shows * 1.0 / $data.client_shows, 1);
  -- максимальный эффект назначен экспертно
  $MAX = 0.25;
  $coef = $MAX * $criticality;
  RETURN $coef * $data.client_cost_rub_wo_nds;
};
$_hours = ($data) -> {
  -- 1.5 час на категорию
  RETURN $data.category_count * 1.5;
};

$add_forecasts = ($data) -> {
  $data = AddMember($data, "diff_ltv30", $_ltv($data));
  $data = AddMember($data, "task_est_hours", $_hours($data));
  RETURN $data;
};

INSERT INTO $YT_DST_1 WITH TRUNCATE
SELECT
  client_id
, $INSIGHT_ID AS insight_type
, DateTime::ToSeconds($NOW) AS insight_time
, Yson::SerializePretty(
    Yson::From(
      $add_forecasts(data)
    )
  ) AS data
FROM $clientid_data
;

INSERT INTO $YT_DST_2 WITH TRUNCATE
SELECT
  counterparty
, $INSIGHT_ID AS insight_type
, DateTime::ToSeconds($NOW) AS insight_time
, Yson::SerializePretty(
    Yson::From(
      $add_forecasts(data)
    )
  ) AS data
FROM $counterparty_data
;
