/* ADCAMPAIGN-52: проактив по международным клиентам


Назначение:
- офферы — таблица для "менеджера", без детализации, можно использоваться для 
  подсчетов на уровне клиентов
- инсайты — таблица для специалиста. Столбец `Сводка` должен содержать в себе 
  максимум полезной информации для работы над каждым конкретным клиентом.

Группа клиентов — список клиентов для проработки одним специалистом. 
Договорились использовать на старте, в будущем организовать единую на всех 
специалистов очередь. Вычисляется так: Digest::NumericHash($client_id) % 12

Обновляется еженедельно вместе с офферами по всем клиентам внутри графа Нирваны: 
https://nirvana.yandex-team.ru/flow/a7bb096d-7e6c-49df-b557-58be11890bf7.
*/
USE hahn;

$MAX_AGE = Interval("P56D");  -- 8 недель * 7 дней = 56 дней
$MIN_COST = 10000;  -- https://st.yandex-team.ru/ADCAMPAIGN-52#5cd01c54db1dbe0020b7251b
$RESERVED_GROUP_ID = AsList(6, 7, 10);  -- ADCAMPAIGN-90
$TIER = "International";

$NOW_DT = EvaluateExpr(CurrentUtcDateTime());

$get_age = ($x) -> {
  RETURN $NOW_DT - DateTime::FromMilliseconds($x);
};

-- black list
-- Причины в ADCAMPAIGN-144
$manager_bl = AsTuple(
  "kalinina",
  "elenawillems",
  "bashlycheva"
);

$client_id_bl = (
SELECT client_id
FROM `//home/vipplanners/insights/data/startrek/tables/issues`
WHERE client_id > 0
  AND Coalesce($get_age(resolved_mls), Interval("P0D")) < $MAX_AGE
);

INSERT INTO `//home/vipplanners/insights/proactivity/international/offer` WITH TRUNCATE 
SELECT *
FROM `//home/vipplanners/insights/proactivity/total/offer`
WHERE `Тир клиента` = $TIER
  AND `Затраты клиента за 30 дней` > $MIN_COST
  AND `Группа клиентов` NOT IN $RESERVED_GROUP_ID
  AND `Клиент, №` NOT IN COMPACT $client_id_bl
  AND `Дней с затратами за 90 дней` > 60  -- ADCAMPAIGN-121
  AND `Логин менеджера` NOT IN $manager_bl
ORDER BY `Группа клиентов`, `Ранг оффера`
;

INSERT INTO `//home/vipplanners/insights/proactivity/international/insight` WITH TRUNCATE 
SELECT *
FROM `//home/vipplanners/insights/proactivity/total/insight`
WHERE `Тир клиента` = $TIER
  AND `Затраты клиента за 30 дней` > $MIN_COST
  AND `Группа клиентов` NOT IN $RESERVED_GROUP_ID
  AND `Клиент, №` NOT IN COMPACT $client_id_bl
  AND `Дней с затратами за 90 дней` > 60  -- ADCAMPAIGN-121
  AND `Логин менеджера` NOT IN $manager_bl
ORDER BY `Группа клиентов`, `Ранг оффера`, `Профит/Ч с инсайта` DESC
;
