/* ADCAMPAIGN-135: отобранные в проактив для тир-3


Назначение:
- офферы — таблица для "менеджера", без детализации, можно использоваться для 
  подсчетов на уровне клиентов
- инсайты — таблица для специалиста. Столбец `Сводка` должен содержать в себе 
  максимум полезной информации для работы над каждым конкретным клиентом.

Группа клиентов — список клиентов для проработки одним специалистом. 
Договорились использовать на старте, в будущем организовать единую на всех 
специалистов очередь. Вычисляется так: Digest::NumericHash($client_id) % 12

Обновляется еженедельно вместе с офферами по всем клиентам внутри графа Нирваны: 
https://nirvana.yandex-team.ru/flow/a828033f-eaff-4462-ad34-5fde270dc248.
*/

USE hahn;

$MAX_AGE = Interval("P56D");  -- 8 недель * 7 дней = 56 дней
$T3A_MIN_COST = 10000;  -- https://st.yandex-team.ru/ADCAMPAIGN-52#5cd01c54db1dbe0020b7251b
$T3B_MIN_COST = 250000;  -- разделил на две части по просьбе Вовк Марины ADCAMPAIGN-135
$RESERVED_GROUP_ID = AsList(6, 7, 10);  -- ADCAMPAIGN-90
$TIER = ("t3", "t3 Regions", "t3 Center");

$NOW_DT = EvaluateExpr(CurrentUtcDateTime());

$get_age = ($x) -> {
  RETURN $NOW_DT - DateTime::FromMilliseconds($x);
};

-- black list
$client_id_bl = (
SELECT client_id
FROM `//home/vipplanners/insights/data/startrek/tables/issues`
WHERE client_id > 0
  AND Coalesce($get_age(resolved_mls), Interval("P0D")) < $MAX_AGE
);

$tier3a_client = (
SELECT DISTINCT client_id
FROM hahn.`home/comdep-analytics/public/client_tiers/fact/latest`
WHERE curr_client_tier IN $TIER
  AND curr_office_rus IN ("Москва", "Санкт-Петербург")
);

$tier3b_client = (
SELECT DISTINCT client_id
FROM hahn.`home/comdep-analytics/public/client_tiers/fact/latest`
WHERE curr_client_tier IN $TIER
  AND curr_office_rus NOT IN ("Москва", "Санкт-Петербург")
);

-- Москва и  Санкт-Петербург
INSERT INTO `//home/vipplanners/insights/proactivity/tier3a/offer` WITH TRUNCATE 
SELECT *
FROM `//home/vipplanners/insights/proactivity/total/offer`
WHERE `Тир клиента` IN $TIER
  AND `Затраты клиента за 30 дней` > $T3A_MIN_COST
  AND `Группа клиентов` NOT IN $RESERVED_GROUP_ID
  AND `Клиент, №` NOT IN COMPACT $client_id_bl
  AND `Клиент, №` IN COMPACT $tier3a_client
  AND `Дней с затратами за 90 дней` > 60  -- ADCAMPAIGN-121
ORDER BY `Группа клиентов`, `Ранг оффера`
;

INSERT INTO `//home/vipplanners/insights/proactivity/tier3a/insight` WITH TRUNCATE 
SELECT *
FROM `//home/vipplanners/insights/proactivity/total/insight`
WHERE `Тир клиента` IN $TIER
  AND `Затраты клиента за 30 дней` > $T3A_MIN_COST
  AND `Группа клиентов` NOT IN $RESERVED_GROUP_ID
  AND `Клиент, №` NOT IN COMPACT $client_id_bl
  AND `Клиент, №` IN COMPACT $tier3a_client
  AND `Дней с затратами за 90 дней` > 60  -- ADCAMPAIGN-121
ORDER BY `Группа клиентов`, `Ранг оффера`, `Профит/Ч с инсайта` DESC
;

-- Регионы
INSERT INTO `//home/vipplanners/insights/proactivity/tier3b/offer` WITH TRUNCATE 
SELECT *
FROM `//home/vipplanners/insights/proactivity/total/offer`
WHERE `Тир клиента` IN $TIER
  AND `Затраты клиента за 30 дней` > $T3B_MIN_COST
  AND `Группа клиентов` NOT IN $RESERVED_GROUP_ID
  AND `Клиент, №` NOT IN COMPACT $client_id_bl
  AND `Клиент, №` IN COMPACT $tier3b_client
  AND `Дней с затратами за 90 дней` > 60  -- ADCAMPAIGN-121
ORDER BY `Группа клиентов`, `Ранг оффера`
;

INSERT INTO `//home/vipplanners/insights/proactivity/tier3b/insight` WITH TRUNCATE 
SELECT *
FROM `//home/vipplanners/insights/proactivity/total/insight`
WHERE `Тир клиента` IN $TIER
  AND `Затраты клиента за 30 дней` > $T3B_MIN_COST
  AND `Группа клиентов` NOT IN $RESERVED_GROUP_ID
  AND `Клиент, №` NOT IN COMPACT $client_id_bl
  AND `Клиент, №` IN COMPACT $tier3b_client
  AND `Дней с затратами за 90 дней` > 60  -- ADCAMPAIGN-121
ORDER BY `Группа клиентов`, `Ранг оффера`, `Профит/Ч с инсайта` DESC
;
