/* ADCAMPAIGN-75: фиксировать на YT историю по клиентам

Шаблон запроса для использования в Нирване.

- расшифровка хешей
- конвертация в статическую таблицу
- для переноса на основной кластер
*/

USE Markov;

-- В папку складываются две очереди, но переносится только ADSPRO
$QUEUE_MAP = AsDict(
  ("5ccf44a0db1dbe0020b5fde4", "ADSPRO"),  -- https://st-api.yandex-team.ru/front/queues/ADSPRO
  ("5cd1fd58e8661d001f2009b5", "ADSPROTEST")  -- https://st-api.yandex-team.ru/front/queues/ADSPROTEST
);

$DUMMY_COMP_NAME = "empty_component";

$parse_components = ($x) -> {
  $dummy_components = AsList($DUMMY_COMP_NAME);
  $components = Coalesce(Yson::ConvertToStringList($x), $dummy_components);
  RETURN IF(ListHasItems($components), $components, $dummy_components);
};

$parse_tags = ($x) -> {
  $dummy_tags = ListCreate(String);
  RETURN Coalesce(Yson::ConvertToStringList($x), $dummy_tags);
};

$parse_key = ($x) -> {
  RETURN Cast(String::SplitToList($x, '-', true, false, 1)[1] AS Uint64);
};

$parse_campaignIDs = ($cid) -> {
  RETURN ListMap(String::SplitToList($cid, ";, \n\r", false, true), ($x) -> {RETURN Cast($x AS Int64)});
};

$get_datetime_mls = ($fields) -> {
  $datetime = Yson::ConvertToString(Yson::ConvertToDict($fields)["TrackTheTimeWithSeconds"]);
  RETURN Datetime::ToMilliseconds(DateTime::MakeTimestamp(DateTime::ParseIso8601($datetime)));
};

INSERT INTO {{output1}} WITH TRUNCATE
-- INSERT INTO `//tmp/vipplanners/users/n-bar/adspro` WITH TRUNCATE
SELECT 
  SOME(client_id) AS client_id
, key
, SOME(type) AS type
, SOME(start) AS start_mls
, SOME(resolved) AS resolved_mls
, SOME(tracked_date_mls) AS tracked_date_mls
, SOME(resolution) AS resolution
, SOME(status) AS status
, SOME(time_spent_h + time_spent_add_h) AS time_spent_total_h
, SOME(campaign_ids) AS new_campaign_ids
, SOME(ListCreate(Int64)) AS new_group_ids  -- заглушка до TOOLSUP-51393
, ListFilter(AGGREGATE_LIST(Coalesce(c.name, component_id)), ($x) -> {RETURN $x != $DUMMY_COMP_NAME}) AS components
, SOME(tags) AS tags
FROM (
  SELECT
    $QUEUE_MAP[queue] AS queue
  , $parse_key(q.key) AS key
  , r.key AS resolution
  , s.key AS status 
  , t.key AS type
  , Yson::ConvertToInt64(Yson::ConvertToDict(customFields)["clientId"]) ?? 0 AS client_id
  , Yson::ConvertToDouble(Yson::ConvertToDict(customFields)["timeSpentOnTheTask"]) ?? 0. AS time_spent_h
  , Yson::ConvertToDouble(Yson::ConvertToDict(customFields)["accountingForAddTime"]) ?? 0. AS time_spent_add_h
  , $get_datetime_mls(customFields) AS tracked_date_mls
  , $parse_campaignIDs(Yson::ConvertToString(Yson::ConvertToDict(customFields)["campaignIDs"])) AS campaign_ids
  , $parse_components(q.components) AS components
  , $parse_tags(q.tags) AS tags
  , q.start AS start
  , q.resolved AS resolved
  FROM {{input1}} AS q
  -- FROM `//home/startrek/tables/prod/yandex-team/queue/adspro/issues` AS q
  LEFT JOIN `//home/startrek/tables/prod/yandex-team/common/resolutions` AS r
    ON q.resolution = r.id
  LEFT JOIN `//home/startrek/tables/prod/yandex-team/common/statuses` AS s
    ON q.status = s.id
  LEFT JOIN `//home/startrek/tables/prod/yandex-team/common/types` AS t
    ON q.type = t.id
) AS q
FLATTEN BY q.components AS component_id
LEFT JOIN {{input2}} AS c
-- LEFT JOIN `//home/startrek/tables/prod/yandex-team/queue/adspro/components` AS c
  ON q.component_id = c.id
WHERE q.queue = "ADSPRO"
GROUP BY q.queue AS queue, q.key AS key
ORDER BY client_id
;
