-- ADCAMPAIGN-65: недельные вектора с затратами по рекламодателям

$HISTORY_MAX_SIZE = 12;  -- Недели из https://st.yandex-team.ru/ADVERTANALYTICS-5174#5d0b76c5c68ba400205b95b9
$FUTURE_MAX_SIZE = 12;
-- начали работать в марте-апреле, количества недель с начала 2019 года должно быть достаточно
$FIRST_WEEK = 201909;  -- Неделя начиная с которой оставить вектора

USE hahn;

$parse_week = ($x) -> {
  $date = CAST($x AS Date);
  $year = DateTime::GetYear($date);
  $week = DateTime::GetWeekOfYear($date);
  RETURN CAST($year * 100 + $week AS Uint32);
};

$client_id_week_stat = (
SELECT 
  cube_week
, client_id
, CAST(SUM(cost) AS Uint32) ?? 0u AS cost
FROM RANGE(`//home/comdep-cubes/direct/production/hypercubes/clients`, `2019`)
GROUP BY 
  $parse_week(cube_date) AS cube_week
, client_id
HAVING 
      MAX(DateTime::GetDayOfWeek(CAST(cube_date AS Date))) = 7
  AND MIN(DateTime::GetDayOfWeek(CAST(cube_date AS Date))) = 1
);

-- Полный вектор затрат по клиенту с даты создания клиента
-- периоды без затрат включены
$client_cost_vec = (
SELECT 
  client_id
, TOP_BY(
    AsStruct(
      Unwrap(cube_week) AS cube_week,
      cost AS cost
  )
  , cube_week
  , 144) AS cost_vec  -- 144 недели -> 3 год, ограничение из головы, пока больше не планировали
FROM $client_id_week_stat
GROUP BY client_id
);

$make_filter = ($date) -> {
  RETURN ($x) -> {RETURN $x.cube_week > $date};
};

-- Разбивка вектора по клиенту по cube_week
-- history_vec — информация известная на cube_week
-- future_vec — информация из будущего
INSERT INTO `//home/vipplanners/insights/data/clientid_cost_vectors/weeks` WITH TRUNCATE
SELECT 
  c.client_id AS client_id
, cube_week
-- порядок по возрасту от cube_week, от меньшего к большему
, ListTake(ListReverse(ListExtract(ListTakeWhile(cost_vec, $make_filter(cube_week)), "cost")), $FUTURE_MAX_SIZE) AS future_vec
-- порядок по возрасту от cube_week, от меньшего к большему
-- +1 что бы захватить текущую дату
, ListTake(ListExtract(ListSkipWhile(cost_vec, $make_filter(cube_week)), "cost"), $HISTORY_MAX_SIZE + 1) AS history_vec
FROM $client_id_week_stat AS c
JOIN $client_cost_vec AS v USING (client_id)
WHERE cube_week >= $FIRST_WEEK
ORDER BY client_id, cube_week
;
